package com.ejianc.business.income.service;

import com.ejianc.business.income.bean.ProductionEntity;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.business.income.history.ProductionHistoryVo;
import com.ejianc.business.income.vo.ProductionDetailVo;
import com.ejianc.business.income.vo.ProductionVo;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * <p>
 * 产值进度 服务类
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
public interface IProductionService extends IBaseService<ProductionEntity> {

    CommonResponse<ProductionVo> saveOrUpdate(ProductionVo productionVo);

    ProductionVo queryDetail(Long id);

    void deleteProduction(List<ProductionVo> vos);

    ProductionHistoryVo queryProductionHistory(Long id);

    List<ProductionDetailVo> detailRef(Long id);

    List<ProductionVo> queryTotalFinishTaxMny(List<Long> orgIds, Integer yearFlag);

}
