/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.income.bean.QuoteEntity;
import com.ejianc.business.income.history.QuoteHistoryVo;
import com.ejianc.business.income.service.IQuoteService;
import com.ejianc.business.income.utils.DateUtil;
import com.ejianc.business.income.utils.NCUtil;
import com.ejianc.business.income.vo.QuoteVo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/quote"})
public class QuoteController {
    @Autowired
    private IQuoteService quoteService;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<QuoteVo> saveOrUpdate(@RequestBody QuoteVo vo) {
        CommonResponse<QuoteVo> response = this.quoteService.saveOrUpdate(vo);
        return response;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<QuoteVo> queryDetail(@RequestParam Long id) {
        QuoteVo vo = this.quoteService.queryDetail(id);
        return CommonResponse.success((Object)vo);
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<QuoteEntity>> pageList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime", "desc");
        NCUtil.voucherParam(param);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.quoteService.queryPage(param, false));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<QuoteVo> vos) {
        this.quoteService.deleteQuote(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/queryQuoteHistory"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<QuoteHistoryVo> queryQuoteHistory(@RequestParam Long id) {
        QuoteHistoryVo vo = this.quoteService.queryQuoteHistory(id);
        return CommonResponse.success((Object)vo);
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime", "desc");
        param.setPageIndex(1);
        param.setPageSize(-1);
        NCUtil.voucherParam(param);
        IPage pageData = this.quoteService.queryPage(param, false);
        HashMap beans = new HashMap();
        List list = new ArrayList();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), QuoteVo.class);
            list.forEach(vo -> vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription()));
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("quote-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryDefaultDate"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<QuoteVo> queryDefaultDate(Long contractId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        queryParam.getOrderMap().put("quoteDate", "desc");
        List list = this.quoteService.queryList(queryParam, false);
        Date nextMonth = CollectionUtils.isNotEmpty((Collection)list) ? DateUtil.nextMonth((Date)((QuoteEntity)((Object)list.get(0))).getQuoteDate()) : new Date();
        QuoteVo vo = new QuoteVo();
        vo.setQuoteDate(nextMonth);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"/getValidate"})
    @ResponseBody
    public CommonResponse<JSONObject> getValidate(@RequestParam(value="id", required=false) Long id, @RequestParam(value="contractId") Long contractId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam.getOrderMap().put("quoteDate", "desc");
        if (id != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)id));
        }
        List list = this.quoteService.queryList(queryParam);
        List allMonth = list.stream().map(x -> DateUtil.getYearAndMonth((Date)x.getQuoteDate())).distinct().collect(Collectors.toList());
        JSONObject json = new JSONObject();
        json.put("allMonth", allMonth);
        json.put("maxDate", CollectionUtils.isNotEmpty((Collection)list) ? DateUtil.getYearAndMonth((Date)((QuoteEntity)((Object)list.get(0))).getQuoteDate()) : null);
        queryParam.getParams().put("billState", new Parameter("not_in", (Object)"1,3"));
        List list2 = this.quoteService.queryList(queryParam);
        json.put("unEffective", (Object)(CollectionUtils.isNotEmpty((Collection)list2) ? 1 : 0));
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)json);
    }
}

