/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.income.bean.FinalizedEntity;
import com.ejianc.business.income.enums.FinalStageEnum;
import com.ejianc.business.income.mapper.FinalizedMapper;
import com.ejianc.business.income.service.IFinalizedService;
import com.ejianc.business.income.vo.FinalizedVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="finalizedService")
public class FinalizedServiceImpl
extends BaseServiceImpl<FinalizedMapper, FinalizedEntity>
implements IFinalizedService {
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "INCOME_FINALIZED";

    @Override
    public FinalizedVO saveOrUpdate(FinalizedVO saveOrUpdateVO) {
        Object billCode;
        FinalizedVO finalizedVO = null;
        FinalizedEntity entity = (FinalizedEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), FinalizedEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            finalizedVO = this.queryFinalizedList(entity.getProjectId(), entity.getContractId(), null);
            this.validateFinalStage(entity.getProjectId(), entity.getContractId(), entity.getFinalStage(), null);
            List<FinalizedEntity> list = this.queryFinalized(entity.getProjectId(), entity.getContractId());
        } else {
            finalizedVO = this.queryFinalizedList(entity.getProjectId(), entity.getContractId(), entity.getId());
            this.validateFinalStage(entity.getProjectId(), entity.getContractId(), entity.getFinalStage(), entity.getId());
            billCode = this.queryFinalized(entity.getProjectId(), entity.getContractId());
        }
        entity.setOrgId(InvocationInfoProxy.getOrgId());
        super.saveOrUpdate((Object)entity, false);
        FinalizedVO vo = (FinalizedVO)((Object)BeanMapper.map((Object)((Object)entity), FinalizedVO.class));
        return vo;
    }

    @Override
    public Boolean validateFinalStage(Long projectId, Long contractId, String finalStage, Long id) {
        boolean flag;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (!Objects.equals(null, projectId)) {
            wrapper.eq(FinalizedEntity::getProjectId, (Object)projectId);
        }
        if (!Objects.equals(null, id)) {
            wrapper.ne(BaseEntity::getId, (Object)id);
        }
        wrapper.eq(FinalizedEntity::getContractId, (Object)contractId);
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.list((Wrapper)wrapper);
        if (ListUtil.isEmpty((List)list)) {
            if (Objects.equals(finalStage, FinalStageEnum.\u7ec8\u5ba1.getCode())) {
                return true;
            }
            if (!Objects.equals(finalStage, FinalStageEnum.\u4e00\u5ba1.getCode())) {
                throw new BusinessException("\u8bf7\u5148\u5b8c\u6210\u4e00\u5ba1\uff01");
            }
        }
        if (flag = list.stream().anyMatch(entity -> entity.getFinalStage().equals(finalStage))) {
            throw new BusinessException("\u5df2\u5b58\u5728\u8be5\u5b9a\u6848\u9636\u6bb5\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01");
        }
        List finalStageList = list.stream().map(FinalizedEntity::getFinalStage).collect(Collectors.toList());
        if (Objects.equals(finalStage, FinalStageEnum.\u4e8c\u5ba1.getCode()) && !finalStageList.contains(FinalStageEnum.\u4e00\u5ba1.getCode())) {
            throw new BusinessException("\u8bf7\u5148\u5b8c\u6210\u4e00\u5ba1\uff01");
        }
        if (Objects.equals(finalStage, FinalStageEnum.\u4e09\u5ba1.getCode())) {
            if (!finalStageList.contains(FinalStageEnum.\u4e00\u5ba1.getCode()) && !finalStageList.contains(FinalStageEnum.\u4e8c\u5ba1.getCode())) {
                throw new BusinessException("\u8bf7\u5148\u5b8c\u6210\u4e00\u5ba1\uff01");
            }
            if (finalStageList.contains(FinalStageEnum.\u4e00\u5ba1.getCode()) && !finalStageList.contains(FinalStageEnum.\u4e8c\u5ba1.getCode())) {
                throw new BusinessException("\u8bf7\u5148\u5b8c\u6210\u4e8c\u5ba1\uff01");
            }
        }
        return true;
    }

    @Override
    public FinalizedVO queryFinalizedList(Long projectId, Long contractId, Long id) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (!Objects.equals(null, projectId)) {
            wrapper.eq(FinalizedEntity::getProjectId, (Object)projectId);
        }
        if (!Objects.equals(null, id)) {
            wrapper.ne(BaseEntity::getId, (Object)id);
        }
        wrapper.eq(FinalizedEntity::getContractId, (Object)contractId);
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.list((Wrapper)wrapper);
        if (ListUtil.isEmpty((List)list)) {
            return new FinalizedVO();
        }
        long count = list.stream().filter(entity -> entity.getBillState() != 1 && entity.getBillState() != 3).count();
        if (count > 0L) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u7684\u5de5\u7a0b\u5b9a\u6848\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\uff01");
        }
        return (FinalizedVO)((Object)BeanMapper.map(list.get(0), FinalizedVO.class));
    }

    @Override
    public List<FinalizedEntity> queryFinalized(Long projectId, Long contractId) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(FinalizedEntity::getProjectId, (Object)projectId);
        query.eq(FinalizedEntity::getContractId, (Object)contractId);
        query.eq(FinalizedEntity::getFinalStage, (Object)4);
        query.in(FinalizedEntity::getBillState, new Object[]{1, 3});
        query.eq(BaseEntity::getDr, (Object)0);
        List entities = super.list((Wrapper)query);
        if (ListUtil.isNotEmpty((List)entities)) {
            throw new BusinessException("\u5de5\u7a0b\u5b9a\u6848\u7ec8\u5ba1\u751f\u6548\u540e\u4e0d\u53ef\u518d\u505a\u5de5\u7a0b\u5b9a\u6848\uff01");
        }
        return entities;
    }
}

