/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.other.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.bean.OtherSettleEntity;
import com.ejianc.business.other.history.OtherSettleHistoryVO;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.service.IOtherSettleService;
import com.ejianc.business.other.vo.OtherSettleVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"otherSettle"})
public class OtherSettleController
implements Serializable {
    @Autowired
    private IOtherSettleService quoteService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IOtherContractService contractService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OtherSettleVO> saveOrUpdate(@RequestBody OtherSettleVO vo) {
        CommonResponse<OtherSettleVO> response = this.quoteService.saveOrUpdate(vo);
        return response;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OtherSettleVO> queryDetail(Long id) {
        OtherSettleEntity entity = (OtherSettleEntity)((Object)this.quoteService.selectById(id));
        OtherSettleVO vo = (OtherSettleVO)BeanMapper.map((Object)((Object)entity), OtherSettleVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OtherSettleVO>> pageList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.quoteService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OtherSettleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OtherSettleVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.in(BaseEntity::getId, ids);
        List finishEntities = this.quoteService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)finishEntities)) {
            List contractIds = finishEntities.stream().map(OtherSettleEntity::getContractId).collect(Collectors.toList());
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(OtherContractEntity::getIsFinish, (Object)0);
            updateWrapper.in(BaseEntity::getId, contractIds);
            this.contractService.update((Wrapper)updateWrapper);
        }
        this.quoteService.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryQuoteHistory"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OtherSettleHistoryVO> queryQuoteHistory(@RequestParam Long id) {
        OtherSettleHistoryVO vo = this.quoteService.queryQuoteHistory(id);
        return CommonResponse.success((Object)vo);
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime", "desc");
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage pageData = this.quoteService.queryPage(param, false);
        HashMap beans = new HashMap();
        List list = new ArrayList();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), OtherSettleVO.class);
            list.forEach(vo -> vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription()));
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("settle-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/verifyContract"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> verifyContract(@RequestParam Long contractId, @RequestParam(value="billId", required=false) Long billId) {
        int num;
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(OtherSettleEntity::getContractId, (Object)contractId);
        lambdaQuery.notIn(OtherSettleEntity::getBillState, new Object[]{1, 3});
        if (billId != null && billId > 0L) {
            lambdaQuery.ne(BaseEntity::getId, (Object)billId);
        }
        if ((num = this.quoteService.count((Wrapper)lambdaQuery)) > 0) {
            return CommonResponse.error((String)"\u8be5\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u5408\u540c\u7ed3\u7b97!");
        }
        return CommonResponse.success();
    }
}

