/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.income.utils.ComputeUtil;
import com.ejianc.business.other.bean.OtherChangeClauseEntity;
import com.ejianc.business.other.bean.OtherChangeDetailEntity;
import com.ejianc.business.other.bean.OtherChangeEntity;
import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.bean.OtherDetailEntity;
import com.ejianc.business.other.bean.OtherSupplementEntity;
import com.ejianc.business.other.history.OtherChangeHistoryVO;
import com.ejianc.business.other.mapper.OtherChangeMapper;
import com.ejianc.business.other.mapper.OtherContractMapper;
import com.ejianc.business.other.service.IOtherChangeClauseService;
import com.ejianc.business.other.service.IOtherChangeDetailService;
import com.ejianc.business.other.service.IOtherChangeService;
import com.ejianc.business.other.service.IOtherClauseService;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.service.IOtherDetailService;
import com.ejianc.business.other.service.IOtherSupplementService;
import com.ejianc.business.other.vo.OtherChangeClauseVO;
import com.ejianc.business.other.vo.OtherChangeDetailVO;
import com.ejianc.business.other.vo.OtherChangeVO;
import com.ejianc.business.other.vo.OtherClauseVO;
import com.ejianc.business.other.vo.OtherContractVO;
import com.ejianc.business.other.vo.OtherDetailVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="otherChangeService")
public class OtherChangeServiceImpl
extends BaseServiceImpl<OtherChangeMapper, OtherChangeEntity>
implements IOtherChangeService {
    private static final String CHANGE_BILL_CODE = "OTHER_IN_CHANGE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOtherChangeDetailService changeDetailService;
    @Autowired
    private IOtherChangeClauseService changeClauseService;
    @Autowired
    private IOtherContractService contractService;
    @Autowired
    private OtherChangeMapper changeMapper;
    @Autowired
    private OtherContractMapper contractMapper;
    @Autowired
    private IOtherDetailService detailsService;
    @Autowired
    private IOtherClauseService clauseService;
    @Autowired
    private IOtherSupplementService supplementService;

    @Override
    public CommonResponse<OtherChangeVO> saveOrUpdate(OtherChangeVO OtherChangeVO2) {
        OtherChangeDetailEntity detailslist;
        List entities;
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        OtherChangeEntity entity = null;
        String operateType = null;
        if (OtherChangeVO2.getId() != null && OtherChangeVO2.getId() > 0L) {
            if (StringUtils.isEmpty((CharSequence)OtherChangeVO2.getBillCode())) {
                OtherChangeVO2.setBillCode(null);
            }
            entity = (OtherChangeEntity)((Object)BeanMapper.map((Object)OtherChangeVO2, OtherChangeEntity.class));
            operateType = "edit";
        } else {
            if (null == OtherChangeVO2.getChangeVersion() || OtherChangeVO2.getChangeVersion() == 0) {
                OtherChangeVO2.setChangeVersion(Integer.valueOf(1));
            } else {
                OtherChangeVO2.setChangeVersion(Integer.valueOf(OtherChangeVO2.getChangeVersion() + 1));
            }
            if (2 == OtherChangeVO2.getChangeStatus()) {
                throw new BusinessException("\u5408\u540c\u5b58\u5728\u53d8\u66f4\u4e2d\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            if (StringUtils.isEmpty((CharSequence)OtherChangeVO2.getBillCode())) {
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(CHANGE_BILL_CODE, tenantId);
                if (billCode.isSuccess()) {
                    OtherChangeVO2.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            entity = (OtherChangeEntity)((Object)BeanMapper.map((Object)OtherChangeVO2, OtherChangeEntity.class));
            operateType = "add";
        }
        if (OtherChangeVO2.getId() != null && OtherChangeVO2.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(OtherChangeEntity::getBillCode, (Object)OtherChangeVO2.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)OtherChangeVO2.getId());
            lambda.ne(OtherChangeEntity::getContractId, (Object)OtherChangeVO2.getContractId());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(OtherChangeEntity::getBillCode, (Object)OtherChangeVO2.getBillCode());
            lambda.ne(OtherChangeEntity::getContractId, (Object)OtherChangeVO2.getContractId());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
        queryParam.getParams().put("bill_code", new Parameter("eq", (Object)OtherChangeVO2.getBillCode()));
        queryParam.getParams().put("id", new Parameter("ne", (Object)OtherChangeVO2.getContractId()));
        List entitiesc = this.contractService.queryList(queryParam, false);
        if (entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdaQuery.eq(OtherSupplementEntity::getMainContractId, (Object)OtherChangeVO2.getContractId());
        lambdaQuery.ne(OtherSupplementEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdaQuery.ne(OtherSupplementEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        int supnum = this.supplementService.count((Wrapper)lambdaQuery);
        if (supnum > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae!");
        }
        entity.setBillType("other");
        super.saveOrUpdate((Object)entity);
        List detailsVos = OtherChangeVO2.getCheckList();
        ArrayList<OtherChangeDetailEntity> saveOrUpldates = new ArrayList<OtherChangeDetailEntity>();
        ArrayList<Long> deleteIds = new ArrayList<Long>();
        if (operateType.equals("add")) {
            for (OtherChangeDetailVO detailsVo : detailsVos) {
                detailslist = (OtherChangeDetailEntity)((Object)BeanMapper.map((Object)detailsVo, OtherChangeDetailEntity.class));
                detailslist.setChangeId(entity.getId());
                detailslist.setContractId(entity.getContractId());
                detailslist.setContractDetailId(detailsVo.getId());
                detailslist.setId(null);
                detailslist.setBeforeChangeMny(detailsVo.getMny());
                detailslist.setBeforeChangePrice(detailsVo.getPrice());
                detailslist.setBeforeChangeNum(detailsVo.getNum());
                saveOrUpldates.add(detailslist);
            }
        } else {
            for (OtherChangeDetailVO detailsVo : detailsVos) {
                if ("add".equals(detailsVo.getRowState())) {
                    detailslist = (OtherChangeDetailEntity)((Object)BeanMapper.map((Object)detailsVo, OtherChangeDetailEntity.class));
                    detailslist.setChangeId(entity.getId());
                    detailslist.setContractId(entity.getContractId());
                    detailslist.setContractDetailId(detailsVo.getId());
                    detailslist.setId(null);
                    saveOrUpldates.add(detailslist);
                    continue;
                }
                if ("edit".equals(detailsVo.getRowState())) {
                    detailslist = (OtherChangeDetailEntity)((Object)BeanMapper.map((Object)detailsVo, OtherChangeDetailEntity.class));
                    saveOrUpldates.add(detailslist);
                    continue;
                }
                if (!"del".equals(detailsVo.getRowState())) continue;
                deleteIds.add(detailsVo.getId());
            }
        }
        if (saveOrUpldates.size() > 0) {
            this.changeDetailService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        if (deleteIds.size() > 0) {
            this.changeDetailService.removeByIds(deleteIds, false);
        }
        List clauseVos = OtherChangeVO2.getClauseList();
        ArrayList<OtherChangeClauseEntity> clauseList = new ArrayList<OtherChangeClauseEntity>();
        ArrayList<Long> deleteClauseIds = new ArrayList<Long>();
        for (OtherChangeClauseVO clauseVo : clauseVos) {
            OtherChangeClauseEntity detailslist2;
            if ("add".equals(clauseVo.getRowState())) {
                detailslist2 = (OtherChangeClauseEntity)((Object)BeanMapper.map((Object)clauseVo, OtherChangeClauseEntity.class));
                detailslist2.setChangeId(entity.getId());
                detailslist2.setContractId(entity.getContractId());
                detailslist2.setId(null);
                clauseList.add(detailslist2);
                continue;
            }
            if ("edit".equals(clauseVo.getRowState())) {
                detailslist2 = (OtherChangeClauseEntity)((Object)BeanMapper.map((Object)clauseVo, OtherChangeClauseEntity.class));
                clauseList.add(detailslist2);
                continue;
            }
            if (!"del".equals(clauseVo.getRowState())) continue;
            deleteClauseIds.add(clauseVo.getId());
        }
        if (clauseList.size() > 0) {
            this.changeClauseService.saveOrUpdateBatch(clauseList, clauseList.size(), false);
        }
        if (deleteClauseIds.size() > 0) {
            this.changeClauseService.removeByIds(deleteClauseIds, false);
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(OtherContractEntity::getChangingTaxMny, (Object)OtherChangeVO2.getContractTaxMny());
        updateWrapper.set(OtherContractEntity::getChangingMny, (Object)OtherChangeVO2.getContractMny());
        updateWrapper.set(OtherContractEntity::getChangeId, (Object)entity.getId());
        updateWrapper.set(OtherContractEntity::getChangeStatus, (Object)2);
        updateWrapper.set(OtherContractEntity::getChangeCode, (Object)entity.getBillCode());
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getContractId());
        this.contractService.update((Wrapper)updateWrapper);
        return CommonResponse.success((Object)this.queryDetail(entity.getId()));
    }

    @Override
    public OtherChangeVO queryDetail(Long id) {
        List clauses;
        OtherChangeEntity entity = (OtherChangeEntity)((Object)super.selectById((Serializable)id));
        OtherChangeVO OtherChangeVO2 = (OtherChangeVO)BeanMapper.map((Object)((Object)entity), OtherChangeVO.class);
        List checkList = OtherChangeVO2.getCheckList();
        if (checkList != null && checkList.size() > 0) {
            OtherChangeVO2.setCheckList(checkList);
        }
        if ((clauses = OtherChangeVO2.getClauseList()) != null && clauses.size() > 0) {
            OtherChangeVO2.setClauseList(clauses);
        }
        return OtherChangeVO2;
    }

    @Override
    public void deleteChange(List<OtherChangeVO> vos) {
        for (OtherChangeVO vo : vos) {
            OtherChangeEntity OtherChangeEntity2 = (OtherChangeEntity)((Object)super.selectById((Serializable)vo.getId()));
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(OtherContractEntity::getChangingTaxMny, (Object)BigDecimal.ZERO);
            updateWrapper.set(OtherContractEntity::getChangingMny, (Object)BigDecimal.ZERO);
            if (OtherChangeEntity2.getChangeVersion() == 1) {
                updateWrapper.set(OtherContractEntity::getChangeStatus, (Object)1);
            } else {
                updateWrapper.set(OtherContractEntity::getChangeStatus, (Object)3);
            }
            updateWrapper.eq(BaseEntity::getId, (Object)OtherChangeEntity2.getContractId());
            this.contractService.update((Wrapper)updateWrapper);
            super.removeById((Serializable)vo, false);
        }
    }

    @Override
    public OtherChangeHistoryVO queryChangeHistory(Long id) {
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        List changeEntities = this.changeMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"contract_id", (Object)id)).in((Object)"bill_state", billStatus)).orderByDesc((Object)"used_time"));
        OtherContractEntity OtherContractEntity2 = (OtherContractEntity)((Object)this.contractService.selectById(id));
        OtherChangeHistoryVO vo = new OtherChangeHistoryVO();
        vo.setIsFinish(OtherContractEntity2.getIsFinish());
        vo.setContractId(id);
        vo.setContractTaxMny(OtherContractEntity2.getContractTaxMny() == null ? BigDecimal.ZERO : OtherContractEntity2.getContractTaxMny());
        vo.setBaseTaxMoney(OtherContractEntity2.getBaseTaxMoney() == null ? BigDecimal.ZERO : OtherContractEntity2.getBaseTaxMoney());
        vo.setChangeStatus(OtherContractEntity2.getChangeStatus());
        BigDecimal changeMny = vo.getContractTaxMny().subtract(vo.getBaseTaxMoney());
        vo.setSumChangeMny(changeMny);
        BigDecimal sumChangeRate = BigDecimal.ZERO;
        if (vo.getBaseTaxMoney().compareTo(BigDecimal.ZERO) != 0) {
            sumChangeRate = changeMny.divide(vo.getBaseTaxMoney(), 8, 4).multiply(new BigDecimal(100));
        }
        vo.setSumScale(sumChangeRate);
        if (null != changeEntities && changeEntities.size() > 0) {
            List OtherChangeVOs = BeanMapper.mapList((Iterable)changeEntities, OtherChangeVO.class);
            for (OtherChangeVO cvo : OtherChangeVOs) {
                String changeTime = new SimpleDateFormat("yyyyMMdd").format(cvo.getChangeTime());
                String historyBillCode = cvo.getBeforeContractName() + "-" + changeTime + "-" + cvo.getChangeVersion();
                cvo.setHistoryBillCode(historyBillCode);
                BigDecimal subtract = ComputeUtil.safeSub(cvo.getContractTaxMny(), cvo.getBeforeChangeTaxMny());
                BigDecimal changeRate = BigDecimal.ZERO;
                if (cvo.getBeforeChangeTaxMny() != null && cvo.getBeforeChangeTaxMny().compareTo(BigDecimal.ZERO) != 0) {
                    changeRate = ComputeUtil.safeDiv(subtract, cvo.getBeforeChangeTaxMny()).setScale(8, 4).multiply(new BigDecimal(100));
                }
                cvo.setScale(changeRate);
            }
            vo.setChangeRecord(OtherChangeVOs);
        }
        return vo;
    }

    @Override
    public OtherContractVO queryDetailChange(Long id) {
        OtherContractEntity entity = (OtherContractEntity)((Object)this.contractMapper.selectById(id));
        if (entity != null) {
            OtherContractVO OtherContractVO2 = (OtherContractVO)BeanMapper.map((Object)((Object)entity), OtherContractVO.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contractId", new Parameter("eq", (Object)OtherContractVO2.getId()));
            queryParam.getParams().put("change_type", new Parameter("ne", (Object)5));
            List purchaseDetailss = this.detailsService.queryList(queryParam, false);
            if (purchaseDetailss != null && purchaseDetailss.size() > 0) {
                for (OtherDetailEntity cdEntity : purchaseDetailss) {
                    cdEntity.setRowState("edit");
                }
                List resultMapList = BeanMapper.mapList((Iterable)purchaseDetailss, OtherDetailVO.class);
                OtherContractVO2.setCheckList(resultMapList);
            }
            QueryParam query = new QueryParam();
            query.getParams().put("contractId", new Parameter("eq", (Object)OtherContractVO2.getId()));
            query.getOrderMap().put("createTime", "asc");
            List clauses = this.clauseService.queryList(query, false);
            if (clauses != null && clauses.size() > 0) {
                List clauseVoList = BeanMapper.mapList((Iterable)clauses, OtherClauseVO.class);
                for (OtherClauseVO ccv : clauseVoList) {
                    ccv.setRowState("add");
                }
                OtherContractVO2.setClauseList(clauseVoList);
            }
            OtherContractVO2.setBeforeChangeTaxMny(entity.getContractTaxMny());
            OtherContractVO2.setBillState(null);
            OtherContractVO2.setCreateUserCode(null);
            OtherContractVO2.setCreateTime(null);
            OtherContractVO2.setUpdateUserCode(null);
            OtherContractVO2.setUpdateTime(null);
            OtherContractVO2.setChangeReason(null);
            return OtherContractVO2;
        }
        return null;
    }
}

