/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.finance.api.IReceiveManageApi;
import com.ejianc.business.finance.vo.SumReceiveVO;
import com.ejianc.business.income.service.CommonBillCodeService;
import com.ejianc.business.other.bean.OtherClauseEntity;
import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.bean.OtherDetailEntity;
import com.ejianc.business.other.mapper.OtherContractMapper;
import com.ejianc.business.other.service.IOtherClauseService;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.service.IOtherDetailService;
import com.ejianc.business.other.vo.OtherClauseVO;
import com.ejianc.business.other.vo.OtherContractVO;
import com.ejianc.business.other.vo.OtherDetailVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceOpenRecordVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="otherContractService")
public class OtherContractServiceImpl
extends BaseServiceImpl<OtherContractMapper, OtherContractEntity>
implements IOtherContractService {
    private static final String INCOME_CONTRACT_BILL_CODE = "OTHER_IN_CONTRACT";
    @Autowired
    private OtherContractMapper contractMapper;
    @Autowired
    private IOtherDetailService detailsService;
    @Autowired
    private IOtherClauseService clauseService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IReceiveManageApi receiveManageApi;
    @Autowired
    private IInvoiceApi invoiceApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private CommonBillCodeService commonBillCodeService;

    @Override
    public CommonResponse<OtherContractVO> saveOrUpdate(OtherContractVO otherContractVO) {
        List entities;
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        OtherContractEntity entity = null;
        String operateType = null;
        if (otherContractVO.getId() != null && otherContractVO.getId() > 0L) {
            if (StringUtils.isEmpty((CharSequence)otherContractVO.getBillCode())) {
                throw new BusinessException("\u7f16\u7801\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            entity = (OtherContractEntity)((Object)BeanMapper.map((Object)otherContractVO, OtherContractEntity.class));
            operateType = "edit";
        } else {
            if (StringUtils.isEmpty((CharSequence)otherContractVO.getBillCode())) {
                String code = this.commonBillCodeService.getCodeByOrgId(otherContractVO.getOrgId(), INCOME_CONTRACT_BILL_CODE, (BaseVO)otherContractVO);
                otherContractVO.setBillCode(code);
            }
            otherContractVO.setIsFinish(Integer.valueOf(0));
            entity = (OtherContractEntity)((Object)BeanMapper.map((Object)otherContractVO, OtherContractEntity.class));
            operateType = "add";
        }
        if (otherContractVO.getId() != null && otherContractVO.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(OtherContractEntity::getBillCode, (Object)otherContractVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)otherContractVO.getId());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(OtherContractEntity::getBillCode, (Object)otherContractVO.getBillCode());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        entity.setSupplementFlag(0);
        entity.setBaseTaxMoney(entity.getContractTaxMny());
        entity.setBaseMoney(entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());
        entity.setBeforeChangeMny(entity.getContractMny());
        entity.setBillType("other");
        super.saveOrUpdate((Object)entity);
        List detailsVos = otherContractVO.getCheckList();
        ArrayList<OtherDetailEntity> saveOrUpldates = new ArrayList<OtherDetailEntity>();
        ArrayList<Long> deleteIds = new ArrayList<Long>();
        for (OtherDetailVO detailsVo : detailsVos) {
            OtherDetailEntity detailslist;
            detailsVo.setChangeType(Integer.valueOf(0));
            if ("add".equals(detailsVo.getRowState())) {
                detailslist = (OtherDetailEntity)((Object)BeanMapper.map((Object)detailsVo, OtherDetailEntity.class));
                detailslist.setContractId(entity.getId());
                detailslist.setId(null);
                saveOrUpldates.add(detailslist);
                continue;
            }
            if ("edit".equals(detailsVo.getRowState())) {
                detailslist = (OtherDetailEntity)((Object)BeanMapper.map((Object)detailsVo, OtherDetailEntity.class));
                saveOrUpldates.add(detailslist);
                continue;
            }
            if (!"del".equals(detailsVo.getRowState())) continue;
            deleteIds.add(detailsVo.getId());
        }
        if (saveOrUpldates.size() > 0) {
            this.detailsService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        if (deleteIds.size() > 0) {
            this.detailsService.removeByIds(deleteIds, false);
        }
        List clauseVos = otherContractVO.getClauseList();
        ArrayList<OtherClauseEntity> clauseList = new ArrayList<OtherClauseEntity>();
        ArrayList<Long> deleteClauseIds = new ArrayList<Long>();
        for (OtherClauseVO clauseVo : clauseVos) {
            OtherClauseEntity detailslist;
            if ("add".equals(clauseVo.getRowState())) {
                detailslist = (OtherClauseEntity)((Object)BeanMapper.map((Object)clauseVo, OtherClauseEntity.class));
                detailslist.setContractId(entity.getId());
                clauseList.add(detailslist);
                continue;
            }
            if ("edit".equals(clauseVo.getRowState())) {
                detailslist = (OtherClauseEntity)((Object)BeanMapper.map((Object)clauseVo, OtherClauseEntity.class));
                clauseList.add(detailslist);
                continue;
            }
            if (!"del".equals(clauseVo.getRowState())) continue;
            deleteClauseIds.add(clauseVo.getId());
        }
        if (clauseList.size() > 0) {
            this.clauseService.saveOrUpdateBatch(clauseList, clauseList.size(), false);
        }
        if (deleteClauseIds.size() > 0) {
            this.clauseService.removeByIds(deleteClauseIds, false);
        }
        return CommonResponse.success((Object)this.queryDetail(entity.getId()));
    }

    @Override
    public OtherContractVO queryDetail(Long id) {
        OtherContractEntity entity = (OtherContractEntity)((Object)this.contractMapper.selectById(id));
        if (entity != null) {
            List clauses;
            OtherContractVO otherContractVO = (OtherContractVO)BeanMapper.map((Object)((Object)entity), OtherContractVO.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contractId", new Parameter("eq", (Object)otherContractVO.getId()));
            queryParam.getParams().put("change_type", new Parameter("ne", (Object)5));
            QueryParam query = new QueryParam();
            query.getParams().put("contractId", new Parameter("eq", (Object)otherContractVO.getId()));
            query.getOrderMap().put("createTime", "desc");
            List check = this.detailsService.queryList(query, false);
            if (check != null && check.size() > 0) {
                List checkVoList = BeanMapper.mapList((Iterable)check, OtherDetailVO.class);
                otherContractVO.setCheckList(checkVoList);
            }
            if ((clauses = this.clauseService.queryList(query, false)) != null && clauses.size() > 0) {
                List clauseVoList = BeanMapper.mapList((Iterable)clauses, OtherClauseVO.class);
                otherContractVO.setClauseList(clauseVoList);
            }
            return otherContractVO;
        }
        return null;
    }

    @Override
    public void deleteContract(List<OtherContractVO> vos) {
        for (OtherContractVO vo : vos) {
            this.detailsService.deleteByContractId(vo.getId());
            this.clauseService.deleteByContractId(vo.getId());
            this.contractMapper.deleteById(vo.getId());
        }
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        HashMap<String, Object> resp = new HashMap();
        QueryWrapper wrapper = OtherContractServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.select(new String[]{"round(sum(base_tax_money),2) as originalAmount, round(sum(contract_tax_mny),2) as curAmount"});
        resp = super.getMap((Wrapper)wrapper);
        return resp;
    }

    @Override
    public Date getSignDate(Long id) {
        return this.contractMapper.getSignDate(id);
    }

    @Override
    public OtherContractEntity queryFinanceHistory(Long id) {
        OtherContractEntity otherContractEntity = (OtherContractEntity)((Object)((OtherContractMapper)this.baseMapper).selectById(id));
        CommonResponse sumReceiveVOList = this.receiveManageApi.getSumReceiveVOList(id);
        if (!sumReceiveVOList.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        otherContractEntity.setReceiveVOList(((SumReceiveVO)sumReceiveVOList.getData()).getReceiveVOList());
        return otherContractEntity;
    }

    @Override
    public InvoiceOpenRecordVO queryTaxHistory(Long id) {
        OtherContractEntity otherContractEntity = (OtherContractEntity)((Object)((OtherContractMapper)this.baseMapper).selectById(id));
        CommonResponse invoiceOpenRecord = this.invoiceApi.getInvoiceOpenRecord(id);
        if (invoiceOpenRecord.isSuccess()) {
            InvoiceOpenRecordVO data = (InvoiceOpenRecordVO)invoiceOpenRecord.getData();
            data.setContractTaxMny(otherContractEntity.getContractTaxMny());
            return data;
        }
        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
    }

    @Override
    public OtherContractVO contractDetail(Long id) {
        OtherContractEntity entity = (OtherContractEntity)((Object)this.contractMapper.selectById(id));
        OtherContractVO otherContractVO = (OtherContractVO)BeanMapper.map((Object)((Object)entity), OtherContractVO.class);
        OtherContractVO vo = new OtherContractVO();
        vo.setId(otherContractVO.getId());
        vo.setContractName(otherContractVO.getContractName());
        vo.setContractTaxMny(otherContractVO.getContractTaxMny());
        vo.setTaxRate(otherContractVO.getTaxRate());
        vo.setProjectId(otherContractVO.getProjectId());
        vo.setProjectName(otherContractVO.getProjectName());
        vo.setCustomerId(otherContractVO.getCustomerId());
        vo.setCustomerName(otherContractVO.getCustomerName());
        vo.setContractorUnit(otherContractVO.getContractorUnit());
        vo.setContractorUnitName(otherContractVO.getContractorUnitName());
        vo.setOrgId(otherContractVO.getOrgId());
        vo.setOrgName(otherContractVO.getOrgName());
        vo.setVersion(otherContractVO.getVersion());
        return vo;
    }
}

