package com.ejianc.business.income.bean;

import java.math.BigDecimal;

import com.ejianc.framework.skeleton.template.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableName;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 签证洽商索赔
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
@TableName("ejc_income_claim")
public class ClaimEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 项目
     */
    @TableField("project_id")
    private Long projectId;

    /**
     * 组织
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 单据编号
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 合同主键
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 变更摘要
     */
    @TableField("change_summary")
    private String changeSummary;

    /**
     * 变更类型，1-现场签证，2-变更洽商，3-索赔
     */
    @TableField("change_type")
    private Integer changeType;

    /**
     * 签证类型，档案
     */
    @TableField("visa_type")
    private Long visaType;

    /**
     * 发生金额
     */
    @TableField("occur_mny")
    private BigDecimal occurMny;

    /**
     * 批复金额
     */
    @TableField("reply_mny")
    private BigDecimal replyMny;

    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;

    /**
     * 发生日期
     */
    @TableField("occur_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date occurDate;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 单据状态
     */
    @TableField("bill_state")
    private Integer billState;

    /**
     * 合同名称
     */
    @TableField("contract_name")
    private String contractName;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 经办人名称
     */
    @TableField("employee_name")
    private String employeeName;

    /**
     * 组织名称
     */
    @TableField("org_name")
    private String orgName;

    /**
     * 累计产值进度金额
     */
    @TableField("sum_production_mny")
    private BigDecimal sumProductionMny;
    /**
     * 累计产值进度金额
     */
    @TableField("sum_production_tax_mny")
    private BigDecimal sumProductionTaxMny;
    /**
     * 累计甲方报量金额
     */
    @TableField("sum_quote_mny")
    private BigDecimal sumQuoteMny;
    /**
     * 累计甲方报量金额
     */
    @TableField("sum_quote_tax_mny")
    private BigDecimal sumQuoteTaxMny;
    @TableField(exist = false)
    private String changeTypeName;

    /**
     * 税率
     */
    @TableField("tax_rate")
    private BigDecimal taxRate;
    /**
     * 发生金额
     */
    @TableField("occur_tax_mny")
    private BigDecimal occurTaxMny;

    /**
     * 批复金额
     */
    @TableField("reply_tax_mny")
    private BigDecimal replyTaxMny;


    @TableField(exist = false)
    @SubEntity(serviceName = "ClaimDetailService", pidName = "claimId")
    private List<ClaimDetailEntity> checkList = new ArrayList<>();

    public BigDecimal getSumQuoteTaxMny() {
        return sumQuoteTaxMny;
    }

    public void setSumQuoteTaxMny(BigDecimal sumQuoteTaxMny) {
        this.sumQuoteTaxMny = sumQuoteTaxMny;
    }

    public BigDecimal getSumProductionTaxMny() {
        return sumProductionTaxMny;
    }

    public void setSumProductionTaxMny(BigDecimal sumProductionTaxMny) {
        this.sumProductionTaxMny = sumProductionTaxMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getOccurTaxMny() {
        return occurTaxMny;
    }

    public void setOccurTaxMny(BigDecimal occurTaxMny) {
        this.occurTaxMny = occurTaxMny;
    }

    public BigDecimal getReplyTaxMny() {
        return replyTaxMny;
    }

    public void setReplyTaxMny(BigDecimal replyTaxMny) {
        this.replyTaxMny = replyTaxMny;
    }

    public String getChangeTypeName() {
        return changeTypeName;
    }

    public void setChangeTypeName(String changeTypeName) {
        this.changeTypeName = changeTypeName;
    }

    public BigDecimal getSumProductionMny() {
        return sumProductionMny;
    }

    public void setSumProductionMny(BigDecimal sumProductionMny) {
        this.sumProductionMny = sumProductionMny;
    }

    public BigDecimal getSumQuoteMny() {
        return sumQuoteMny;
    }

    public void setSumQuoteMny(BigDecimal sumQuoteMny) {
        this.sumQuoteMny = sumQuoteMny;
    }

    public List<ClaimDetailEntity> getCheckList() {
        return checkList;
    }

    public void setCheckList(List<ClaimDetailEntity> checkList) {
        this.checkList = checkList;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getChangeSummary() {
        return changeSummary;
    }

    public void setChangeSummary(String changeSummary) {
        this.changeSummary = changeSummary;
    }

    public Integer getChangeType() {
        return changeType;
    }

    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }

    public Long getVisaType() {
        return visaType;
    }

    public void setVisaType(Long visaType) {
        this.visaType = visaType;
    }

    public BigDecimal getOccurMny() {
        return occurMny;
    }

    public void setOccurMny(BigDecimal occurMny) {
        this.occurMny = occurMny;
    }

    public BigDecimal getReplyMny() {
        return replyMny;
    }

    public void setReplyMny(BigDecimal replyMny) {
        this.replyMny = replyMny;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public Date getOccurDate() {
        return occurDate;
    }

    public void setOccurDate(Date occurDate) {
        this.occurDate = occurDate;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @Override
    public String toString() {
        return "ClaimEntity{" +
                "projectId=" + projectId +
                ", orgId=" + orgId +
                ", billCode=" + billCode +
                ", contractId=" + contractId +
                ", changeSummary=" + changeSummary +
                ", changeType=" + changeType +
                ", visaType=" + visaType +
                ", occurMny=" + occurMny +
                ", replyMny=" + replyMny +
                ", employeeId=" + employeeId +
                ", occurDate=" + occurDate +
                ", memo=" + memo +
                ", billState=" + billState +
                ", contractName=" + contractName +
                ", projectName=" + projectName +
                ", employeeName=" + employeeName +
                ", orgName=" + orgName +
                "}";
    }
}
