package com.ejianc.business.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.income.bean.*;
import com.ejianc.business.income.history.SupplementHistoryVo;
import com.ejianc.business.income.service.*;
import com.ejianc.business.income.utils.TreeNodeBUtil;
import com.ejianc.business.income.vo.*;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.income.mapper.SupplementMapper;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 补充协议实体
 *
 * @author generator
 *
 */
@Service("supplementService")
public class SupplementServiceImpl extends BaseServiceImpl<SupplementMapper, SupplementEntity> implements ISupplementService{

    private static final String SUPPLEMENT_BILL_CODE = "INCOME_SUPPLEMENT";

    @Autowired
    private IContractService contractService;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IChangeService changeService;

    @Autowired
    private ISupplementDetailService supplementDetailService;

    @Override
    public SupplementVO insertOrUpdate(SupplementVO supplementVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        SupplementEntity entity = null;
        List<SupplementEntity> entities = null;

        //补充协议只能存在一条未生效的
        LambdaQueryWrapper<SupplementEntity> lambdaQuery = Wrappers.<SupplementEntity>lambdaQuery();
        lambdaQuery.eq(SupplementEntity::getTenantId, tenantId);
        lambdaQuery.eq(SupplementEntity::getMainContractId, supplementVO.getMainContractId());
        if(supplementVO.getId() != null && supplementVO.getId() > 0) {
            lambdaQuery.ne(SupplementEntity::getId, supplementVO.getId());
        }
        lambdaQuery.ne(SupplementEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdaQuery.ne(SupplementEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count(lambdaQuery);
        if(num > 0){
            throw new BusinessException("该合同已存在未生效的补充协议!");
        }

        //补充协议只能存在一条未生效的
        LambdaQueryWrapper<ChangeEntity> lambdachange = Wrappers.<ChangeEntity>lambdaQuery();
        lambdachange.eq(ChangeEntity::getTenantId, tenantId);
        lambdachange.eq(ChangeEntity::getContractId, supplementVO.getMainContractId());
        lambdachange.ne(ChangeEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(ChangeEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
        int changeNum = changeService.count(lambdachange);
        if(changeNum > 0){
            throw new BusinessException("该合同已存在未生效的变更单!");
        }
        if(StringUtils.isEmpty(supplementVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(SUPPLEMENT_BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                supplementVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        if(supplementVO.getId() != null && supplementVO.getId() > 0) {
            //修改 校验合同编号唯一
            LambdaQueryWrapper<SupplementEntity> lambda = Wrappers.<SupplementEntity>lambdaQuery();
            lambda.eq(SupplementEntity::getBillCode, supplementVO.getBillCode());
            lambda.eq(SupplementEntity::getTenantId, tenantId);
            lambda.ne(SupplementEntity::getId, supplementVO.getId());
            entities = super.list(lambda);
        }else{
            LambdaQueryWrapper<SupplementEntity> lambda = Wrappers.<SupplementEntity>lambdaQuery();
            lambda.eq(SupplementEntity::getBillCode, supplementVO.getBillCode());
            lambda.eq(SupplementEntity::getTenantId, tenantId);
            entities = super.list(lambda);
        }

        if(entities != null && entities.size() > 0) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }

        SupplementEntity supplementEntity = BeanMapper.map(supplementVO, SupplementEntity.class);
        //保存前清空主键和父主键，重新生成
        List<SupplementDetailEntity> checkList = supplementEntity.getCheckList();
        if(CollectionUtils.isNotEmpty(checkList) && null == supplementEntity.getId()){
            for(SupplementDetailEntity cdEntity : checkList){
                cdEntity.setId(null);
                cdEntity.setParentId(null);
            }
        }
        supplementEntity.setBillType("income");
        super.saveOrUpdate(supplementEntity, false);

        List<SupplementDetailEntity> supplementDetailEntities = supplementEntity.getCheckList();
        if(CollectionUtils.isNotEmpty(supplementDetailEntities)){
            Map<String,Long> idMap=new HashMap<>();
            for(SupplementDetailEntity cdEntity : supplementDetailEntities){
                idMap.put(cdEntity.getTid(),cdEntity.getId());
                cdEntity.setChangeType(0);
            }
            for(SupplementDetailEntity cdEntity : supplementDetailEntities){
                if(StringUtils.isNotEmpty(cdEntity.getTpid())){
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
            supplementDetailService.saveOrUpdateBatch(supplementDetailEntities, supplementDetailEntities.size(), false);
        }
        return queryDetail(supplementEntity.getId());
    }

    @Override
    public SupplementVO queryDetail(Long id) {
        SupplementEntity supplementEntity = super.selectById(id);
        SupplementVO supplementVO =  BeanMapper.map(supplementEntity, SupplementVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, id));
        queryParam.getOrderMap().put("detailIndex", "asc");
        List<SupplementDetailEntity> detailEntityList = supplementDetailService.queryList(queryParam, false);
        if(CollectionUtils.isNotEmpty(detailEntityList)) {
            for(SupplementDetailEntity cdEntity : detailEntityList){
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId()!= null&&cdEntity.getParentId()>0?cdEntity.getParentId().toString():"");
                cdEntity.setRowState("edit");
            }
            List<SupplementDetailVO> resultMapList = BeanMapper.mapList(detailEntityList, SupplementDetailVO.class);
            supplementVO.setCheckList(TreeNodeBUtil.buildTree(resultMapList));
        }
        return supplementVO;
    }

    @Override
    public SupplementVO addConvertByConId(Long id) {
        ContractEntity contractVO = contractService.selectById(id);
        SupplementVO supplementVO = new SupplementVO();
        supplementVO.setProjectId(contractVO.getProjectId());
        supplementVO.setProjectName(contractVO.getProjectName());
        supplementVO.setOrgId(contractVO.getOrgId());
        supplementVO.setOrgName(contractVO.getOrgName());
        supplementVO.setContractorUnit(contractVO.getContractorUnit());
        supplementVO.setContractorUnitName(contractVO.getContractorUnitName());
        supplementVO.setCustomerId(contractVO.getCustomerId());
        supplementVO.setCustomerName(contractVO.getCustomerName());
        supplementVO.setTaxRate(contractVO.getTaxRate());
        supplementVO.setSupplementFlag(1);
        supplementVO.setContractStatus(2);
        supplementVO.setEmployeeId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
        supplementVO.setMainContractId(contractVO.getId());
        supplementVO.setMainContractCode(contractVO.getBillCode());
        supplementVO.setMainContractName(contractVO.getContractName());
        supplementVO.setType(contractVO.getType());
        return supplementVO;
    }

    @Override
    public SupplementHistoryVo queryDetailRecord(Long id) {
        ContractEntity contractEntity = contractService.selectById(id);
        SupplementHistoryVo recordVO = new SupplementHistoryVo();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        BigDecimal baseTaxMny = contractEntity.getBaseTaxMoney() == null ? BigDecimal.ZERO : contractEntity.getBaseTaxMoney();
        recordVO.setContractId(id);
        recordVO.setContractTaxMny(contractTaxMny);
        recordVO.setBaseTaxMoney(baseTaxMny);
        recordVO.setChangeStatus(contractEntity.getChangeStatus());
        recordVO.setIsFinish(contractEntity.getIsFinish());
        LambdaQueryWrapper<SupplementEntity> lambda = Wrappers.<SupplementEntity>lambdaQuery();
        lambda.eq(SupplementEntity::getMainContractId, id);
        lambda.orderByDesc(SupplementEntity::getSignDate);
        List<SupplementEntity> entities = super.list(lambda);
        recordVO.setDetailList(BeanMapper.mapList(entities, SupplementVO.class));
        return recordVO;
    }
}
