package com.ejianc.business.inother.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.finance.api.IReceiveManageApi;
import com.ejianc.business.finance.vo.SumReceiveVO;
import com.ejianc.business.income.service.CommonBillCodeService;
import com.ejianc.business.inother.mapper.OtherContractMapper;
import com.ejianc.business.inother.service.IOtherClauseService;
import com.ejianc.business.inother.service.IOtherContractService;
import com.ejianc.business.inother.service.IOtherDetailService;
import com.ejianc.business.inother.bean.OtherClauseEntity;
import com.ejianc.business.inother.bean.OtherDetailEntity;
import com.ejianc.business.inother.vo.OtherClauseVO;
import com.ejianc.business.inother.vo.OtherContractVO;
import com.ejianc.business.inother.vo.OtherDetailVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceOpenRecordVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.inother.bean.OtherContractEntity;

import java.util.*;

/**
 * 其他收入合同
 * 
 * @author generator
 * 
 */
@Service("otherContractService")
public class OtherContractServiceImpl extends BaseServiceImpl<OtherContractMapper, OtherContractEntity> implements IOtherContractService {

    private static final String INCOME_CONTRACT_BILL_CODE = "OTHER_IN_CONTRACT";
    @Autowired
    private OtherContractMapper contractMapper;
    @Autowired
    private IOtherDetailService detailsService;
    @Autowired
    private IOtherClauseService clauseService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IReceiveManageApi receiveManageApi;
    @Autowired
    private IInvoiceApi invoiceApi;
    @Autowired
    private IUserApi userApi;

    @Autowired
    private CommonBillCodeService commonBillCodeService;

    @Override
    public CommonResponse<OtherContractVO> saveOrUpdate(OtherContractVO otherContractVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        OtherContractEntity entity = null;
        String operateType = null;
        if(otherContractVO.getId() != null && otherContractVO.getId() > 0) { //修改
            if(StringUtils.isEmpty(otherContractVO.getBillCode())){
                throw new BusinessException("编码为空，不允许保存!");
            }
            entity = BeanMapper.map(otherContractVO, OtherContractEntity.class);
            operateType = "edit";
        }else{
            //新增
            if(StringUtils.isEmpty(otherContractVO.getBillCode())){
                String code = commonBillCodeService.getCodeByOrgId(otherContractVO.getOrgId(), INCOME_CONTRACT_BILL_CODE, otherContractVO);
                otherContractVO.setBillCode(code);
            }
            //新增设置 竣工结算标志
            otherContractVO.setIsFinish(0);
            entity = BeanMapper.map(otherContractVO, OtherContractEntity.class);
            operateType = "add";
        }
        if(otherContractVO.getId() != null && otherContractVO.getId() > 0) {
            //修改  校验合同编号是否重复
            LambdaQueryWrapper<OtherContractEntity> lambda = Wrappers.<OtherContractEntity>lambdaQuery();
            lambda.eq(OtherContractEntity::getBillCode, otherContractVO.getBillCode());
            lambda.eq(OtherContractEntity::getTenantId, tenantId);
            lambda.ne(OtherContractEntity::getId, otherContractVO.getId());
            List<OtherContractEntity> entities = super.list(lambda);
            if(entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }else{
            //校验合同编号是否重复
            LambdaQueryWrapper<OtherContractEntity> lambda = Wrappers.<OtherContractEntity>lambdaQuery();
            lambda.eq(OtherContractEntity::getTenantId, tenantId);
            lambda.eq(OtherContractEntity::getBillCode, otherContractVO.getBillCode());
            List<OtherContractEntity> entities = super.list(lambda);
            if(entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }
        entity.setSupplementFlag(0);
        entity.setBaseTaxMoney(entity.getContractTaxMny());//初始版本金额(含税)
        entity.setBaseMoney(entity.getContractMny());//初始版本金额(不含税)
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());//变更前金额(含税)
        entity.setBeforeChangeMny(entity.getContractMny());//变更前金额(不含税)
        entity.setBillType("other");
        super.saveOrUpdate(entity);

        List<OtherDetailVO> detailsVos = otherContractVO.getCheckList();
        List<OtherDetailEntity> saveOrUpldates = new ArrayList<>();
        List<Long> deleteIds = new ArrayList<>();
        for(OtherDetailVO detailsVo:detailsVos) {
            detailsVo.setChangeType(0);//因为导入的时候设置为增补项，避免后面逻辑问题，这里修改一下
            if("add".equals(detailsVo.getRowState())) {
                OtherDetailEntity detailslist = BeanMapper.map(detailsVo, OtherDetailEntity.class);
                detailslist.setContractId(entity.getId());
                detailslist.setId(null);
                saveOrUpldates.add(detailslist);
            }else if("edit".equals(detailsVo.getRowState())) {
                OtherDetailEntity detailslist = BeanMapper.map(detailsVo, OtherDetailEntity.class);
                saveOrUpldates.add(detailslist);
            } else if("del".equals(detailsVo.getRowState())) {
                deleteIds.add(detailsVo.getId());
            }
        }
        if(saveOrUpldates.size() > 0) {
            detailsService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        if(deleteIds.size() > 0) {
            detailsService.removeByIds(deleteIds, false);
        }

        List<OtherClauseVO> clauseVos = otherContractVO.getClauseList();
        List<OtherClauseEntity> clauseList = new ArrayList<>();
        List<Long> deleteClauseIds = new ArrayList<>();
        for(OtherClauseVO clauseVo:clauseVos) {
            if("add".equals(clauseVo.getRowState())) {
                OtherClauseEntity detailslist = BeanMapper.map(clauseVo, OtherClauseEntity.class);
                detailslist.setContractId(entity.getId());
                clauseList.add(detailslist);
            }else if("edit".equals(clauseVo.getRowState())) {
                OtherClauseEntity detailslist = BeanMapper.map(clauseVo, OtherClauseEntity.class);
                clauseList.add(detailslist);
            } else if("del".equals(clauseVo.getRowState())) {
                deleteClauseIds.add(clauseVo.getId());
            }
        }
        if(clauseList.size() > 0) {
            clauseService.saveOrUpdateBatch(clauseList, clauseList.size(), false);
        }
        if(deleteClauseIds.size() > 0) {
            clauseService.removeByIds(deleteClauseIds, false);
        }
        return CommonResponse.success(queryDetail(entity.getId()));
    }

    @Override
    public OtherContractVO queryDetail(Long id) {
        OtherContractEntity entity = contractMapper.selectById(id);
        if(entity != null) {
            OtherContractVO otherContractVO = BeanMapper.map(entity, OtherContractVO.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, otherContractVO.getId()));
            queryParam.getParams().put("change_type", new Parameter(QueryParam.NE, 5));
            QueryParam query = new QueryParam();
            query.getParams().put("contractId", new Parameter(QueryParam.EQ, otherContractVO.getId()));
            query.getOrderMap().put("createTime", "desc");
            List<OtherDetailEntity> check = detailsService.queryList(query, false);
            if(check != null && check.size() > 0) {
                List<OtherDetailVO> checkVoList = BeanMapper.mapList(check, OtherDetailVO.class);
                otherContractVO.setCheckList(checkVoList);
            }
            List<OtherClauseEntity> clauses = clauseService.queryList(query, false);
            if(clauses != null && clauses.size() > 0) {
                List<OtherClauseVO> clauseVoList = BeanMapper.mapList(clauses, OtherClauseVO.class);
                otherContractVO.setClauseList(clauseVoList);
            }
            return otherContractVO;
        }
        return null;
    }

    @Override
    public void deleteContract(List<OtherContractVO> vos) {
        for(OtherContractVO vo:vos) {
            detailsService.deleteByContractId(vo.getId());
            clauseService.deleteByContractId(vo.getId());
            contractMapper.deleteById(vo.getId());
        }
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        wrapper.select("round(sum(base_tax_money),2) as originalAmount, round(sum(contract_tax_mny),2) as curAmount");
        resp = super.getMap(wrapper);
//        String originalAmount = resp.get("originalAmount").toString();
//        String curAmount = resp.get("curAmount").toString();
//        resp.put("originalAmount",originalAmount);
//        resp.put("curAmount",curAmount);
        return resp;
    }

    /**
     * 获取合同签订时间
     * @param id
     * @return
     */
    @Override
    public Date getSignDate(Long id) {
        return contractMapper.getSignDate(id);
    }

    // 工程收款
    @Override
    public OtherContractEntity queryFinanceHistory(Long id) {
        OtherContractEntity otherContractEntity = baseMapper.selectById(id);
        CommonResponse<SumReceiveVO> sumReceiveVOList = receiveManageApi.getSumReceiveVOList(id);
        if(sumReceiveVOList.isSuccess()) {
            otherContractEntity.setReceiveVOList(sumReceiveVOList.getData().getReceiveVOList());
        }else{
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
        return otherContractEntity;
    }
    // 开票登记
    @Override
    public InvoiceOpenRecordVO queryTaxHistory(Long id) {
        OtherContractEntity otherContractEntity = baseMapper.selectById(id);
        CommonResponse<InvoiceOpenRecordVO> invoiceOpenRecord = invoiceApi.getInvoiceOpenRecord(id);
        if(invoiceOpenRecord.isSuccess()) {
            InvoiceOpenRecordVO data = invoiceOpenRecord.getData();
            data.setContractTaxMny(otherContractEntity.getContractTaxMny());
            return data;
        }else{
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
    }

    @Override
    public OtherContractVO contractDetail(Long id) {
        OtherContractEntity entity = contractMapper.selectById(id);
        OtherContractVO otherContractVO = BeanMapper.map(entity, OtherContractVO.class);
        OtherContractVO vo = new OtherContractVO();
        vo.setId(otherContractVO.getId());
        vo.setContractName(otherContractVO.getContractName());
        vo.setContractTaxMny(otherContractVO.getContractTaxMny());
        vo.setTaxRate(otherContractVO.getTaxRate());
        vo.setProjectId(otherContractVO.getProjectId());
        vo.setProjectName(otherContractVO.getProjectName());
        vo.setCustomerId(otherContractVO.getCustomerId());
        vo.setCustomerName(otherContractVO.getCustomerName());
        vo.setContractorUnit(otherContractVO.getContractorUnit());
        vo.setContractorUnitName(otherContractVO.getContractorUnitName());
        vo.setOrgId(otherContractVO.getOrgId());
        vo.setOrgName(otherContractVO.getOrgName());
        vo.setVersion(otherContractVO.getVersion());
        return vo;
    }
    
}
