/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.api.IReceiveManageApi;
import com.ejianc.business.finance.vo.SumReceiveVO;
import com.ejianc.business.income.bean.ContractClauseEntity;
import com.ejianc.business.income.bean.ContractDetailEntity;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.bean.SupplementEntity;
import com.ejianc.business.income.mapper.ContractMapper;
import com.ejianc.business.income.service.CommonBillCodeService;
import com.ejianc.business.income.service.IContractClauseService;
import com.ejianc.business.income.service.IContractDetailService;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.service.ISupplementService;
import com.ejianc.business.income.utils.AddressResolutionUtil;
import com.ejianc.business.income.utils.ComputeUtil;
import com.ejianc.business.income.utils.TreeNodeBUtil;
import com.ejianc.business.income.vo.ContractClauseVo;
import com.ejianc.business.income.vo.ContractDetailVo;
import com.ejianc.business.income.vo.ContractVo;
import com.ejianc.business.income.vo.ProjectCountVO;
import com.ejianc.business.income.vo.ProjectDataVO;
import com.ejianc.business.income.vo.ProjectInOutVO;
import com.ejianc.business.income.vo.SqlParam;
import com.ejianc.business.income.vo.comparator.ContractDetailComparatorVo;
import com.ejianc.business.income.vo.report.FinanceMnyVo;
import com.ejianc.business.income.vo.warn.IncomeContractWarnVo;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceOpenRecordVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ContractService")
public class ContractServiceImpl
extends BaseServiceImpl<ContractMapper, ContractEntity>
implements IContractService {
    private static final String INCOME_CONTRACT_BILL_CODE = "INCOME_CONTRACT";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ContractMapper contractMapper;
    @Autowired
    private IContractDetailService detailsService;
    @Autowired
    private IContractClauseService clauseService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IReceiveManageApi receiveManageApi;
    @Autowired
    private IInvoiceApi invoiceApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IProjectApi iProjectApi;
    @Autowired
    private CommonBillCodeService commonBillCodeService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ISupplementService supplementService;

    @Override
    public CommonResponse<ContractVo> saveOrUpdate(ContractVo contractVo) {
        List entities;
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        ContractEntity entity = null;
        String operateType = null;
        if (contractVo.getId() != null && contractVo.getId() > 0L) {
            if (StringUtils.isEmpty((CharSequence)contractVo.getBillCode())) {
                throw new BusinessException("\u7f16\u7801\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            entity = (ContractEntity)((Object)BeanMapper.map((Object)contractVo, ContractEntity.class));
            operateType = "edit";
        } else {
            if (StringUtils.isEmpty((CharSequence)contractVo.getBillCode())) {
                String code = this.commonBillCodeService.getCodeByOrgId(contractVo.getOrgId(), INCOME_CONTRACT_BILL_CODE, (BaseVO)contractVo);
                contractVo.setBillCode(code);
            }
            if (StringUtils.isEmpty((CharSequence)contractVo.getIsSupplement())) {
                contractVo.setIsSupplement("0");
            }
            contractVo.setIsFinish(Integer.valueOf(0));
            entity = (ContractEntity)((Object)BeanMapper.map((Object)contractVo, ContractEntity.class));
            operateType = "add";
        }
        this.logger.info("\u5355\u636e\u7f16\u7801\uff1a{}", (Object)contractVo.getBillCode());
        if (contractVo.getId() != null && contractVo.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(ContractEntity::getBillCode, (Object)contractVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)contractVo.getId());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(ContractEntity::getBillCode, (Object)contractVo.getBillCode());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        entity.setSupplementFlag(0);
        entity.setBaseTaxMoney(entity.getContractTaxMny());
        entity.setBaseMoney(entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());
        entity.setBeforeChangeMny(entity.getContractMny());
        entity.setBillType("income");
        super.saveOrUpdate((Object)entity);
        List detailsVos = contractVo.getCheckList();
        ArrayList<ContractDetailEntity> saveOrUpldates = new ArrayList<ContractDetailEntity>();
        ArrayList<Long> deleteIds = new ArrayList<Long>();
        for (Object detailsVo : detailsVos) {
            ContractDetailEntity detailslist;
            detailsVo.setChangeType(Integer.valueOf(0));
            if ("add".equals(detailsVo.getRowState())) {
                detailslist = (ContractDetailEntity)((Object)BeanMapper.map((Object)detailsVo, ContractDetailEntity.class));
                detailslist.setContractId(entity.getId());
                detailslist.setId(null);
                saveOrUpldates.add(detailslist);
                continue;
            }
            if ("edit".equals(detailsVo.getRowState())) {
                detailslist = (ContractDetailEntity)((Object)BeanMapper.map((Object)detailsVo, ContractDetailEntity.class));
                saveOrUpldates.add(detailslist);
                continue;
            }
            if (!"del".equals(detailsVo.getRowState())) continue;
            deleteIds.add(detailsVo.getId());
        }
        if (saveOrUpldates.size() > 0) {
            this.detailsService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (ContractDetailEntity cdEntity : saveOrUpldates) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (ContractDetailEntity cdEntity : saveOrUpldates) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            this.detailsService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        if (deleteIds.size() > 0) {
            this.detailsService.removeByIds(deleteIds, false);
        }
        List clauseVos = contractVo.getClauseList();
        ArrayList<ContractClauseEntity> clauseList = new ArrayList<ContractClauseEntity>();
        ArrayList<Long> deleteClauseIds = new ArrayList<Long>();
        for (ContractClauseVo clauseVo : clauseVos) {
            ContractClauseEntity detailslist;
            if ("add".equals(clauseVo.getRowState())) {
                detailslist = (ContractClauseEntity)((Object)BeanMapper.map((Object)clauseVo, ContractClauseEntity.class));
                detailslist.setContractId(entity.getId());
                clauseList.add(detailslist);
                continue;
            }
            if ("edit".equals(clauseVo.getRowState())) {
                detailslist = (ContractClauseEntity)((Object)BeanMapper.map((Object)clauseVo, ContractClauseEntity.class));
                clauseList.add(detailslist);
                continue;
            }
            if (!"del".equals(clauseVo.getRowState())) continue;
            deleteClauseIds.add(clauseVo.getId());
        }
        if (clauseList.size() > 0) {
            this.clauseService.saveOrUpdateBatch(clauseList, clauseList.size(), false);
        }
        if (deleteClauseIds.size() > 0) {
            this.clauseService.removeByIds(deleteClauseIds, false);
        }
        return CommonResponse.success((Object)this.queryDetail(entity.getId()));
    }

    @Override
    public ContractVo queryDetail(Long id) {
        ContractEntity entity = (ContractEntity)((Object)this.contractMapper.selectById(id));
        if (entity != null) {
            ContractVo contractVo = (ContractVo)BeanMapper.map((Object)((Object)entity), ContractVo.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractVo.getId()));
            queryParam.getParams().put("change_type", new Parameter("ne", (Object)5));
            List purchaseDetailss = this.detailsService.queryList(queryParam, false);
            if (purchaseDetailss != null && purchaseDetailss.size() > 0) {
                for (ContractDetailEntity cdEntity : purchaseDetailss) {
                    cdEntity.setTid(cdEntity.getId().toString());
                    cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                    cdEntity.setRowState("edit");
                }
                List resultMapList = BeanMapper.mapList((Iterable)purchaseDetailss, ContractDetailVo.class);
                Collections.sort(resultMapList, new ContractDetailComparatorVo());
                contractVo.setCheckList(TreeNodeBUtil.buildTree((List)resultMapList));
            }
            QueryParam query = new QueryParam();
            query.getParams().put("contractId", new Parameter("eq", (Object)contractVo.getId()));
            query.getOrderMap().put("createTime", "asc");
            List clauses = this.clauseService.queryList(query, false);
            if (clauses != null && clauses.size() > 0) {
                List clauseVoList = BeanMapper.mapList((Iterable)clauses, ContractClauseVo.class);
                contractVo.setClauseList(clauseVoList);
            }
            return contractVo;
        }
        return null;
    }

    @Override
    public void deleteContract(List<ContractVo> vos) {
        for (ContractVo vo : vos) {
            this.detailsService.deleteByContractId(vo.getId());
            this.clauseService.deleteByContractId(vo.getId());
            this.contractMapper.deleteById(vo.getId());
        }
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        HashMap<String, Object> resp = new HashMap();
        QueryWrapper wrapper = ContractServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.select(new String[]{"round(sum(base_tax_money),2) as originalAmount, round(sum(contract_tax_mny),2) as curAmount"});
        resp = super.getMap((Wrapper)wrapper);
        return resp;
    }

    @Override
    public Date getSignDate(Long id) {
        return this.contractMapper.getSignDate(id);
    }

    @Override
    public void updateCollectMny(Long contractId, BigDecimal collectMny, Boolean type) {
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)contractId));
        BigDecimal sumCollectMny = contractEntity.getSumCollectMny() == null ? BigDecimal.ZERO : contractEntity.getSumCollectMny();
        sumCollectMny = type != false ? sumCollectMny.add(collectMny) : sumCollectMny.subtract(collectMny);
        contractEntity.setSumCollectMny(sumCollectMny);
        super.updateById((Object)contractEntity);
    }

    @Override
    public void updateInvoicingMny(Long contractId, BigDecimal invoicingTaxMny, BigDecimal invoicingMny, Boolean type) {
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)contractId));
        BigDecimal sumInvoicingMny = contractEntity.getSumInvoicingMny() == null ? BigDecimal.ZERO : contractEntity.getSumInvoicingMny();
        sumInvoicingMny = type != false ? sumInvoicingMny.add(invoicingMny) : sumInvoicingMny.subtract(invoicingMny);
        BigDecimal sumInvoicingTaxMny = contractEntity.getSumInvoicingTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumInvoicingTaxMny();
        sumInvoicingTaxMny = type != false ? sumInvoicingTaxMny.add(invoicingTaxMny) : sumInvoicingTaxMny.subtract(invoicingTaxMny);
        contractEntity.setSumInvoicingTaxMny(sumInvoicingTaxMny);
        contractEntity.setSumInvoicingMny(sumInvoicingMny);
        super.updateById((Object)contractEntity);
    }

    @Override
    public ContractVo searchContract(Long projectId) {
        ContractVo contractVo = this.contractMapper.searchContract(projectId);
        return contractVo;
    }

    @Override
    public ContractEntity queryFinanceHistory(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)((ContractMapper)this.baseMapper).selectById(id));
        CommonResponse sumReceiveVOList = this.receiveManageApi.getSumReceiveVOList(id);
        if (!sumReceiveVOList.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        contractEntity.setReceiveVOList(((SumReceiveVO)sumReceiveVOList.getData()).getReceiveVOList());
        return contractEntity;
    }

    @Override
    public InvoiceOpenRecordVO queryTaxHistory(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)((ContractMapper)this.baseMapper).selectById(id));
        CommonResponse invoiceOpenRecord = this.invoiceApi.getInvoiceOpenRecord(id);
        if (invoiceOpenRecord.isSuccess()) {
            InvoiceOpenRecordVO data = (InvoiceOpenRecordVO)invoiceOpenRecord.getData();
            data.setContractTaxMny(contractEntity.getContractTaxMny());
            return data;
        }
        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
    }

    @Override
    public ContractVo contractDetail(Long id) {
        ContractEntity entity = (ContractEntity)((Object)this.contractMapper.selectById(id));
        ContractVo contractVo = (ContractVo)BeanMapper.map((Object)((Object)entity), ContractVo.class);
        ContractVo vo = new ContractVo();
        vo.setId(contractVo.getId());
        vo.setContractName(contractVo.getContractName());
        vo.setContractTaxMny(contractVo.getContractTaxMny());
        vo.setTaxRate(contractVo.getTaxRate());
        vo.setProjectId(contractVo.getProjectId());
        vo.setProjectName(contractVo.getProjectName());
        vo.setCustomerId(contractVo.getCustomerId());
        vo.setCustomerName(contractVo.getCustomerName());
        vo.setContractorUnit(contractVo.getContractorUnit());
        vo.setContractorUnitName(contractVo.getContractorUnitName());
        vo.setOrgId(contractVo.getOrgId());
        vo.setOrgName(contractVo.getOrgName());
        vo.setVersion(contractVo.getVersion());
        return vo;
    }

    @Override
    public CommonResponse<Map<String, BigDecimal>> capitalCount(Integer range, List<Long> orgIds) {
        String year = null;
        if (range == 2) {
            year = Calendar.getInstance().get(1) + "";
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        String a = "";
        for (Long idd : orgIds) {
            a = a + "," + idd;
        }
        System.out.println(a);
        BigDecimal inContractMoney = this.contractMapper.inContractMoney(range, year, orgIds, tenantId);
        BigDecimal totalReceiveMoney = this.contractMapper.totalReceiveMoney(range, year, orgIds, tenantId);
        BigDecimal outContractMoney = this.contractMapper.outContractMoney(range, year, orgIds, tenantId);
        BigDecimal totalSettleMoney = this.contractMapper.totalSettleMoney(range, year, orgIds, tenantId);
        BigDecimal totalOutMoney = this.contractMapper.totalOutMoney(range, year, orgIds, tenantId);
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        map.put("inContractMoney", inContractMoney);
        map.put("totalReceiveMoney", totalReceiveMoney);
        map.put("outContractMoney", outContractMoney);
        map.put("totalSettleMoney", totalSettleMoney);
        map.put("totalOutMoney", totalOutMoney);
        map.put("bookMoney", totalReceiveMoney.subtract(totalOutMoney));
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", map);
    }

    @Override
    public CommonResponse<List<Map>> getproject(List<Long> orgIds) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<Map> map = this.contractMapper.getproject(orgIds, tenantId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", map);
    }

    @Override
    public CommonResponse<Map> getprogress(Long projectId) {
        Map map = this.contractMapper.getProjectDetail(projectId);
        Map Datemap = this.contractMapper.getProjectDate(projectId);
        SimpleDateFormat fm = new SimpleDateFormat("yyy-MM-dd");
        String now = fm.format(new Date());
        String start = null;
        String end = null;
        if (Datemap != null) {
            if (Datemap.get("endDate") != null) {
                end = fm.format((Date)Datemap.get("endDate"));
            }
            if (Datemap.get("startDate") != null) {
                start = fm.format((Date)Datemap.get("startDate"));
            }
        }
        map.put("startDate", start);
        map.put("endDate", end);
        map.put("customerName", map.get("customerName"));
        map.put("projectState", map.get("projectState"));
        if (StringUtils.isNotEmpty((CharSequence)end) && StringUtils.isNotEmpty((CharSequence)start)) {
            if (ContractServiceImpl.subtractDay(now, end) >= 0) {
                map.put("dateProgress", "100%");
            } else {
                int a = ContractServiceImpl.subtractDay(now, start);
                if (a <= 0) {
                    map.put("dateProgress", "0%");
                } else {
                    int b = ContractServiceImpl.subtractDay(end, start);
                    int c = a * 100 / b;
                    map.put("dateProgress", c + "%");
                }
            }
        } else {
            map.put("dateProgress", "0%");
        }
        BigDecimal outputMoney = this.contractMapper.outputMoney(projectId);
        BigDecimal contractMoney = this.contractMapper.contractMoney(projectId);
        map.put("contractMoney", contractMoney);
        map.put("outputMoney", outputMoney);
        if (contractMoney.compareTo(BigDecimal.ZERO) == 0) {
            map.put("outputProgress", "0%");
        } else {
            map.put("outputProgress", outputMoney.divide(contractMoney, 8, 4).multiply(new BigDecimal("100")).setScale(0, 4) + "%");
        }
        CommonResponse membersResp = this.userApi.getEmployeeList((Long)map.get("projectDepartmentId"));
        if (!membersResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u9879\u76ee\u6210\u5458\u5931\u8d25\u3002");
        }
        map.put("managerNum", ((List)membersResp.getData()).size());
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)map);
    }

    @Override
    public CommonResponse<List<List<Map>>> costCount(Integer range, List<Long> orgIds) {
        String year = null;
        if (range == 2) {
            year = Calendar.getInstance().get(1) + "";
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        List list = this.contractMapper.costCount(range, year, orgIds, tenantId);
        BigDecimal totalCostMny = BigDecimal.ZERO;
        for (Map map : list) {
            if (map.get("name").equals("\u501f\u6b3e\u62a5\u9500")) continue;
            BigDecimal mny = (BigDecimal)map.get("value");
            totalCostMny = ComputeUtil.safeAdd(mny, totalCostMny);
        }
        ArrayList mnyList = new ArrayList();
        HashMap<String, BigDecimal> hashMap = new HashMap<String, BigDecimal>();
        hashMap.put("totalCostMny", totalCostMny);
        mnyList.add(hashMap);
        list = list.stream().filter(i -> !i.get("name").equals("\u501f\u6b3e\u62a5\u9500")).collect(Collectors.toList());
        ArrayList resultList = new ArrayList();
        resultList.add(list);
        resultList.add(mnyList);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", resultList);
    }

    @Override
    public CommonResponse<JSONObject> projectCount(String range, String name, List<Long> orgIds) {
        BigDecimal contractTaxMny;
        String city;
        Long tenantId = InvocationInfoProxy.getTenantid();
        String year = Calendar.getInstance().get(1) + "";
        List<ProjectCountVO> list = this.contractMapper.projectCount(range, year, orgIds, tenantId);
        ArrayList<Long> ids = new ArrayList<Long>();
        BigDecimal allContractMoney = BigDecimal.ZERO;
        HashSet<String> provinceSet = new HashSet<String>();
        HashSet<String> citySet = new HashSet<String>();
        HashSet<String> countySet = new HashSet<String>();
        String pname = null;
        for (ProjectCountVO vo : list) {
            ids.add(vo.getId());
            BigDecimal contractTaxMny2 = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
            allContractMoney = allContractMoney.add(contractTaxMny2);
            if (StringUtils.isNotEmpty((CharSequence)vo.getArea())) {
                if (vo.getArea().equals("\u53f0\u6e7e\u7701")) {
                    vo.setProvince("\u53f0\u6e7e\u7701");
                    vo.setCity("\u53f0\u6e7e\u7701");
                    vo.setCounty("\u53f0\u6e7e\u7701");
                    provinceSet.add("\u53f0\u6e7e\u7701");
                    citySet.add("\u53f0\u6e7e\u7701");
                    countySet.add("\u53f0\u6e7e\u7701");
                    continue;
                }
                Map<String, String> areaMmap = AddressResolutionUtil.addressResolution(vo.getArea());
                if (areaMmap != null) {
                    String province = areaMmap.get("province") == null ? "\u5176\u4ed6" : (String)areaMmap.get("province");
                    city = areaMmap.get("city") == null ? "\u5176\u4ed6" : (String)areaMmap.get("city");
                    String county = areaMmap.get("county") == null ? "\u5176\u4ed6" : (String)areaMmap.get("county");
                    vo.setProvince(province);
                    vo.setCity(city);
                    vo.setCounty(county);
                    provinceSet.add(province);
                    citySet.add(city);
                    countySet.add(county);
                    if (!StringUtils.isNotBlank((CharSequence)name) || !city.equals(name)) continue;
                    pname = province;
                    continue;
                }
                vo.setProvince("\u5176\u4ed6");
                vo.setCity("\u5176\u4ed6");
                vo.setCounty("\u5176\u4ed6");
                provinceSet.add("\u5176\u4ed6");
                citySet.add("\u5176\u4ed6");
                countySet.add("\u5176\u4ed6");
                continue;
            }
            vo.setProvince("\u5176\u4ed6");
            vo.setCity("\u5176\u4ed6");
            vo.setCounty("\u5176\u4ed6");
            provinceSet.add("\u5176\u4ed6");
            citySet.add("\u5176\u4ed6");
            countySet.add("\u5176\u4ed6");
        }
        String rangeType = null;
        List<Object> dataVOS = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            if (provinceSet.contains(name)) {
                rangeType = AddressResolutionUtil.getProvincePinYin(name);
                dataVOS = this.projectCountByName(name, list, 0);
            } else if (citySet.contains(name)) {
                rangeType = AddressResolutionUtil.getProvincePinYin(pname) + "-" + AddressResolutionUtil.getNamePinYinChar(name, 1);
                dataVOS = this.projectCountByName(name, list, 1);
            }
        } else if (provinceSet.size() == 1) {
            if (citySet.size() == 1) {
                rangeType = AddressResolutionUtil.getProvincePinYin((String)provinceSet.iterator().next()) + "-" + AddressResolutionUtil.getNamePinYinChar((String)citySet.iterator().next(), 1);
                HashMap<String, ProjectDataVO> countyMap = new HashMap<String, ProjectDataVO>();
                for (ProjectCountVO vo : list) {
                    String county = vo.getCounty();
                    BigDecimal bigDecimal = contractTaxMny = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
                    if (!countyMap.containsKey(county)) {
                        ProjectDataVO pvo = new ProjectDataVO();
                        pvo.setName(county);
                        pvo.setValue(Integer.valueOf(1));
                        pvo.setContractMoney(contractTaxMny);
                        countyMap.put(county, pvo);
                        continue;
                    }
                    ProjectDataVO projectDataVO = (ProjectDataVO)countyMap.get(county);
                    projectDataVO.setValue(Integer.valueOf(projectDataVO.getValue() + 1));
                    projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
                    countyMap.put(county, projectDataVO);
                }
                dataVOS = new ArrayList(countyMap.values());
            } else {
                rangeType = AddressResolutionUtil.getProvincePinYin((String)provinceSet.iterator().next());
                HashMap<String, ProjectDataVO> cityMap = new HashMap<String, ProjectDataVO>();
                for (ProjectCountVO vo : list) {
                    city = vo.getCity();
                    BigDecimal bigDecimal = contractTaxMny = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
                    if (!cityMap.containsKey(city)) {
                        ProjectDataVO pvo = new ProjectDataVO();
                        pvo.setName(city);
                        pvo.setValue(Integer.valueOf(1));
                        pvo.setContractMoney(contractTaxMny);
                        cityMap.put(city, pvo);
                        continue;
                    }
                    ProjectDataVO projectDataVO = (ProjectDataVO)cityMap.get(city);
                    projectDataVO.setValue(Integer.valueOf(projectDataVO.getValue() + 1));
                    projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
                    cityMap.put(city, projectDataVO);
                }
                dataVOS = new ArrayList(cityMap.values());
            }
        } else {
            rangeType = "China";
            HashMap<String, ProjectDataVO> provinceMap = new HashMap<String, ProjectDataVO>();
            for (ProjectCountVO vo : list) {
                String province = vo.getProvince();
                BigDecimal bigDecimal = contractTaxMny = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
                if (!provinceMap.containsKey(province)) {
                    ProjectDataVO pvo = new ProjectDataVO();
                    pvo.setName(province);
                    pvo.setValue(Integer.valueOf(1));
                    pvo.setContractMoney(contractTaxMny);
                    provinceMap.put(province, pvo);
                    continue;
                }
                ProjectDataVO projectDataVO = (ProjectDataVO)provinceMap.get(province);
                projectDataVO.setValue(Integer.valueOf(projectDataVO.getValue() + 1));
                projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
                provinceMap.put(province, projectDataVO);
            }
            dataVOS = new ArrayList(provinceMap.values());
        }
        int allProjectNumber = list.size();
        BigDecimal allInMoney = ids.size() > 0 ? this.contractMapper.allInMoney(ids) : BigDecimal.ZERO;
        BigDecimal allOutMoney = ids.size() > 0 ? this.contractMapper.allOutMoney(ids) : BigDecimal.ZERO;
        BigDecimal bookMoney = allInMoney.subtract(allOutMoney);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("allProjectNumber", (Object)allProjectNumber);
        jsonObject.put("allContractMoney", (Object)allContractMoney);
        jsonObject.put("allInMoney", (Object)allInMoney);
        jsonObject.put("allOutMoney", (Object)allOutMoney);
        jsonObject.put("bookMoney", (Object)bookMoney);
        jsonObject.put("data", dataVOS);
        jsonObject.put("range", (Object)(rangeType == null ? "China" : rangeType));
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    private List<ProjectDataVO> projectCountByName(String name, List<ProjectCountVO> list, Integer type) {
        ArrayList dataVOS = new ArrayList();
        HashMap<String, ProjectDataVO> map = new HashMap<String, ProjectDataVO>();
        for (ProjectCountVO vo : list) {
            BigDecimal contractTaxMny;
            String voName = null;
            String childrenName = null;
            if (type == 0) {
                voName = vo.getProvince();
                childrenName = vo.getCity();
            } else {
                voName = vo.getCity();
                childrenName = vo.getCounty();
            }
            if (!voName.equals(name)) continue;
            BigDecimal bigDecimal = contractTaxMny = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
            if (!map.containsKey(childrenName)) {
                ProjectDataVO pvo = new ProjectDataVO();
                pvo.setName(childrenName);
                pvo.setValue(Integer.valueOf(1));
                pvo.setContractMoney(contractTaxMny);
                map.put(childrenName, pvo);
                continue;
            }
            ProjectDataVO projectDataVO = (ProjectDataVO)map.get(childrenName);
            projectDataVO.setValue(Integer.valueOf(projectDataVO.getValue() + 1));
            projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
            map.put(childrenName, projectDataVO);
        }
        return new ArrayList<ProjectDataVO>(map.values());
    }

    @Override
    public IPage<ProjectInOutVO> proPageList(Map<String, Object> params) {
        Object orgIds = params.get("orgIds");
        if (orgIds == null) {
            return new Page();
        }
        List<Object> voList = new ArrayList();
        Page page = new Page();
        page.setCurrent((long)Integer.valueOf(params.get("pageIndex").toString()).intValue());
        page.setSize((long)Integer.valueOf(params.get("pageSize").toString()).intValue());
        long total = this.contractMapper.count(params);
        page.setTotal(total);
        if (total == 0L) {
            page.setRecords(voList);
            return page;
        }
        long startLine = (page.getCurrent() < 1L ? 0L : page.getCurrent() - 1L) * page.getSize();
        params.put("startLine", startLine);
        params.put("pageSize", page.getSize());
        voList = this.contractMapper.getList(params);
        page.setRecords(voList);
        return page;
    }

    @Override
    public List<Map<String, Object>> incomeMnyWarn(List<SqlParam> sqlParamList) {
        return ((ContractMapper)this.baseMapper).incomeMnyWarn(sqlParamList);
    }

    @Override
    public List<IncomeContractWarnVo> outIncomeMnyWarn(List<Long> tenantIds) {
        return ((ContractMapper)this.baseMapper).outIncomeMnyWarn(tenantIds);
    }

    @Override
    public List<FinanceMnyVo> queryFinanceMny(Integer range, List<Long> orgIds) {
        String year = null;
        if (range == 2) {
            year = Calendar.getInstance().get(1) + "";
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        ArrayList<FinanceMnyVo> list = new ArrayList();
        List<Map<String, BigDecimal>> quoteList = this.contractMapper.totalQuoteMoney(range, year, orgIds, tenantId);
        BigDecimal totalReceiveMoney = this.contractMapper.totalReceiveMoney(range, year, orgIds, tenantId);
        BigDecimal totalOutMoney = this.contractMapper.totalOutMoney(range, year, orgIds, tenantId);
        HashMap<String, BigDecimal> financeMap = new HashMap<String, BigDecimal>();
        BigDecimal totalQuoteTaxMoney = ListUtil.isNotEmpty(quoteList) ? quoteList.get(0).get("totalQuoteTaxMoney") : BigDecimal.ZERO;
        financeMap.put("\u7d2f\u8ba1\u5e94\u6536", totalQuoteTaxMoney);
        financeMap.put("\u7d2f\u8ba1\u6536\u6b3e", totalReceiveMoney);
        financeMap.put("\u7d2f\u8ba1\u5e94\u6536\u672a\u6536", ComputeUtil.safeSub(totalQuoteTaxMoney, totalReceiveMoney));
        financeMap.put("\u7d2f\u8ba1\u652f\u51fa", totalOutMoney);
        financeMap.put("\u8d26\u9762\u91d1\u989d", ComputeUtil.safeSub(totalReceiveMoney, totalOutMoney));
        for (Map.Entry entry : financeMap.entrySet()) {
            FinanceMnyVo vo = new FinanceMnyVo();
            vo.setName((String)entry.getKey());
            vo.setTaxMny((BigDecimal)entry.getValue());
            list.add(vo);
        }
        list = list.stream().sorted(Comparator.comparing(FinanceMnyVo::getTaxMny).reversed()).collect(Collectors.toList());
        return list;
    }

    @Override
    public Map<String, BigDecimal> queryEconomyMny(Integer range, List<Long> orgIds) {
        String year = null;
        if (range == 2) {
            year = Calendar.getInstance().get(1) + "";
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        CommonResponse projectResponse = this.iProjectApi.queryChildrenProjectByOrgId(InvocationInfoProxy.getOrgId());
        if (!projectResponse.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u5217\u8868\u5931\u8d25\uff01");
        }
        ArrayList<Long> projectIds = new ArrayList();
        if (ListUtil.isNotEmpty((List)((List)projectResponse.getData()))) {
            projectIds = ((List)projectResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        List<Map<String, BigDecimal>> quoteList = this.contractMapper.totalQuoteMoney(range, year, orgIds, tenantId);
        BigDecimal totalProductionMoney = this.contractMapper.totalProductionMoney(range, year, orgIds, tenantId);
        BigDecimal totalCostMoney = this.contractMapper.totalCostMoney(range, year, ListUtil.isNotEmpty(projectIds) ? projectIds : null, tenantId);
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgResponse = this.orgApi.detailById(orgId);
        if (!orgResponse.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5f53\u524d\u7ec4\u7ec7\u8be6\u60c5\u5931\u8d25\uff01");
        }
        OrgVO orgVO = (OrgVO)orgResponse.getData();
        BigDecimal bidProfitRate = BigDecimal.ZERO;
        List<Object> planList = new ArrayList();
        if (orgVO.getOrgType() == 5) {
            bidProfitRate = this.contractMapper.bidProfitRateByProject(range, year, orgId, tenantId);
            planList = this.contractMapper.planRate(range, year, null, tenantId, (Long)projectIds.get(0));
        } else {
            bidProfitRate = this.contractMapper.bidProfitRate(range, year, orgIds, tenantId);
            planList = this.contractMapper.planRate(range, year, orgIds, tenantId, null);
        }
        if (ListUtil.isNotEmpty(planList)) {
            Map map = (Map)planList.get(0);
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                BigDecimal value = (BigDecimal)entry.getValue();
                if (!value.equals(new BigDecimal("0E-8")) && !value.equals(new BigDecimal("0E-12"))) continue;
                ((Map)planList.get(0)).put(key, BigDecimal.ZERO);
            }
        }
        HashMap<String, BigDecimal> economyMap = new HashMap<String, BigDecimal>();
        economyMap.put("totalProductionMoney", totalProductionMoney);
        economyMap.put("totalQuoteMoney", ListUtil.isNotEmpty(quoteList) ? quoteList.get(0).get("totalQuoteMoney") : BigDecimal.ZERO);
        BigDecimal currentProfit = ComputeUtil.safeSub(totalProductionMoney, totalCostMoney);
        economyMap.put("currentProfit", currentProfit);
        economyMap.put("bidProfitRate", bidProfitRate);
        economyMap.put("guaranteeTargetRate", ListUtil.isNotEmpty(planList) ? (BigDecimal)((Map)planList.get(0)).get("guaranteeTargetRate") : BigDecimal.ZERO);
        economyMap.put("accomplishTargetRate", ListUtil.isNotEmpty(planList) ? (BigDecimal)((Map)planList.get(0)).get("accomplishTargetRate") : BigDecimal.ZERO);
        economyMap.put("challengeTargetRate", ListUtil.isNotEmpty(planList) ? (BigDecimal)((Map)planList.get(0)).get("challengeTargetRate") : BigDecimal.ZERO);
        economyMap.put("currentProfitRate", ComputeUtil.safeMultiply(ComputeUtil.safeDiv(currentProfit, totalProductionMoney), new BigDecimal("100")));
        return economyMap;
    }

    @Override
    public Long queryContractByProject(Long projectId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ContractEntity::getProjectId, (Object)projectId);
        wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        wrapper.eq(ContractEntity::getSupplementFlag, (Object)0);
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.list((Wrapper)wrapper);
        Long id = null;
        if (ListUtil.isNotEmpty((List)list)) {
            id = ((ContractEntity)((Object)list.get(0))).getId();
        }
        return id;
    }

    public static int subtractDay(String date1, String date2) {
        int rs = 0;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date start = simpleDateFormat.parse(date1);
            Date end = simpleDateFormat.parse(date2);
            long sss = (start.getTime() - end.getTime()) / 1000L;
            rs = (int)sss / 86400;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return rs;
    }

    @Override
    public void updateContractIsSupplementFlag(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)((ContractMapper)this.baseMapper).selectById(id));
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(SupplementEntity::getMainContractId, (Object)id);
        lambda.orderByDesc(SupplementEntity::getSignDate);
        List entities = this.supplementService.list((Wrapper)lambda);
        if (entities.size() > 0) {
            contractEntity.setIsSupplement("1");
        } else {
            contractEntity.setIsSupplement("0");
        }
        ((ContractMapper)this.baseMapper).updateById((Object)contractEntity);
    }
}

