/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.income.bean.ProductionPlanEntity;
import com.ejianc.business.income.history.ProductionPlanHistoryVo;
import com.ejianc.business.income.service.IProductionPlanService;
import com.ejianc.business.income.vo.ProductionPlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"productionPlan"})
public class ProductionPlanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProductionPlanService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProductionPlanVO> saveOrUpdate(@RequestBody ProductionPlanVO saveorUpdateVO) {
        return this.service.saveOrUpdate(saveorUpdateVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProductionPlanVO> queryDetail(Long id) {
        ProductionPlanEntity entity = (ProductionPlanEntity)((Object)this.service.selectById(id));
        ProductionPlanVO vo = (ProductionPlanVO)BeanMapper.map((Object)((Object)entity), ProductionPlanVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProductionPlanVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProductionPlanVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProductionPlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"/getPlanMonth"})
    @ResponseBody
    public CommonResponse<ProductionPlanVO> getPlanMonth(Long contractId) {
        return this.service.getPlanMonth(contractId);
    }

    @GetMapping(value={"/getYearPlanTaxMny"})
    @ResponseBody
    public CommonResponse<ProductionPlanVO> getYearPlanTaxMny(@RequestParam(value="contractId") Long contractId, @RequestParam(value="planMonth") Date planMonth) {
        return this.service.getYearPlanTaxMny(contractId, planMonth);
    }

    @RequestMapping(value={"/queryProductionPlanHistory"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProductionPlanHistoryVo> queryProductionPlanHistory(@RequestParam Long id) {
        ProductionPlanHistoryVo vo = this.service.queryProductionPlanHistory(id);
        return CommonResponse.success((Object)vo);
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime", "desc");
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage pageData = this.service.queryPage(param, false);
        HashMap beans = new HashMap();
        List list = new ArrayList();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), ProductionPlanVO.class);
            list.forEach(vo -> vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription()));
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("productionPlan-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/getValidate"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> getValidate(@RequestParam(value="id", required=false) Long id, @RequestParam(value="contractId") Long contractId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam.getOrderMap().put("planMonth", "desc");
        if (id != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)id));
        }
        List list = this.service.queryList(queryParam);
        List allMonth = list.stream().map(ProductionPlanEntity::getPlanMonth).collect(Collectors.toList());
        JSONObject json = new JSONObject();
        json.put("allMonth", allMonth);
        json.put("maxDate", CollectionUtils.isNotEmpty((Collection)list) ? ((ProductionPlanEntity)((Object)list.get(0))).getPlanMonth() : null);
        queryParam.getParams().put("billState", new Parameter("not_in", (Object)"1,3"));
        List entities = this.service.queryList(queryParam, false);
        json.put("unEffective", (Object)(CollectionUtils.isNotEmpty((Collection)entities) ? 1 : 0));
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)json);
    }
}

