/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.bean.IncomeWarningEntity;
import com.ejianc.business.income.mapper.WarningMapper;
import com.ejianc.business.income.service.IIncomeWarningService;
import com.ejianc.business.income.service.IWarningService;
import com.ejianc.business.income.vo.IncomeWarningVO;
import com.ejianc.business.income.vo.warn.ProductionWarningVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WarningServiceImpl
extends BaseServiceImpl<WarningMapper, ContractEntity>
implements IWarningService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IIncomeWarningService incomeWarningService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "IncomeWarn_Code";

    @Override
    public JSONObject warningList(QueryParam param) {
        List<Long> orgids;
        List<ProductionWarningVO> list;
        Long tenantId = InvocationInfoProxy.getTenantid();
        int pageIndex = param.getPageIndex();
        int pageSize = param.getPageSize();
        Map params = param.getParams();
        String text = param.getSearchText();
        String countMonth = null;
        String countYear = null;
        String countSeason = null;
        JSONObject page = new JSONObject();
        int total = 0;
        int current = pageIndex;
        int size = pageSize;
        int pages = 0;
        if (params.get("countMonth") == null) {
            page.put("records", new ArrayList());
            page.put("total", (Object)total);
            page.put("current", (Object)current);
            page.put("size", (Object)size);
            page.put("pages", (Object)pages);
            return page;
        }
        countMonth = (String)((Parameter)params.get("countMonth")).getValue();
        countYear = countMonth.substring(0, 4);
        countSeason = countMonth.substring(5, 7).equals("01") || countMonth.substring(5, 7).equals("02") || countMonth.substring(5, 7).equals("03") ? "1" : (countMonth.substring(5, 7).equals("03") || countMonth.substring(5, 7).equals("04") || countMonth.substring(5, 7).equals("05") ? "2" : (countMonth.substring(5, 7).equals("07") || countMonth.substring(5, 7).equals("08") || countMonth.substring(5, 7).equals("09") ? "3" : "4"));
        String orderByStr = null;
        for (String key : param.getOrderMap().keySet()) {
            String value = (String)param.getOrderMap().get(key);
            orderByStr = key + " " + value;
        }
        String productionFlag = null;
        String warningFlagMonth = null;
        String warningFlagSeason = null;
        String warningFlagYear = null;
        String isImportant = null;
        if (params.get("productionFlag") != null) {
            productionFlag = (String)((Parameter)params.get("productionFlag")).getValue();
        }
        if (params.get("warningFlagMonth") != null) {
            warningFlagMonth = (String)((Parameter)params.get("warningFlagMonth")).getValue();
        }
        if (params.get("warningFlagSeason") != null) {
            warningFlagSeason = (String)((Parameter)params.get("warningFlagSeason")).getValue();
        }
        if (params.get("warningFlagYear") != null) {
            warningFlagYear = (String)((Parameter)params.get("warningFlagYear")).getValue();
        }
        if (params.get("isImportant") != null) {
            isImportant = (String)((Parameter)params.get("isImportant")).getValue();
        }
        if ((list = ((WarningMapper)this.baseMapper).warningList(text, tenantId, orgids = ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()), countMonth, countYear, countSeason, productionFlag, warningFlagMonth, warningFlagSeason, warningFlagYear, isImportant, orderByStr)) == null || list.size() <= 0) {
            page.put("records", new ArrayList());
            page.put("total", (Object)total);
            page.put("current", (Object)current);
            page.put("size", (Object)size);
            page.put("pages", (Object)pages);
            return page;
        }
        total = list.size();
        if (total % size > 0) {
            pages = total / size + 1;
        } else if (total % size == 0) {
            pages = total / size;
        }
        int num = 0;
        num = (current - 1) * size + size > total ? total - (current - 1) * size : size;
        ArrayList<Long> contractIds = new ArrayList<Long>();
        ArrayList<ProductionWarningVO> res = new ArrayList<ProductionWarningVO>();
        for (int i = (current - 1) * size; i < (current - 1) * size + num; ++i) {
            ProductionWarningVO productionWarningVO = list.get(i);
            if (productionWarningVO.getContractId() != null) {
                contractIds.add(productionWarningVO.getContractId());
            }
            res.add(productionWarningVO);
        }
        if (contractIds.size() <= 0) {
            page.put("records", res);
            page.put("total", (Object)total);
            page.put("current", (Object)current);
            page.put("size", (Object)size);
            page.put("pages", (Object)pages);
            return page;
        }
        page.put("records", res);
        page.put("total", (Object)total);
        page.put("current", (Object)current);
        page.put("size", (Object)size);
        page.put("pages", (Object)pages);
        return page;
    }

    @Override
    public boolean warningSend(Long projectId, String countMonth) {
        String countYear = null;
        String countSeason = null;
        countYear = countMonth.substring(0, 4);
        countSeason = countMonth.substring(5, 7).equals("01") || countMonth.substring(5, 7).equals("02") || countMonth.substring(5, 7).equals("03") ? "1" : (countMonth.substring(5, 7).equals("03") || countMonth.substring(5, 7).equals("04") || countMonth.substring(5, 7).equals("05") ? "2" : (countMonth.substring(5, 7).equals("07") || countMonth.substring(5, 7).equals("08") || countMonth.substring(5, 7).equals("09") ? "3" : "4"));
        ProductionWarningVO productionWarningVO = ((WarningMapper)this.baseMapper).warningByProjectId(projectId, countMonth, countYear, countSeason);
        IncomeWarningVO incomeWarningVO = new IncomeWarningVO();
        incomeWarningVO.setProjectId(projectId);
        incomeWarningVO.setProjectName(productionWarningVO.getProjectName());
        incomeWarningVO.setContractId(productionWarningVO.getContractId());
        incomeWarningVO.setContractName(productionWarningVO.getContractName());
        incomeWarningVO.setContractTaxMny(productionWarningVO.getContractTaxMny());
        incomeWarningVO.setCountMonth(countMonth);
        incomeWarningVO.setProductionMonth(productionWarningVO.getProductionNow());
        incomeWarningVO.setProductionSeason(productionWarningVO.getProductionSeason());
        incomeWarningVO.setProductionYear(productionWarningVO.getProductionYear());
        incomeWarningVO.setProductionPlanMoth(productionWarningVO.getProductionPlan());
        incomeWarningVO.setProductionPlanSeason(productionWarningVO.getProductionPlanSeason());
        incomeWarningVO.setProductionPlanYear(productionWarningVO.getProductionPlanYear());
        incomeWarningVO.setProductionScaleMonth(productionWarningVO.getProductionScaleMonth());
        incomeWarningVO.setProductionScaleSeason(productionWarningVO.getProductionScaleSeason());
        incomeWarningVO.setProductionScaleYear(productionWarningVO.getProductionScaleYear());
        incomeWarningVO.setWarningMonth(productionWarningVO.getWarningFlagMonth());
        incomeWarningVO.setWarningSeason(productionWarningVO.getWarningFlagSeason());
        incomeWarningVO.setWarningYear(productionWarningVO.getWarningFlagYear());
        incomeWarningVO.setOrgId(productionWarningVO.getOrgId());
        incomeWarningVO.setOrgName(productionWarningVO.getOrgName());
        incomeWarningVO.setDeptId(productionWarningVO.getProjectDepartmentId());
        CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
        incomeWarningVO.setBillCode((String)billCode.getData());
        IncomeWarningEntity entity = (IncomeWarningEntity)((Object)BeanMapper.map((Object)incomeWarningVO, IncomeWarningEntity.class));
        return this.incomeWarningService.saveOrUpdate((Object)entity, false);
    }
}

