package com.ejianc.business.income.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.income.history.ProductionPlanHistoryVo;
import com.ejianc.business.income.service.IWarningService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ImportTemplate;


@RestController
@RequestMapping("/warning")
public class WarningController {
	
	@Autowired
	private IWarningService warningService;
    /**
     * 产值统计报表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/warningList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> productionCountList(@RequestBody QueryParam param) {
        return CommonResponse.success("查询列表数据成功！", warningService.warningList(param));
    }
    
    /**
     * 成本利润报表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/costWarningList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> costWarningList(@RequestBody QueryParam param) {
        return CommonResponse.success("查询列表数据成功！", warningService.costWarningList(param));
    }
    /**
     * 产值预警通知
     * @param projectId countMonth
     * @return 
     * @return
    */
   @RequestMapping(value = "/warningSend", method = RequestMethod.GET)
   @ResponseBody
   public  CommonResponse<Boolean> queryProductionPlanHistory(@RequestParam Long projectId,@RequestParam String countMonth){
	   return CommonResponse.success(warningService.warningSend(projectId, countMonth)); 
   } 
   
   /**
    * 成本预警通知
    * @param projectId countMonth
    * @return 
    * @return
   */
   @RequestMapping(value = "/cbWarningSend", method = RequestMethod.GET)
   @ResponseBody
   public  CommonResponse<Boolean> cbWarningSend(@RequestParam Long projectId){
       return CommonResponse.success(warningService.costWarningSend(projectId, "cb")); 
   } 
   /**
    * 利润预警通知
    * @param projectId countMonth
    * @return 
    * @return
   */
   @RequestMapping(value = "/lrWarningSend", method = RequestMethod.GET)
   @ResponseBody
   public  CommonResponse<Boolean> lrWarningSend(@RequestParam Long projectId){
       return CommonResponse.success(warningService.costWarningSend(projectId, "lr"));  
   } 
   /**
    * 下载利润预警分析模板
    * @param request
    * @param response
    */
   @RequestMapping(value = "/downloadLrWarningTemp", method = RequestMethod.POST)
   @ResponseBody
   public void downloadLrWarningTemp(HttpServletRequest request, HttpServletResponse response) {
       ImportTemplate.initialize(response);
       ImportTemplate.templetdownload(request, "lr-warning.docx", "集团工程项目利润率消警专项说明及分析模板");
   }   /**
    * 下载成本预警分析模板
    * @param request
    * @param response
    */
   @RequestMapping(value = "/downloadCbWarningTemp", method = RequestMethod.POST)
   @ResponseBody
   public void downloadCbWarningTemp(HttpServletRequest request, HttpServletResponse response) {
       ImportTemplate.initialize(response);
       ImportTemplate.templetdownload(request, "cb-warning.docx", "集团工程项目成本控制消警专项说明及分析模板");
   }
   
}
