package com.ejianc.business.income.mapper;

import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.vo.CostWarningVo;
import com.ejianc.business.income.vo.warn.ProductionWarningVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface WarningMapper extends BaseCrudMapper<ContractEntity> {
    List<ProductionWarningVO> warningList(@Param("text")String text,
                                                @Param("tenantId")Long tenantId,
                                                @Param("orgids")List<Long> orgids,
                                                @Param("countMonth") String countMonth,
                                                @Param("countYear") String countYear,
                                                @Param("countSeason") String countSeason,
                                                @Param("productionFlag") String productionFlag,
                                                @Param("warningFlagMonth") String warningFlagMonth,
                                                @Param("warningFlagSeason") String warningFlagSeason,
                                                @Param("warningFlagYear") String warningFlagYear,
                                                @Param("isImportant") String isImportant,
                                                @Param("orderByStr") String orderByStr
                                                );
    
    List<CostWarningVo> costWarningList(@Param("text")String text,
                                                @Param("tenantId")Long tenantId,
                                                @Param("orgids")List<Long> orgids,
                                                @Param("orderByStr") String orderByStr,
                                                @Param("cbWarning")String cbWarning,
                                                @Param("lrlWarning")String lrlWarning,
                                                @Param("startDate")String startDate,
                                                @Param("endDate")String endDate,
                                                @Param("isWarning")String isWarning,
                                                @Param("isXiaojing")String isXiaojing
                                                );
    
    ProductionWarningVO warningByProjectId(
    		@Param("projectId") Long projectId,
            @Param("countMonth") String countMonth,
            @Param("countYear") String countYear,
            @Param("countSeason") String countSeason
            );
    CostWarningVo costWarningByProjectId(@Param("projectId") Long projectId
            );
}
