package com.ejianc.business.income.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.vo.report.IncomeReportMnyVo;
import com.ejianc.business.income.vo.report.ProjectReportVo;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public interface IReportService extends IBaseService<ContractEntity> {
    JSONObject pageList(QueryParam param);

    JSONObject monthPageList(QueryParam param);

    ProjectReportVo projectMonth(Long projectId, Integer lastDay);

    BigDecimal sumContractMny(Long projectId);

    List<ProjectReportVo> getMonthProductionMny(Long projectId, Integer lastDay);

    IncomeReportMnyVo getIncomeMny(Long projectId);

    List<ProjectReportVo> getMonthProduction(Long projectId);

    JSONObject productionCountList(QueryParam param);
    
    JSONObject projectProductionCountList(QueryParam param);
}
