package com.ejianc.business.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.income.bean.ContractDetailEntity;
import com.ejianc.business.income.mapper.ContractDetailMapper;
import com.ejianc.business.income.service.IContractDetailService;
import com.ejianc.business.income.utils.ExcelImportUtil;
import com.ejianc.business.income.vo.comparator.ContractDetailComparatorVo;
import com.ejianc.business.pub.tax.TaxCalculateUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.business.income.utils.TreeNodeBUtil;
import com.ejianc.business.income.vo.ContractDetailVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author yuezx
 * @since 2020-05-28
 */
@Service("ContractDetailService")
public class ContractDetailServiceImpl extends BaseServiceImpl<ContractDetailMapper, ContractDetailEntity> implements IContractDetailService {

    @Override
    public void deleteByContractId(Long id) {
        QueryWrapper<ContractDetailEntity> deleteWrapper = new QueryWrapper<>();
        deleteWrapper.eq("contract_id", id);
        baseMapper.delete(deleteWrapper);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                //筛选重复序号
                Map<String, Integer> indexMap = new HashMap<>();
                List<ContractDetailVo> detailVoList = new ArrayList<>();
                Map<String,String> tidMap = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    ContractDetailVo vo = new ContractDetailVo();
                    boolean flag = false;
                    boolean parentWarn = false;
                    String warnType = "";

                    String detailIndex = datas.get(0);
                    vo.setDetailIndex(detailIndex);
                    //维护父子关系
                    String id = UUID.randomUUID().toString().replaceAll("-", "");
                    if (StringUtils.isNotEmpty(detailIndex)) {//序号不为空
                        String[] split = detailIndex.split("[-/.]");
                        vo.setTid(id);
                        tidMap.put(detailIndex,id);
                        if (split.length > 1) {
                            vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                        }
                    } else {
                        vo.setTid(id);
                        vo.setTpid("");
                    }

                    if (indexMap.containsKey(detailIndex)) {//序号重复
                        return CommonResponse.error("第"+(i+2)+"行序号和第" + (indexMap.get(detailIndex)+2) + "行重复");
                    }else{
                        indexMap.put(detailIndex,i);
                    }

                    if(StringUtils.isEmpty(datas.get(1))){// 清单编码为空
                        vo.setCode(null);
                        warnType = warnType+"[清单编码为空]";
                        flag = true;
                        parentWarn = true;
                    }else{
                        vo.setCode(datas.get(1));
                    }

                    if (StringUtils.isEmpty(datas.get(2))) {//清单名称为空
                        vo.setName(null);
                        warnType =  warnType+"[清单名称为空]";
                        flag = true;
                        parentWarn = true;
                    } else {
                        vo.setName(datas.get(2));
                    }

                    vo.setUnit(datas.get(3));//计量单位

                    if (StringUtils.isEmpty(datas.get(4))) {
                        vo.setDetailTaxRate(null);
                    } else {
                        try {
                            vo.setDetailTaxRate(new BigDecimal(datas.get(4)));
                        } catch (Exception e) {
                            vo.setDetailTaxRate(null);
                            warnType = warnType+"[税率只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isEmpty(datas.get(5))) {
                        vo.setNum(null);
                        warnType = warnType+"[工程量为空]";
                        flag = true;
                    } else {
                        try {
                            vo.setNum(new BigDecimal(datas.get(5)));
                        } catch (Exception e) {
                            vo.setNum(null);
                            warnType = warnType+"[工程量只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isEmpty(datas.get(6))) {
                        vo.setPrice(null);
                    } else {
                        try {
                            vo.setPrice(new BigDecimal(datas.get(6)));
                        } catch (Exception e) {
                            vo.setPrice(null);
                            warnType = warnType+"[综合单价(无税)只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(7))) {
                        vo.setDetailTaxPrice(null);
                    } else {
                        try {
                            vo.setDetailTaxPrice(new BigDecimal(datas.get(7)));
                        } catch (Exception e) {
                            vo.setDetailTaxPrice(null);
                            warnType = warnType+"[综合单价只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(8))) {
                        vo.setMny(null);
                    } else {
                        try {
                            vo.setMny(new BigDecimal(datas.get(8)));
                        } catch (Exception e) {
                            vo.setMny(null);
                            warnType = warnType+"[合价(无税)只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(9))) {
                        vo.setDetailTaxMny(null);
                    } else {
                        try {
                            vo.setDetailTaxMny(new BigDecimal(datas.get(9)));
                        } catch (Exception e) {
                            vo.setDetailTaxMny(null);
                            warnType = warnType+"[合价只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(10))) {
                        vo.setDetailTax(null);
                    } else {
                        try {
                            vo.setDetailTax(new BigDecimal(datas.get(10)));
                        } catch (Exception e) {
                            vo.setDetailTax(null);
                            warnType = warnType+"[税额只能为数字或小数]";
                            flag = true;
                        }
                    }

                    vo.setMemo(datas.get(11));

                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    vo.setParentWarn(parentWarn);
                    vo.setWarnType(warnType);
                    vo.setRowState("add");
                    vo.setShadowId(vo.getTid());
                    vo.setChangeType(3);//增补项
                    detailVoList.add(vo);
                }

                for(ContractDetailVo tVo:detailVoList){
                    tVo.setTpid(tidMap.get(tVo.getTpid()));
                }
                new TaxCalculateUtil<ContractDetailVo>().calculate(detailVoList);
                List<Map<String, Object>> deailTreeData =ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
                List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
                List<Map<String, Object>> falseList = new ArrayList<>();
                List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
                List<Map<String, Object>> errorList=ExcelImportUtil.treeToList(allList.get(1));
                resp.put("successList",allList.get(0));
                resp.put("errorList",errorList);
                resp.put("successNum",result.size() - errorList.size());
                resp.put("errorNum",errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }
    //清单参照
    @Override
    public List<ContractDetailVo> detailRef(Long contractId,String qureyText) {
        QueryWrapper<ContractDetailEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("contract_id", contractId);
        wrapper.ne("change_type",5);//中止不显示
        if(StringUtils.isNotEmpty(qureyText)) {
        	wrapper.like("name", qureyText);
        }
        wrapper.orderBy(true,true,"detail_index");
        List<ContractDetailEntity> entities = baseMapper.selectList(wrapper);
        if(entities != null && entities.size() > 0) {
        	if(StringUtils.isNotEmpty(qureyText)) {
            	List<ContractDetailEntity> listTemp= new ArrayList<ContractDetailEntity>();
            	List<ContractDetailEntity> listChild= new ArrayList<ContractDetailEntity>();
            	for (ContractDetailEntity cdEntity : entities) {
    				if(cdEntity.getParentId()!=null) {
    					addFather(cdEntity.getParentId(),listTemp);
    				}
    				if(!cdEntity.getLeafFlag()) {
    					addChild(cdEntity.getId(),listChild);
    				}
    			}
            	entities.addAll(listTemp);
            	entities.addAll(listChild);
                entities.stream().distinct().collect(Collectors.toList());
        	}
            for(ContractDetailEntity cdEntity:entities){
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId()!= null&&cdEntity.getParentId()>0?cdEntity.getParentId().toString():"");
            }
        }
        List<ContractDetailVo> detailVos = BeanMapper.mapList(entities, ContractDetailVo.class);
        //实现排序
        Collections.sort(detailVos,new ContractDetailComparatorVo());
        return TreeNodeBUtil.buildTree(detailVos);
    }
    public List<ContractDetailEntity> addFather(Long id,List<ContractDetailEntity> list){
    	QueryWrapper<ContractDetailEntity> wrapper = new QueryWrapper<>();
    	wrapper.eq("id", id);
		ContractDetailEntity entity=baseMapper.selectOne(wrapper);
		entity.setIsOpen("1");
		list.add(entity);
		if(entity.getParentId() !=null) {
			this.addFather(entity.getParentId(),list);
		}
		return list;	
    }
    public List<ContractDetailEntity> addChild(Long id,List<ContractDetailEntity> list){
    	QueryWrapper<ContractDetailEntity> wrapper = new QueryWrapper<>();
    	wrapper.eq("parent_id", id);
		List<ContractDetailEntity> entityList=baseMapper.selectList(wrapper);
		if(entityList!=null) {
			entityList.forEach(e->{	
				list.add(e);
				if(!e.getLeafFlag()) {
					addChild(e.getId(),list);
				}	
			});
		}
		return list;	
    }

}
