package com.ejianc.business.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.income.bean.ClaimEntity;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.bean.IncomeWarningEntity;
import com.ejianc.business.income.bean.ProductionEntity;
import com.ejianc.business.income.bean.QuoteEntity;
import com.ejianc.business.income.bean.costWarningInforEntity;
import com.ejianc.business.income.mapper.ReportMapper;
import com.ejianc.business.income.mapper.WarningMapper;
import com.ejianc.business.income.service.IClaimService;
import com.ejianc.business.income.service.IIncomeWarningService;
import com.ejianc.business.income.service.IProductionService;
import com.ejianc.business.income.service.IQuoteService;
import com.ejianc.business.income.service.IReportService;
import com.ejianc.business.income.service.IWarningService;
import com.ejianc.business.income.service.IcostWarningInforService;
import com.ejianc.business.income.utils.MathUtil;
import com.ejianc.business.income.utils.MonthUtil;
import com.ejianc.business.income.vo.report.*;
import com.ejianc.business.income.vo.warn.ProductionWarningVO;
import com.ejianc.business.income.vo.CostWarningVo;
import com.ejianc.business.income.vo.IncomeWarningVO;
import com.ejianc.business.income.vo.ProjectProductionVo;
import com.ejianc.business.income.vo.costWarningInforVO;
import com.ejianc.business.income.vo.comparator.MonthComparatorVo;
import com.ejianc.business.income.vo.comparator.ReportComparatorVo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.sun.xml.bind.util.Which;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service
public class WarningServiceImpl extends BaseServiceImpl<WarningMapper, ContractEntity> implements IWarningService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IOrgApi orgApi;
    
    @Autowired
    private IIncomeWarningService incomeWarningService;
    @Autowired
    private IcostWarningInforService costWarningInforService;
    @Autowired
    private IBillCodeApi billCodeApi;
    
    private static final String BILL_CODE = "IncomeWarn_Code";//此处需要根据实际修改
    private static final String Cost_BILL_CODE = "CostWarning_Code";//此处需要根据实际修改
    /**
     * 成本利润预警报表
     * @param param
     * @return
     */
    @Override
    public JSONObject costWarningList(QueryParam param) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        int pageIndex = param.getPageIndex();//第几页
        int pageSize = param.getPageSize();//一页多少条
        Map<String, Parameter> params = param.getParams();//入参
        String text = param.getSearchText();//模糊查询
        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        int total = 0;//总条数
        int current = pageIndex;//第几页
        int size = pageSize;//一页几条
        int pages = 0;//有几页
        String orderByStr=null;
        for(String key : param.getOrderMap().keySet()){
        	String value = param.getOrderMap().get(key);
        	orderByStr=key+" "+value;
        	}
        String cbWarning=null;
        String lrlWarning=null;
        String isWarning=null;
        String isXiaojing=null;
        String startDate=null;
        String endDate=null;
        
        if(params.get("cbWarning") != null) {
        	cbWarning=(String)params.get("cbWarning").getValue();
        }
        if(params.get("lrlWarning") != null) {
        	lrlWarning=(String)params.get("lrlWarning").getValue();
        }
        if(params.get("isWarning") != null) {
        	isWarning=(String)params.get("isWarning").getValue();
        }
        if(params.get("isXiaojing") != null) {
        	isXiaojing=(String)params.get("isXiaojing").getValue();
        }
        if(params.get("startDate") != null) {
        	String startDateTemp=(String)params.get("startDate").getValue();
        	startDate=" start_Date BETWEEN STR_TO_DATE('"+startDateTemp.split(",")[0]+"','%Y-%m-%d') and STR_TO_DATE('"+startDateTemp.split(",")[1]+"','%Y-%m-%d')";
        }
        if(params.get("endDate") != null) {
        	String endDateTemp=(String)params.get("endDate").getValue();
        	endDate=" end_Date BETWEEN STR_TO_DATE('"+endDateTemp.split(",")[0]+"','%Y-%m-%d') and STR_TO_DATE('"+endDateTemp.split(",")[1]+"','%Y-%m-%d')";
        }
        
        
        List<Long> orgids = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());


        List<CostWarningVo> list = baseMapper.costWarningList(text,tenantId,orgids,orderByStr,cbWarning,lrlWarning,startDate,endDate,isWarning,isXiaojing);
        if(list==null||list.size()<=0){
            page.put("records", new ArrayList<>());
            page.put("total", total);
            page.put("current", current);
            page.put("size", size);
            page.put("pages", pages);
            return page;
        }
        total = list.size();
        if (total % size > 0) {
            pages = (total / size) + 1;
        } else if (total % size == 0) {
            pages = total / size;
        }
        // 要查第几页
        //要查的这一页有几条数据
        int num = 0;
        if ((current - 1) * size + size > total) {
            num = total - ((current - 1) * size);
        } else {
            num = size;
        }
        List<Long> contractIds = new ArrayList<>();
        List<CostWarningVo> res = new ArrayList<>();
        for (int i = (current - 1) * size; i < (current - 1) * size + num; i++) {
        	CostWarningVo costWarningVo = list.get(i);
        	
            if(costWarningVo.getContractId()!=null){
                contractIds.add(costWarningVo.getContractId());
            }
            res.add(costWarningVo);
        }
        if(contractIds.size()<=0){
            page.put("records", res);
            page.put("total", total);
            page.put("current", current);
            page.put("size", size);
            page.put("pages", pages);
            return page;
        }
        page.put("records", res);
        page.put("total", total);
        page.put("current", current);
        page.put("size", size);
        page.put("pages", pages);
        return page;
    }
    
    /**
     * 产值统计报表
     * @param param
     * @return
     */
    @Override
    public JSONObject warningList(QueryParam param) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        int pageIndex = param.getPageIndex();//第几页
        int pageSize = param.getPageSize();//一页多少条
        Map<String, Parameter> params = param.getParams();//入参
        String text = param.getSearchText();//模糊查询
        String countMonth = null;// 统计月份
        String countYear = null;//统计年份
        String countSeason=null;//统计季度
        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        int total = 0;//总条数
        int current = pageIndex;//第几页
        int size = pageSize;//一页几条
        int pages = 0;//有几页
        if (params.get("countMonth") == null) {
            page.put("records", new ArrayList<>());
            page.put("total", total);
            page.put("current", current);
            page.put("size", size);
            page.put("pages", pages);
            return page;
        }else{
            countMonth = (String) params.get("countMonth").getValue();
            countYear = countMonth.substring(0,4);
            if(countMonth.substring(5,7).equals("01")||countMonth.substring(5,7).equals("02")||countMonth.substring(5,7).equals("03")) {
            	countSeason = "1";
            }else if(countMonth.substring(5,7).equals("03")||countMonth.substring(5,7).equals("04")||countMonth.substring(5,7).equals("05")){
            	countSeason = "2";
            }else if(countMonth.substring(5,7).equals("07")||countMonth.substring(5,7).equals("08")||countMonth.substring(5,7).equals("09")) {
            	countSeason = "3";
            }else {
            	countSeason = "4";
            }
        }
        String orderByStr=null;
        for(String key : param.getOrderMap().keySet()){
        	String value = param.getOrderMap().get(key);
        	orderByStr=key+" "+value;
        	}
        
        String productionFlag=null;
        String warningFlagMonth=null;
        String warningFlagSeason=null;
        String warningFlagYear=null;
        String isImportant=null;
        
        if(params.get("productionFlag") != null) {
        	productionFlag=(String)params.get("productionFlag").getValue();
        }
        if(params.get("warningFlagMonth") != null) {
        	warningFlagMonth=(String)params.get("warningFlagMonth").getValue();
        }
        if(params.get("warningFlagSeason") != null) {
        	warningFlagSeason=(String)params.get("warningFlagSeason").getValue();
        }
        if(params.get("warningFlagYear") != null) {
        	warningFlagYear=(String)params.get("warningFlagYear").getValue();
        }
        if(params.get("isImportant") != null) {
        	isImportant=(String)params.get("isImportant").getValue();
        }
        
        List<Long> orgids = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());


        List<ProductionWarningVO> list = baseMapper.warningList(text,tenantId,orgids,countMonth,countYear,countSeason,productionFlag,warningFlagMonth,warningFlagSeason,warningFlagYear,isImportant,orderByStr);
        if(list==null||list.size()<=0){
            page.put("records", new ArrayList<>());
            page.put("total", total);
            page.put("current", current);
            page.put("size", size);
            page.put("pages", pages);
            return page;
        }
        total = list.size();
        if (total % size > 0) {
            pages = (total / size) + 1;
        } else if (total % size == 0) {
            pages = total / size;
        }
        // 要查第几页
        //要查的这一页有几条数据
        int num = 0;
        if ((current - 1) * size + size > total) {
            num = total - ((current - 1) * size);
        } else {
            num = size;
        }
        List<Long> contractIds = new ArrayList<>();
        List<ProductionWarningVO> res = new ArrayList<>();
        for (int i = (current - 1) * size; i < (current - 1) * size + num; i++) {
        	ProductionWarningVO productionWarningVO = list.get(i);
            if(productionWarningVO.getContractId()!=null){
                contractIds.add(productionWarningVO.getContractId());
            }
            res.add(productionWarningVO);
        }
        if(contractIds.size()<=0){
            page.put("records", res);
            page.put("total", total);
            page.put("current", current);
            page.put("size", size);
            page.put("pages", pages);
            return page;
        }
        page.put("records", res);
        page.put("total", total);
        page.put("current", current);
        page.put("size", size);
        page.put("pages", pages);
        return page;
    }
    
	@Override
	public boolean warningSend(Long projectId, String countMonth) {
        String countYear = null;//统计年份
        String countSeason=null;//统计季度
        countYear = countMonth.substring(0,4);
        if(countMonth.substring(5,7).equals("01")||countMonth.substring(5,7).equals("02")||countMonth.substring(5,7).equals("03")) {
        	countSeason = "1";
        }else if(countMonth.substring(5,7).equals("03")||countMonth.substring(5,7).equals("04")||countMonth.substring(5,7).equals("05")){
        	countSeason = "2";
        }else if(countMonth.substring(5,7).equals("07")||countMonth.substring(5,7).equals("08")||countMonth.substring(5,7).equals("09")) {
        	countSeason = "3";
        }else {
        	countSeason = "4";
        }
        ProductionWarningVO productionWarningVO=baseMapper.warningByProjectId(projectId, countMonth, countYear, countSeason);
        IncomeWarningVO incomeWarningVO=new IncomeWarningVO();
        //组装预警单
        incomeWarningVO.setProjectId(projectId);
        incomeWarningVO.setProjectName(productionWarningVO.getProjectName());
        incomeWarningVO.setContractId(productionWarningVO.getContractId());
        incomeWarningVO.setContractName(productionWarningVO.getContractName());
        incomeWarningVO.setContractTaxMny(productionWarningVO.getContractTaxMny());
        incomeWarningVO.setCountMonth(countMonth);
        incomeWarningVO.setProductionMonth(productionWarningVO.getProductionNow());
        incomeWarningVO.setProductionSeason(productionWarningVO.getProductionSeason());
        incomeWarningVO.setProductionYear(productionWarningVO.getProductionYear());
        incomeWarningVO.setProductionPlanMoth(productionWarningVO.getProductionPlan());
        incomeWarningVO.setProductionPlanSeason(productionWarningVO.getProductionPlanSeason());
        incomeWarningVO.setProductionPlanYear(productionWarningVO.getProductionPlanYear());
        incomeWarningVO.setProductionScaleMonth(productionWarningVO.getProductionScaleMonth());
        incomeWarningVO.setProductionScaleSeason(productionWarningVO.getProductionScaleSeason());
        incomeWarningVO.setProductionScaleYear(productionWarningVO.getProductionScaleYear());
        incomeWarningVO.setWarningMonth(productionWarningVO.getWarningFlagMonth());
        incomeWarningVO.setWarningSeason(productionWarningVO.getWarningFlagSeason());
        incomeWarningVO.setWarningYear(productionWarningVO.getWarningFlagYear());
        incomeWarningVO.setOrgId(productionWarningVO.getOrgId());
        incomeWarningVO.setOrgName(productionWarningVO.getOrgName());
        incomeWarningVO.setDeptId(productionWarningVO.getProjectDepartmentId());
        CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
        incomeWarningVO.setBillCode(billCode.getData());
        IncomeWarningEntity entity = BeanMapper.map(incomeWarningVO, IncomeWarningEntity.class);
        return incomeWarningService.saveOrUpdate(entity, false);
	}

	@Override
	public boolean costWarningSend(Long projectId,String warningType) {
		CostWarningVo costWarningVo = baseMapper.costWarningByProjectId(projectId);
		costWarningInforVO costWarningInforVo=new costWarningInforVO();
		costWarningInforVo.setProjectId(projectId);
		costWarningInforVo.setProjectName(costWarningVo.getName());
		costWarningInforVo.setContractId(costWarningVo.getContractId());
		costWarningInforVo.setContractName(costWarningVo.getContractName());
		costWarningInforVo.setContractTaxMny(costWarningVo.getContractTaxMny());
		costWarningInforVo.setWarningDate(new Date());
		costWarningInforVo.setProductionMonth(costWarningVo.getProductionMny());
		costWarningInforVo.setResponsibilityCost(costWarningVo.getResponsibilityCost());
		costWarningInforVo.setCostMny(costWarningVo.getCostMny());
		costWarningInforVo.setCbpc(costWarningVo.getCbpc());
		costWarningInforVo.setGclr(costWarningVo.getGclr());
		costWarningInforVo.setGclrl(costWarningVo.getGclrl());
		costWarningInforVo.setTargetProfit(costWarningVo.getTargetProfit());
		costWarningInforVo.setLrlpc(costWarningVo.getLrlpc());
		costWarningInforVo.setOrgId(costWarningVo.getOrgId());
		costWarningInforVo.setOrgName(costWarningVo.getOrgName());
		costWarningInforVo.setDeptId(costWarningVo.getDeptId());
		costWarningInforVo.setWarningType(warningType);
		CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(Cost_BILL_CODE, InvocationInfoProxy.getTenantid());
		costWarningInforVo.setBillCode(billCode.getData());
		costWarningInforEntity entity = BeanMapper.map(costWarningInforVo, costWarningInforEntity.class);
	    return costWarningInforService.saveOrUpdate(entity, false);
	}

    
}
