package com.ejianc.business.inother.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.inother.bean.OtherContractEntity;
import com.ejianc.business.inother.history.OtherSettleHistoryVO;
import com.ejianc.business.inother.service.IOtherContractService;
import com.ejianc.business.inother.vo.OtherSettleVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.inother.bean.OtherSettleEntity;
import com.ejianc.business.inother.service.IOtherSettleService;

/**
 * 其他收入合同结算
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("otherSettle")
public class OtherSettleController implements Serializable {
    @Autowired
    private IOtherSettleService quoteService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IOtherContractService contractService;

    /**
     * 新增或编辑
     * @param
     * @return
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OtherSettleVO> saveOrUpdate(@RequestBody OtherSettleVO vo) {
        CommonResponse<OtherSettleVO> response = quoteService.saveOrUpdate(vo);
        return response;
    }
    /**
     * 根据主键ID查询详情
     *
     * @param id
     * @return
     */
//    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
//    @ResponseBody
//    public CommonResponse<OtherSettleVO>  queryDetail(@RequestParam Long id) {
//        OtherSettleVO vo= quoteService.queryDetail(id);
//        return CommonResponse.success(vo);
//    }

    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherSettleVO> queryDetail(Long id) {
        OtherSettleEntity entity = quoteService.selectById(id);
        OtherSettleVO vo = BeanMapper.map(entity, OtherSettleVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     * 查询分页列表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OtherSettleVO>> pageList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //项目名称、合同名称、变更摘要、变更签证编号、经办人
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id",new Parameter("in",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime","desc");
        IPage<OtherSettleEntity> page = quoteService.queryPage(param,false);
        IPage<OtherSettleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OtherSettleVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * 删除
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OtherSettleVO> vos) {
        List<Long> ids = vos.stream().map(OtherSettleVO::getId).collect(Collectors.toList());

        LambdaQueryWrapper<OtherSettleEntity> lambda = Wrappers.lambdaQuery();
        lambda.in(OtherSettleEntity::getId, ids);
        List<OtherSettleEntity> finishEntities = quoteService.list(lambda);
        if (CollectionUtils.isNotEmpty(finishEntities)) {
            List<Long> contractIds = finishEntities.stream().map(OtherSettleEntity::getContractId).collect(Collectors.toList());
            //更新合同是否竣工结算标志，合同做完竣工结算则做产值和报量参照不到
            LambdaUpdateWrapper<OtherContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.set(OtherContractEntity::getIsFinish, 0);
            updateWrapper.in(OtherContractEntity::getId, contractIds);
            contractService.update(updateWrapper);
        }

        quoteService.removeByIds(ids, true);
        return CommonResponse.success("删除成功！");
    }
    /**
     * 历史记录
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryQuoteHistory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherSettleHistoryVO> queryQuoteHistory(@RequestParam Long id) {
        OtherSettleHistoryVO vo = quoteService.queryQuoteHistory(id);
        return CommonResponse.success(vo);
    }
    /**
     * 导出
     *
     * @param param
     * @return
     */
    @PostMapping("excelExport")
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //项目名称、合同名称、变更摘要、变更签证编号、经办人
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id",new Parameter("in",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime","desc");
        param.setPageIndex(1);
        param.setPageSize(-1);
        // 是否生成凭证
        //NCUtil.voucherParam(param);
        IPage<OtherSettleEntity> pageData = quoteService.queryPage(param, false);

        Map<String, Object> beans = new HashMap<String, Object>();
        List<OtherSettleVO> list = new ArrayList<>();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty(pageData.getRecords())) {
            list = BeanMapper.mapList(pageData.getRecords(), OtherSettleVO.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });

        }
        beans.put("records", list);
        ExcelExport.getInstance().export("settle-export.xlsx", beans, response);
    }

    @RequestMapping(value = "/verifyContract", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> verifyContract(@RequestParam Long contractId,@RequestParam(value = "billId", required = false) Long billId) {
        //合同结算只能存在一条未生效的
        LambdaQueryWrapper<OtherSettleEntity> lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(OtherSettleEntity::getContractId, contractId);
        lambdaQuery.notIn(OtherSettleEntity::getBillState,1,3);
        if (billId != null && billId > 0) {
            lambdaQuery.ne(OtherSettleEntity::getId, billId);
        }
        int num = quoteService.count(lambdaQuery);
        if (num > 0) {
            return CommonResponse.error("该合同存在未生效的合同结算!");
        }
        return CommonResponse.success();
    }
}
