package com.ejianc.business.income.mapper;

import com.ejianc.business.income.bean.QuoteEntity;
import com.ejianc.business.income.vo.QuoteDetailVo;
import com.ejianc.business.income.vo.report.FinanceUseResSubVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 甲方报量 Mapper 接口
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
@Mapper
public interface QuoteMapper extends BaseCrudMapper<QuoteEntity> {
    @Select("SELECT MAX(quote_date) from ejc_income_quote eip where eip.dr=0 and contract_id=#{contractId} and eip.bill_state in (1,3)")
    Date getLastDate(Long contractId);
    @Select("SELECT d.*,SUM(d.quote_num) AS numSum, SUM(d.quote_mny) AS priceSum FROM ejc_income_quote_detail d LEFT JOIN ejc_income_quote q ON d.quote_id = q.id WHERE d.dr = 0 AND d.`code` = #{code} AND d.`name` = #{name} AND d.contract_detail_id = #{contractDetailId} AND q.bill_state in (1,3)")
    QuoteDetailVo queryNumAndPriceSum(Map<String, Object> map);
    /**
     * <p>
     * 租户 组织维度查询 累计甲方报量金额
     * </p>
     *
     * @author jiangyikai
     * @since 2020-06-04
     */
    BigDecimal totalQuoteMoney(Integer range, String year, List<Long> orgIds, Long tenantId);

    /**
     * 根据来源主键（合同清单）查询历史数据的含本期累计工程量
     * @param
     * @param
     * @return
     */
    List<QuoteDetailVo> queryQuoteDetailHistory(QuoteDetailVo quoteDetailVo);

    List<QuoteDetailVo> queryQuoteDetailList(QuoteDetailVo quoteDetailVo);

    String queryQuoteDetailSum(QuoteDetailVo vo_tmp);

    List<FinanceUseResSubVO> totalFinQuoteMoney(@Param("startMonth")String startMonth,@Param("endMonth") String endMonth, @Param("orgIds") List<Long> orgIds,@Param("tenantId")Long tenantId);

}
