/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.income.bean.ClaimEntity;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.bean.ProductionEntity;
import com.ejianc.business.income.bean.QuoteClaimEntity;
import com.ejianc.business.income.bean.QuoteDetailEntity;
import com.ejianc.business.income.bean.QuoteEntity;
import com.ejianc.business.income.service.IClaimService;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.service.IProductionService;
import com.ejianc.business.income.service.IQuoteClaimService;
import com.ejianc.business.income.service.IQuoteDetailService;
import com.ejianc.business.income.service.IQuoteService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="quote")
public class QuoteBpmService
implements ICommonBusinessService {
    @Autowired
    private IContractService contractService;
    @Autowired
    private IQuoteService quoteService;
    @Autowired
    private IClaimService claimService;
    @Autowired
    private IQuoteClaimService quoteClaimService;
    @Autowired
    private IQuoteDetailService quoteDetailService;
    @Autowired
    private IProductionService productionService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        List checkList;
        QuoteEntity quoteEntity = (QuoteEntity)((Object)this.quoteService.selectById(billId));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(quoteEntity.getContractId()));
        BigDecimal quoteTaxMny = quoteEntity.getQuoteTaxMny() == null ? BigDecimal.ZERO : quoteEntity.getQuoteTaxMny();
        BigDecimal sumQuoteTaxMny = contractEntity.getSumQuoteTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumQuoteTaxMny();
        contractEntity.setSumQuoteTaxMny(quoteTaxMny.add(sumQuoteTaxMny));
        BigDecimal quoteMny = quoteEntity.getQuoteMny() == null ? BigDecimal.ZERO : quoteEntity.getQuoteMny();
        BigDecimal sumQuoteMny = contractEntity.getSumQuoteMny() == null ? BigDecimal.ZERO : contractEntity.getSumQuoteMny();
        contractEntity.setSumQuoteMny(quoteMny.add(sumQuoteMny));
        this.contractService.updateById((Object)contractEntity);
        QueryParam parm = new QueryParam();
        parm.getParams().put("quoteId", new Parameter("eq", (Object)quoteEntity.getId()));
        List claimList = this.quoteClaimService.queryList(parm, false);
        if (null != claimList && claimList.size() > 0) {
            ArrayList<Long> ids = new ArrayList<Long>();
            HashMap<Long, BigDecimal> idMap = new HashMap<Long, BigDecimal>();
            for (QuoteClaimEntity pce : claimList) {
                ids.add(pce.getClaimId());
                idMap.put(pce.getClaimId(), pce.getOccurMny());
            }
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter("in", ids));
            List claimEntities = this.claimService.queryList(queryParam, false);
            Iterator iterator = claimEntities.iterator();
            while (iterator.hasNext()) {
                ClaimEntity ce;
                ce.setSumQuoteMny(((ce = (ClaimEntity)((Object)iterator.next())).getSumQuoteMny() == null ? BigDecimal.ZERO : ce.getSumQuoteMny()).add(idMap.get(ce.getId()) == null ? BigDecimal.ZERO : (BigDecimal)idMap.get(ce.getId())));
            }
            this.claimService.updateBatchById(claimEntities);
        }
        if (null != (checkList = this.quoteDetailService.queryList(parm, false)) && checkList.size() > 0) {
            HashSet<Long> ids = new HashSet<Long>();
            for (QuoteDetailEntity qde : checkList) {
                if (null == qde.getProductionId() || qde.getProductionId() <= 0L || !ids.add(qde.getProductionId())) continue;
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.set(ProductionEntity::getQuoteFlag, (Object)1);
                updateWrapper.eq(BaseEntity::getId, (Object)qde.getProductionId());
                this.productionService.update((Wrapper)updateWrapper);
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (res.isSuccess()) {
            this.callBackQuote(billId, state, billTypeCode);
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }

    private void callBackQuote(Long billId, Integer state, String billTypeCode) {
        List checkList;
        QuoteEntity quoteEntity = (QuoteEntity)((Object)this.quoteService.selectById(billId));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(quoteEntity.getContractId()));
        BigDecimal quoteTaxMny = quoteEntity.getQuoteTaxMny() == null ? BigDecimal.ZERO : quoteEntity.getQuoteTaxMny();
        BigDecimal sumQuoteTaxMny = contractEntity.getSumQuoteTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumQuoteTaxMny();
        contractEntity.setSumQuoteTaxMny(sumQuoteTaxMny.subtract(quoteTaxMny));
        BigDecimal quoteMny = quoteEntity.getQuoteMny() == null ? BigDecimal.ZERO : quoteEntity.getQuoteMny();
        BigDecimal sumQuoteMny = contractEntity.getSumQuoteMny() == null ? BigDecimal.ZERO : contractEntity.getSumQuoteMny();
        contractEntity.setSumQuoteMny(sumQuoteMny.subtract(quoteMny));
        this.contractService.updateById((Object)contractEntity);
        QueryParam parm = new QueryParam();
        parm.getParams().put("quoteId", new Parameter("eq", (Object)quoteEntity.getId()));
        List claimList = this.quoteClaimService.queryList(parm, false);
        if (null != claimList && claimList.size() > 0) {
            ArrayList<Long> ids = new ArrayList<Long>();
            HashMap<Long, BigDecimal> idMap = new HashMap<Long, BigDecimal>();
            for (QuoteClaimEntity pce : claimList) {
                ids.add(pce.getClaimId());
                idMap.put(pce.getClaimId(), pce.getOccurMny());
            }
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter("in", ids));
            List claimEntities = this.claimService.queryList(queryParam, false);
            Iterator iterator = claimEntities.iterator();
            while (iterator.hasNext()) {
                ClaimEntity ce;
                ce.setSumQuoteMny(((ce = (ClaimEntity)((Object)iterator.next())).getSumQuoteMny() == null ? BigDecimal.ZERO : ce.getSumQuoteMny()).subtract(idMap.get(ce.getId()) == null ? BigDecimal.ZERO : (BigDecimal)idMap.get(ce.getId())));
            }
            this.claimService.updateBatchById(claimEntities);
        }
        if (null != (checkList = this.quoteDetailService.queryList(parm, false)) && checkList.size() > 0) {
            HashSet<Long> ids = new HashSet<Long>();
            for (QuoteDetailEntity qde : checkList) {
                if (null == qde.getProductionId() || qde.getProductionId() <= 0L || !ids.add(qde.getProductionId())) continue;
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.set(ProductionEntity::getQuoteFlag, (Object)0);
                updateWrapper.eq(BaseEntity::getId, (Object)qde.getProductionId());
                this.productionService.update((Wrapper)updateWrapper);
            }
        }
    }
}

