package com.ejianc.business.invest.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 立项工作进展-详情
 * 
 * @author generator
 * 
 */
public class WorkProgressDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private String updateUserName; // 修改者
    private String description; // 描述
    private String stage; // 阶段(0:汇总1:报审2:调整报审)
    private String progress; // 进展(0:内部进行中1:外部进行中2:完成)
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date planFinishDate; // 预计结束日期
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date lastTrackDate; // 实际结束日期
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date actualFinishDate; // 最新跟踪日期
    private Long workListId; // 工作清单id
    private String workListName; // 工作清单手续项
    private String workListCode; // 工作清单编号
    private Long pid; // 主表id
    private Long projectId; // 预立项项目id
    private String projectName; // 预立项项目名称
    private String projectCode; // 预立项项目编号
    private List<WorkProgressTrackVO> workProgressTrackList = new ArrayList<>(); // 立项工作进展-详情


    public List<WorkProgressTrackVO> getWorkProgressTrackList() {
        return workProgressTrackList;
    }
    @ReferSerialTransfer(referCode="invest_project_advance_set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public void setWorkProgressTrackList(List<WorkProgressTrackVO> workProgressTrackList) {
        this.workProgressTrackList = workProgressTrackList;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
    public String getStage() {
        return stage;
    }

    public void setStage(String stage) {
        this.stage = stage;
    }
    public String getProgress() {
        return progress;
    }

    public void setProgress(String progress) {
        this.progress = progress;
    }
    public Date getPlanFinishDate() {
        return planFinishDate;
    }

    public void setPlanFinishDate(Date planFinishDate) {
        this.planFinishDate = planFinishDate;
    }
    public Date getLastTrackDate() {
        return lastTrackDate;
    }

    public void setLastTrackDate(Date lastTrackDate) {
        this.lastTrackDate = lastTrackDate;
    }
    public Date getActualFinishDate() {
        return actualFinishDate;
    }

    public void setActualFinishDate(Date actualFinishDate) {
        this.actualFinishDate = actualFinishDate;
    }

    @ReferSerialTransfer(referCode="invest_work_list")
    public Long getWorkListId() {
        return workListId;
    }
    @ReferDeserialTransfer
    public void setWorkListId(Long workListId) {
        this.workListId = workListId;
    }
    public String getWorkListName() {
        return workListName;
    }

    public void setWorkListName(String workListName) {
        this.workListName = workListName;
    }
    public String getWorkListCode() {
        return workListCode;
    }

    public void setWorkListCode(String workListCode) {
        this.workListCode = workListCode;
    }
    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }
    
}
