/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.utils;

import com.ejianc.business.budget.vo.DynamicsCostVO;
import com.ejianc.business.budget.vo.SubjectDetailProVO;
import com.ejianc.business.cost.utils.ITreeNodeB;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TreeNodeBUtil {
    public static <T extends ITreeNodeB> List<T> buildTree(List<T> values) {
        ITreeNodeB parentNode;
        HashMap<Long, ITreeNodeB> nodeMap = new HashMap<Long, ITreeNodeB>();
        ArrayList<ITreeNodeB> result = new ArrayList<ITreeNodeB>();
        ArrayList<ITreeNodeB> emptyValueList = new ArrayList<ITreeNodeB>();
        for (ITreeNodeB value : values) {
            if (null == value.getParentID() || value.getParentID() == 0L) {
                result.add(value);
            } else {
                parentNode = (ITreeNodeB)nodeMap.get(value.getParentID());
                if (parentNode == null) {
                    emptyValueList.add(value);
                } else {
                    parentNode.getChildren().add(value);
                }
            }
            nodeMap.put(value.getNodeID(), value);
        }
        if (!emptyValueList.isEmpty()) {
            for (ITreeNodeB value : emptyValueList) {
                parentNode = (ITreeNodeB)nodeMap.get(value.getParentID());
                if (parentNode == null) {
                    result.add(value);
                    continue;
                }
                parentNode.getChildren().add(value);
            }
        }
        return result;
    }

    public static List<SubjectDetailProVO> buildTreeSubjectDetailProVO(List<SubjectDetailProVO> values) {
        BigDecimal sum;
        SubjectDetailProVO parentNode;
        HashMap<Long, SubjectDetailProVO> nodeMap = new HashMap<Long, SubjectDetailProVO>();
        ArrayList<SubjectDetailProVO> result = new ArrayList<SubjectDetailProVO>();
        ArrayList<SubjectDetailProVO> emptyValueList = new ArrayList<SubjectDetailProVO>();
        for (SubjectDetailProVO value : values) {
            if (null == value.getParentID() || value.getParentID() == 0L) {
                result.add(value);
            } else {
                parentNode = (SubjectDetailProVO)((Object)nodeMap.get(value.getParentID()));
                if (parentNode == null) {
                    emptyValueList.add(value);
                } else {
                    parentNode.getChildren().add(value);
                    sum = parentNode.getChildren().stream().filter(n -> n.getSurplusTaxMny() != null).map(SubjectDetailProVO::getSurplusTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    parentNode.setSurplusTaxMny(sum);
                }
            }
            nodeMap.put(value.getNodeID(), value);
        }
        if (!emptyValueList.isEmpty()) {
            for (SubjectDetailProVO value : emptyValueList) {
                parentNode = (SubjectDetailProVO)((Object)nodeMap.get(value.getParentID()));
                if (parentNode == null) {
                    result.add(value);
                    continue;
                }
                parentNode.getChildren().add(value);
                sum = parentNode.getChildren().stream().filter(n -> n.getSurplusTaxMny() != null).map(SubjectDetailProVO::getSurplusTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                parentNode.setSurplusTaxMny(sum);
            }
        }
        return result;
    }

    public static List<DynamicsCostVO> buildTreeDynamicsCost(List<DynamicsCostVO> values) {
        DynamicsCostVO parentNode;
        HashMap<Long, DynamicsCostVO> nodeMap = new HashMap<Long, DynamicsCostVO>();
        ArrayList<DynamicsCostVO> result = new ArrayList<DynamicsCostVO>();
        ArrayList<DynamicsCostVO> emptyValueList = new ArrayList<DynamicsCostVO>();
        for (DynamicsCostVO value : values) {
            if (null == value.getParentId() || value.getParentId() == 0L) {
                result.add(value);
            } else {
                parentNode = (DynamicsCostVO)((Object)nodeMap.get(value.getParentId()));
                if (parentNode == null) {
                    emptyValueList.add(value);
                } else {
                    parentNode.getChildren().add(value);
                }
            }
            nodeMap.put(value.getId(), value);
        }
        if (!emptyValueList.isEmpty()) {
            for (DynamicsCostVO value : emptyValueList) {
                parentNode = (DynamicsCostVO)((Object)nodeMap.get(value.getParentId()));
                if (parentNode == null) {
                    result.add(value);
                    continue;
                }
                parentNode.getChildren().add(value);
            }
        }
        return result;
    }
}

