/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.budget.bean.BudgetProjectDetailProEntity;
import com.ejianc.business.budget.bean.BudgetProjectProEntity;
import com.ejianc.business.budget.mapper.BudgetProjectDetailProMapper;
import com.ejianc.business.budget.service.IBudgetProjectDetailProService;
import com.ejianc.business.budget.service.IBudgetProjectProService;
import com.ejianc.business.budget.utils.ExcelImportUtil;
import com.ejianc.business.budget.vo.BudgetProjectDetailChangeProVO;
import com.ejianc.business.budget.vo.BudgetProjectDetailProVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialFuzzyMatchVO;
import com.ejianc.foundation.share.vo.MaterialPlusVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="budgetProjectDetailProService")
public class BudgetProjectDetailProServiceImpl
extends BaseServiceImpl<BudgetProjectDetailProMapper, BudgetProjectDetailProEntity>
implements IBudgetProjectDetailProService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IMaterialApi materialApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBudgetProjectProService budgetProjectProService;
    static Pattern LEVEL_PATTERN = Pattern.compile("\\.");

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            ArrayList<BudgetProjectDetailProVO> detailVoList = new ArrayList<BudgetProjectDetailProVO>();
            HashMap<String, String> tidMap = new HashMap<String, String>();
            for (int i = 0; i < result.size(); ++i) {
                String bodyMemo;
                String entryType;
                Object costType;
                List datas = (List)result.get(i);
                BudgetProjectDetailProVO vo = new BudgetProjectDetailProVO();
                boolean flag = false;
                boolean parentWarn = false;
                String warnType = "";
                String detailIndex = (String)datas.get(0);
                vo.setDetailIndex(detailIndex);
                String id = UUID.randomUUID().toString().replaceAll("-", "");
                if (StringUtils.isNotEmpty((CharSequence)detailIndex)) {
                    String[] split = detailIndex.split("[-/.]");
                    vo.setTid(id);
                    tidMap.put(detailIndex, id);
                    if (split.length > 1) {
                        vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                    }
                } else {
                    vo.setTid(id);
                    vo.setTpid("");
                }
                if (indexMap.containsKey(detailIndex)) {
                    return CommonResponse.error((String)("\u7b2c" + (i + 2) + "\u884c\u5e8f\u53f7\u548c\u7b2c" + ((Integer)indexMap.get(detailIndex) + 2) + "\u884c\u91cd\u590d"));
                }
                indexMap.put(detailIndex, i);
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(1)))) {
                    vo.setCode(null);
                    warnType = warnType + "\u7f16\u7801\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    vo.setCode((String)datas.get(1));
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(2)))) {
                    vo.setName(null);
                    warnType = warnType + "\u6e05\u5355\u540d\u79f0\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    String name = ((String)datas.get(2)).replace(" ", "");
                    vo.setName(name);
                }
                if (!StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(3)))) {
                    costType = (String)datas.get(3);
                    if (((String)costType).equals("/")) {
                        vo.setCostType(Integer.valueOf(0));
                    }
                    if (((String)costType).equals("\u4eba\u5de5\u8d39")) {
                        vo.setCostType(Integer.valueOf(1));
                    }
                    if (((String)costType).equals("\u6750\u6599\u8d39")) {
                        vo.setCostType(Integer.valueOf(2));
                        vo.setMaterialName(vo.getName());
                    }
                    if (((String)costType).equals("\u4e13\u4e1a\u5206\u5305\u8d39")) {
                        vo.setCostType(Integer.valueOf(3));
                    }
                    if (((String)costType).equals("\u673a\u68b0\u8d39")) {
                        vo.setCostType(Integer.valueOf(4));
                        vo.setMaterialName(vo.getName());
                    }
                    if (((String)costType).equals("\u95f4\u63a5\u8d39")) {
                        vo.setCostType(Integer.valueOf(5));
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(4)))) {
                    entryType = (String)datas.get(4);
                    if (entryType.equals("\u6863\u6848")) {
                        if (vo.getCostType() == 1 || vo.getCostType() == 3 || vo.getCostType() == 5) {
                            warnType = warnType + "\u6750\u6599\u7c7b\u578b\u4e3a\u6863\u6848\u65f6\uff0c\u8d39\u7528\u7c7b\u578b\u5fc5\u987b\u4e3a\u6750\u6599\u8d39\u6216\u673a\u68b0\u8d39!,";
                            flag = true;
                            parentWarn = true;
                        }
                        vo.setEntryType("1");
                    }
                    if (entryType.equals("\u624b\u52a8\u5f55\u5165")) {
                        vo.setEntryType("0");
                    }
                }
                if (vo.getCostType() != null && vo.getCostType() != null && (vo.getCostType() == 2 || vo.getCostType() == 4) && StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(5)))) {
                    entryType = (String)datas.get(4);
                    if ("\u6863\u6848".equals(entryType)) {
                        vo.setCategoryName(null);
                        warnType = warnType + "\u6750\u6599/\u8bbe\u5907\u7c7b\u578b\u4e3a\u7a7a,";
                        flag = true;
                        parentWarn = true;
                    }
                } else {
                    if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(5)))) {
                        String categoryName = ((String)datas.get(5)).replace(" ", "");
                        vo.setCategoryName(categoryName);
                    }
                    if ((costType = vo.getCostType()) != null && ((Integer)costType == 1 || (Integer)costType == 3 || (Integer)costType == 5)) {
                        vo.setCategoryName(null);
                    }
                }
                if (vo.getCostType() != null && (vo.getCostType() == 2 || vo.getCostType() == 4) && StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(6)))) {
                    entryType = (String)datas.get(4);
                    if ("\u6863\u6848".equals(entryType)) {
                        vo.setSpec(null);
                        warnType = warnType + "\u7279\u5f81\u63cf\u8ff0/\u89c4\u683c\u578b\u53f7,";
                        flag = true;
                        parentWarn = true;
                    }
                } else if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(6)))) {
                    String spec = ((String)datas.get(6)).replace(" ", "");
                    if (StringUtils.isNotEmpty((CharSequence)(spec = BudgetProjectDetailProServiceImpl.handleBlankString(spec, true))) && spec.length() > 2000) {
                        flag = true;
                        warnType = warnType + "\u7279\u5f81\u63cf\u8ff0/\u89c4\u683c\u578b\u53f7\u8d85\u8fc72000\u5b57,";
                    }
                    vo.setSpec(spec);
                }
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(7))) && StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(7)))) {
                    String unit = ((String)datas.get(7)).replace(" ", "");
                    unit = BudgetProjectDetailProServiceImpl.handleBlankString(unit, true);
                    vo.setUnit(unit);
                }
                if (datas.size() > 12 && StringUtils.isNotEmpty((CharSequence)(bodyMemo = (String)datas.get(12)))) {
                    vo.setBodyMemo(bodyMemo);
                    if (bodyMemo.length() > 1000) {
                        flag = true;
                        warnType = warnType + "\u5907\u6ce8\u8d85\u8fc71000\u5b57,";
                    }
                }
                if (vo.getCostType() != null && !vo.getCostType().equals(0)) {
                    if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(8)))) {
                        vo.setNum(null);
                        warnType = warnType + "\u5de5\u7a0b\u91cf\u4e3a\u7a7a,";
                        flag = true;
                    } else {
                        try {
                            vo.setNum(ComputeUtil.toBigDecimal((String)ComputeUtil.scaleStripTrailingZeros((BigDecimal)new BigDecimal((String)datas.get(8)), (int)8)));
                        }
                        catch (Exception e) {
                            vo.setNum(null);
                            warnType = warnType + "\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                            flag = true;
                        }
                    }
                    if (!StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(9)))) {
                        try {
                            vo.setTaxPrice(ComputeUtil.toBigDecimal((String)ComputeUtil.scaleStripTrailingZeros((BigDecimal)new BigDecimal((String)datas.get(9)), (int)8)));
                        }
                        catch (Exception e) {
                            vo.setTaxPrice(null);
                            warnType = warnType + "\u7efc\u5408\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                            flag = true;
                        }
                    }
                    if (!StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(10)))) {
                        try {
                            vo.setPrice(ComputeUtil.toBigDecimal((String)ComputeUtil.scaleStripTrailingZeros((BigDecimal)new BigDecimal((String)datas.get(10)), (int)8)));
                        }
                        catch (Exception e) {
                            vo.setPrice(null);
                            warnType = warnType + "\u7efc\u5408\u5355\u4ef7(\u65e0\u7a0e)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                            flag = true;
                        }
                    }
                    if (!StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(11)))) {
                        try {
                            vo.setRate(ComputeUtil.toBigDecimal((String)ComputeUtil.scaleStripTrailingZeros((BigDecimal)new BigDecimal((String)datas.get(11)), (int)8)));
                        }
                        catch (Exception e) {
                            vo.setRate(null);
                            warnType = warnType + "\u7a0e\u7387\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                            flag = true;
                        }
                    }
                    if (null == vo.getTaxPrice()) {
                        if (null != vo.getPrice()) {
                            if (null == vo.getRate()) {
                                vo.setTaxPrice(vo.getPrice());
                            } else {
                                BigDecimal add = ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeDiv((BigDecimal)vo.getRate(), (BigDecimal)new BigDecimal(100)), (BigDecimal)new BigDecimal(1));
                                vo.setTaxPrice(vo.getPrice().multiply(add).setScale(8, 4));
                            }
                        }
                    } else if (null == vo.getPrice()) {
                        if (null == vo.getRate()) {
                            vo.setPrice(vo.getTaxPrice());
                        } else {
                            BigDecimal price = ComputeUtil.safeDiv((BigDecimal)vo.getTaxPrice(), (BigDecimal)ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeDiv((BigDecimal)vo.getRate(), (BigDecimal)new BigDecimal(100)), (BigDecimal)new BigDecimal(1)));
                            vo.setPrice(ComputeUtil.toBigDecimal((String)ComputeUtil.scaleStripTrailingZeros((BigDecimal)price, (int)8)));
                        }
                    }
                }
                if (null != vo.getNum() && null != vo.getTaxPrice()) {
                    BigDecimal taxMny = ComputeUtil.safeMultiply((BigDecimal)vo.getNum(), (BigDecimal)vo.getTaxPrice()).setScale(2, 4);
                    BigDecimal mny = null;
                    vo.setTaxMny(taxMny);
                    if (vo.getRate() != null) {
                        mny = ComputeUtil.safeMultiply((BigDecimal)vo.getNum(), (BigDecimal)vo.getPrice());
                        vo.setMny(mny.setScale(2, 4));
                    } else {
                        vo.setTaxMny(taxMny);
                        vo.setMny(taxMny);
                    }
                    if (vo.getCostType() != null) {
                        if (vo.getCostType() == 1) {
                            vo.setLaborTaxMnyCost(vo.getTaxMny());
                            vo.setLaborMnyCost(vo.getMny());
                        }
                        if (vo.getCostType() == 2) {
                            vo.setMaterialMnyCost(vo.getMny());
                            vo.setMaterialTaxMnyCost(vo.getTaxMny());
                        }
                        if (vo.getCostType() == 3) {
                            vo.setMajorTaxMnyCost(vo.getTaxMny());
                            vo.setMajorMnyCost(vo.getMny());
                        }
                        if (vo.getCostType() == 4) {
                            vo.setMechanicalTaxMnyCost(vo.getTaxMny());
                            vo.setMechanicalMnyCost(vo.getMny());
                        }
                        if (vo.getCostType() == 5) {
                            vo.setIndirectionTaxMnyCost(vo.getTaxMny());
                            vo.setIndirectionMnyCost(vo.getMny());
                        }
                    }
                }
                vo.setImportFlag(Boolean.valueOf(!flag));
                vo.setParentWarn(Boolean.valueOf(parentWarn));
                if (flag) {
                    warnType = warnType.substring(0, warnType.length() - 1);
                }
                vo.setWarnType(warnType);
                vo.setRowState("add");
                vo.setArchiveFlag("2");
                vo.setShadowId(vo.getTid());
                String key = vo.getName() + vo.getCostType() + vo.getCategoryName() + vo.getSpec() + vo.getUnit();
                vo.setKey(key);
                detailVoList.add(vo);
            }
            for (BudgetProjectDetailProVO tVo : detailVoList) {
                tVo.setTpid((String)tidMap.get(tVo.getTpid()));
            }
            List deailTreeData = ExcelImportUtil.treeData((List)BeanMapper.mapList(detailVoList, Map.class));
            List mapList = ExcelImportUtil.importFlag2((List)deailTreeData);
            ArrayList falseList = new ArrayList();
            List allList = ExcelImportUtil.separate((List)mapList, falseList);
            List oldErrList = (List)allList.get(1);
            List<Map<String, Object>> successListMap = (List<Map<String, Object>>)allList.get(0);
            MaterialFuzzyMatchVO materialFuzzyMatchVO = new MaterialFuzzyMatchVO();
            HashMap<String, Boolean> materialHashMap = new HashMap<String, Boolean>();
            HashMap<String, Boolean> equipmentCategoryMap = new HashMap<String, Boolean>();
            materialFuzzyMatchVO = this.checkCategoryName(successListMap, materialFuzzyMatchVO, materialHashMap, equipmentCategoryMap);
            this.logger.info("\u7269\u8d44\u8bbe\u5907\u5206\u7c7b\u662f\u5426\u5b58\u5728:" + JSONObject.toJSONString((Object)materialFuzzyMatchVO));
            Map materialCategoryMap = null;
            Map equipmentCategoryProMap = null;
            CommonResponse materialFuzzyMatchVOCommonResponse = this.materialApi.checkArchive(materialFuzzyMatchVO);
            if (materialFuzzyMatchVOCommonResponse.isSuccess()) {
                MaterialFuzzyMatchVO data = (MaterialFuzzyMatchVO)materialFuzzyMatchVOCommonResponse.getData();
                materialCategoryMap = data.getMaterialCategoryMap();
                equipmentCategoryProMap = data.getEquipmentCategoryMap();
                List newList = ExcelImportUtil.importCheckCategoryName((List)successListMap, (Map)materialCategoryMap, (Map)equipmentCategoryProMap);
                ArrayList newfalseList = new ArrayList();
                List newAllList = ExcelImportUtil.separate((List)newList, newfalseList);
                successListMap = (List)newAllList.get(0);
                oldErrList.addAll((Collection)newAllList.get(1));
            }
            List errorList = ExcelImportUtil.treeToList((List)oldErrList);
            MaterialFuzzyMatchVO materialNumberFuzzyMatchVO = new MaterialFuzzyMatchVO();
            HashMap<String, MaterialPlusVO> fuzzyMatchMap = new HashMap<String, MaterialPlusVO>();
            materialNumberFuzzyMatchVO = this.queryNumberFuzzy(successListMap, materialNumberFuzzyMatchVO, fuzzyMatchMap);
            this.logger.info("\u7269\u8d44\u8bbe\u5907\u6a21\u7cca\u6570\u91cf:" + JSONObject.toJSONString((Object)materialNumberFuzzyMatchVO));
            CommonResponse materialFuzzyMatchVOCommonResponse1 = this.materialApi.fuzzyMatchNumber(materialNumberFuzzyMatchVO);
            Map materialPlusMapVO = null;
            if (materialFuzzyMatchVOCommonResponse1.isSuccess()) {
                MaterialFuzzyMatchVO data = (MaterialFuzzyMatchVO)materialFuzzyMatchVOCommonResponse1.getData();
                materialPlusMapVO = data.getFuzzyMatchMap();
                successListMap = this.setFuzzyMatch(successListMap, materialPlusMapVO);
            } else {
                this.logger.info("\u7269\u8d44\u8bbe\u5907\u6a21\u67e5\u8be2:" + materialFuzzyMatchVOCommonResponse1.isSuccess());
            }
            resp.put("successList", successListMap);
            resp.put("errorList", (Object)errorList);
            resp.put("successNum", (Object)(result.size() - errorList.size()));
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    @Override
    public CommonResponse<JSONObject> excelImportForChange(HttpServletRequest request, HttpServletResponse response) {
        Long budgetId = Long.valueOf(request.getParameter("budgetId"));
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            ArrayList<BudgetProjectDetailProVO> detailVoList = new ArrayList<BudgetProjectDetailProVO>();
            HashMap<String, String> tidMap = new HashMap<String, String>();
            for (int i = 0; i < result.size(); ++i) {
                String bodyMemo;
                String entryType;
                Object costType;
                List datas = (List)result.get(i);
                BudgetProjectDetailProVO vo = new BudgetProjectDetailProVO();
                boolean flag = false;
                boolean parentWarn = false;
                String warnType = "";
                String detailIndex = (String)datas.get(0);
                vo.setDetailIndex(detailIndex);
                String id = UUID.randomUUID().toString().replaceAll("-", "");
                if (StringUtils.isNotEmpty((CharSequence)detailIndex)) {
                    String[] split = detailIndex.split("[-/.]");
                    vo.setTid(id);
                    tidMap.put(detailIndex, id);
                    if (split.length > 1) {
                        vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                    }
                } else {
                    vo.setTid(id);
                    vo.setTpid("");
                }
                if (indexMap.containsKey(detailIndex)) {
                    return CommonResponse.error((String)("\u7b2c" + (i + 2) + "\u884c\u5e8f\u53f7\u548c\u7b2c" + ((Integer)indexMap.get(detailIndex) + 2) + "\u884c\u91cd\u590d"));
                }
                indexMap.put(detailIndex, i);
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(1)))) {
                    vo.setCode(null);
                    warnType = warnType + "\u7f16\u7801\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    vo.setCode((String)datas.get(1));
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(2)))) {
                    vo.setName(null);
                    warnType = warnType + "\u6e05\u5355\u540d\u79f0\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    String name = ((String)datas.get(2)).replace(" ", "");
                    vo.setName(name);
                }
                if (!StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(3)))) {
                    costType = (String)datas.get(3);
                    if (((String)costType).equals("/")) {
                        vo.setCostType(Integer.valueOf(0));
                    }
                    if (((String)costType).equals("\u4eba\u5de5\u8d39")) {
                        vo.setCostType(Integer.valueOf(1));
                    }
                    if (((String)costType).equals("\u6750\u6599\u8d39")) {
                        vo.setCostType(Integer.valueOf(2));
                        vo.setMaterialName(vo.getName());
                    }
                    if (((String)costType).equals("\u4e13\u4e1a\u5206\u5305\u8d39")) {
                        vo.setCostType(Integer.valueOf(3));
                    }
                    if (((String)costType).equals("\u673a\u68b0\u8d39")) {
                        vo.setCostType(Integer.valueOf(4));
                        vo.setMaterialName(vo.getName());
                    }
                    if (((String)costType).equals("\u95f4\u63a5\u8d39")) {
                        vo.setCostType(Integer.valueOf(5));
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(4)))) {
                    entryType = (String)datas.get(4);
                    if (entryType.equals("\u6863\u6848")) {
                        if (vo.getCostType() == 1 || vo.getCostType() == 3 || vo.getCostType() == 5) {
                            warnType = warnType + "\u6750\u6599\u7c7b\u578b\u4e3a\u6863\u6848\u65f6\uff0c\u8d39\u7528\u7c7b\u578b\u5fc5\u987b\u4e3a\u6750\u6599\u8d39\u6216\u673a\u68b0\u8d39!,";
                            flag = true;
                            parentWarn = true;
                        }
                        vo.setEntryType("1");
                    }
                    if (entryType.equals("\u624b\u52a8\u5f55\u5165")) {
                        vo.setEntryType("0");
                    }
                }
                if (vo.getCostType() != null && vo.getCostType() != null && (vo.getCostType() == 2 || vo.getCostType() == 4) && StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(5)))) {
                    entryType = (String)datas.get(4);
                    if ("\u6863\u6848".equals(entryType)) {
                        vo.setCategoryName(null);
                        warnType = warnType + "\u6750\u6599/\u8bbe\u5907\u7c7b\u578b\u4e3a\u7a7a,";
                        flag = true;
                        parentWarn = true;
                    }
                } else {
                    if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(5)))) {
                        String categoryName = ((String)datas.get(5)).replace(" ", "");
                        vo.setCategoryName(categoryName);
                    }
                    if ((costType = vo.getCostType()) != null && ((Integer)costType == 1 || (Integer)costType == 3 || (Integer)costType == 5)) {
                        vo.setCategoryName(null);
                    }
                }
                if (vo.getCostType() != null && (vo.getCostType() == 2 || vo.getCostType() == 4) && StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(6)))) {
                    entryType = (String)datas.get(4);
                    if ("\u6863\u6848".equals(entryType)) {
                        vo.setSpec(null);
                        warnType = warnType + "\u7279\u5f81\u63cf\u8ff0/\u89c4\u683c\u578b\u53f7,";
                        flag = true;
                        parentWarn = true;
                    }
                } else if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(6)))) {
                    String spec = ((String)datas.get(6)).replace(" ", "");
                    if (StringUtils.isNotEmpty((CharSequence)(spec = BudgetProjectDetailProServiceImpl.handleBlankString(spec, true))) && spec.length() > 2000) {
                        flag = true;
                        warnType = warnType + "\u7279\u5f81\u63cf\u8ff0/\u89c4\u683c\u578b\u53f7\u8d85\u8fc72000\u5b57,";
                    }
                    vo.setSpec(spec);
                }
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(7))) && StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(7)))) {
                    String unit = ((String)datas.get(7)).replace(" ", "");
                    unit = BudgetProjectDetailProServiceImpl.handleBlankString(unit, true);
                    vo.setUnit(unit);
                }
                if (datas.size() > 12 && StringUtils.isNotEmpty((CharSequence)(bodyMemo = (String)datas.get(12)))) {
                    vo.setBodyMemo(bodyMemo);
                    if (bodyMemo.length() > 1000) {
                        flag = true;
                        warnType = warnType + "\u5907\u6ce8\u8d85\u8fc71000\u5b57,";
                    }
                }
                if (vo.getCostType() != null && !vo.getCostType().equals(0)) {
                    if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(8)))) {
                        vo.setNum(null);
                        warnType = warnType + "\u5de5\u7a0b\u91cf\u4e3a\u7a7a,";
                        flag = true;
                    } else {
                        try {
                            vo.setNum(ComputeUtil.toBigDecimal((String)ComputeUtil.scaleStripTrailingZeros((BigDecimal)new BigDecimal((String)datas.get(8)), (int)8)));
                        }
                        catch (Exception e) {
                            vo.setNum(null);
                            warnType = warnType + "\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(9)))) {
                        try {
                            vo.setTaxPrice(ComputeUtil.toBigDecimal((String)ComputeUtil.scaleStripTrailingZeros((BigDecimal)new BigDecimal((String)datas.get(9)), (int)8)));
                        }
                        catch (Exception e) {
                            vo.setTaxPrice(null);
                            warnType = warnType + "\u7efc\u5408\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(10)))) {
                        try {
                            vo.setPrice(ComputeUtil.toBigDecimal((String)ComputeUtil.scaleStripTrailingZeros((BigDecimal)new BigDecimal((String)datas.get(10)), (int)8)));
                        }
                        catch (Exception e) {
                            vo.setPrice(null);
                            warnType = warnType + "\u7efc\u5408\u5355\u4ef7(\u65e0\u7a0e)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(11)))) {
                        try {
                            vo.setRate(ComputeUtil.toBigDecimal((String)ComputeUtil.scaleStripTrailingZeros((BigDecimal)new BigDecimal((String)datas.get(11)), (int)8)));
                        }
                        catch (Exception e) {
                            vo.setRate(null);
                            warnType = warnType + "\u7a0e\u7387\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                            flag = true;
                        }
                    }
                    if (null == vo.getTaxPrice()) {
                        if (null != vo.getPrice()) {
                            if (null == vo.getRate()) {
                                vo.setTaxPrice(ComputeUtil.toBigDecimal((String)ComputeUtil.scaleStripTrailingZeros((BigDecimal)vo.getPrice(), (int)8)));
                            } else {
                                BigDecimal add = ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeDiv((BigDecimal)vo.getRate(), (BigDecimal)new BigDecimal(100)), (BigDecimal)new BigDecimal(1));
                                vo.setTaxPrice(ComputeUtil.toBigDecimal((String)ComputeUtil.scaleStripTrailingZeros((BigDecimal)vo.getPrice().multiply(add), (int)8)));
                            }
                        }
                    } else if (null == vo.getPrice()) {
                        if (null == vo.getRate()) {
                            vo.setPrice(ComputeUtil.toBigDecimal((String)ComputeUtil.scaleStripTrailingZeros((BigDecimal)vo.getTaxPrice(), (int)8)));
                        } else {
                            BigDecimal price = ComputeUtil.safeDiv((BigDecimal)vo.getTaxPrice(), (BigDecimal)ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeDiv((BigDecimal)vo.getRate(), (BigDecimal)new BigDecimal(100)), (BigDecimal)new BigDecimal(1)));
                            vo.setPrice(ComputeUtil.toBigDecimal((String)ComputeUtil.scaleStripTrailingZeros((BigDecimal)price, (int)8)));
                        }
                    }
                }
                if (null != vo.getNum() && null != vo.getTaxPrice()) {
                    BigDecimal taxMny = ComputeUtil.safeMultiply((BigDecimal)vo.getNum(), (BigDecimal)vo.getTaxPrice()).setScale(2, 4);
                    BigDecimal mny = null;
                    vo.setTaxMny(taxMny);
                    if (vo.getRate() != null) {
                        mny = ComputeUtil.safeMultiply((BigDecimal)vo.getNum(), (BigDecimal)vo.getPrice());
                        vo.setMny(mny.setScale(2, 4));
                    } else {
                        vo.setTaxMny(taxMny);
                        vo.setMny(taxMny);
                    }
                    if (vo.getCostType() != null) {
                        if (vo.getCostType() == 1) {
                            vo.setLaborTaxMnyCost(vo.getTaxMny());
                            vo.setLaborMnyCost(vo.getMny());
                        }
                        if (vo.getCostType() == 2) {
                            vo.setMaterialMnyCost(vo.getMny());
                            vo.setMaterialTaxMnyCost(vo.getTaxMny());
                        }
                        if (vo.getCostType() == 3) {
                            vo.setMajorTaxMnyCost(vo.getTaxMny());
                            vo.setMajorMnyCost(vo.getMny());
                        }
                        if (vo.getCostType() == 4) {
                            vo.setMechanicalTaxMnyCost(vo.getTaxMny());
                            vo.setMechanicalMnyCost(vo.getMny());
                        }
                        if (vo.getCostType() == 5) {
                            vo.setIndirectionTaxMnyCost(vo.getTaxMny());
                            vo.setIndirectionMnyCost(vo.getMny());
                        }
                    }
                }
                vo.setImportFlag(Boolean.valueOf(!flag));
                vo.setParentWarn(Boolean.valueOf(parentWarn));
                if (flag) {
                    warnType = warnType.substring(0, warnType.length() - 1);
                }
                vo.setWarnType(warnType);
                vo.setRowState("add");
                vo.setArchiveFlag("2");
                vo.setShadowId(vo.getTid());
                String key = vo.getName() + vo.getCostType() + vo.getCategoryName() + vo.getSpec() + vo.getUnit();
                vo.setKey(key);
                detailVoList.add(vo);
            }
            for (BudgetProjectDetailProVO tVo : detailVoList) {
                tVo.setTpid((String)tidMap.get(tVo.getTpid()));
            }
            List deailTreeData = ExcelImportUtil.treeData((List)BeanMapper.mapList(detailVoList, Map.class));
            List mapList = ExcelImportUtil.importFlag2((List)deailTreeData);
            ArrayList falseList = new ArrayList();
            List allList = ExcelImportUtil.separate((List)mapList, falseList);
            List oldErrList = (List)allList.get(1);
            List successListMap = (List)allList.get(0);
            MaterialFuzzyMatchVO materialFuzzyMatchVO = new MaterialFuzzyMatchVO();
            HashMap<String, Boolean> materialHashMap = new HashMap<String, Boolean>();
            HashMap<String, Boolean> equipmentCategoryMap = new HashMap<String, Boolean>();
            materialFuzzyMatchVO = this.checkCategoryName(successListMap, materialFuzzyMatchVO, materialHashMap, equipmentCategoryMap);
            this.logger.info("\u7269\u8d44\u8bbe\u5907\u5206\u7c7b\u662f\u5426\u5b58\u5728:" + JSONObject.toJSONString((Object)materialFuzzyMatchVO));
            Map materialCategoryMap = null;
            Map equipmentCategoryProMap = null;
            CommonResponse materialFuzzyMatchVOCommonResponse = this.materialApi.checkArchive(materialFuzzyMatchVO);
            if (materialFuzzyMatchVOCommonResponse.isSuccess()) {
                MaterialFuzzyMatchVO data = (MaterialFuzzyMatchVO)materialFuzzyMatchVOCommonResponse.getData();
                materialCategoryMap = data.getMaterialCategoryMap();
                equipmentCategoryProMap = data.getEquipmentCategoryMap();
                List newList = ExcelImportUtil.importCheckCategoryName((List)successListMap, (Map)materialCategoryMap, (Map)equipmentCategoryProMap);
                ArrayList newfalseList = new ArrayList();
                List newAllList = ExcelImportUtil.separate((List)newList, newfalseList);
                successListMap = (List)newAllList.get(0);
                oldErrList.addAll((Collection)newAllList.get(1));
            }
            List errorList = ExcelImportUtil.treeToList((List)oldErrList);
            BudgetProjectProEntity budgetProjectProEntity = (BudgetProjectProEntity)((Object)this.budgetProjectProService.selectById(budgetId));
            List detailList = BeanMapper.mapList(budgetProjectProEntity.getDetailList(), BudgetProjectDetailChangeProVO.class);
            LinkedList<BudgetProjectDetailChangeProVO> failedErrors = new LinkedList<BudgetProjectDetailChangeProVO>();
            HashMap detailCodeMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)detailList)) {
                for (BudgetProjectDetailChangeProVO tVo : detailList) {
                    tVo.setTid(tVo.getId().toString());
                    tVo.setTpid(tVo.getParentId() != null ? tVo.getParentId().toString() : null);
                }
                List detailListMap = BeanMapper.mapList((Iterable)detailList, Map.class);
                List maps = ExcelImportUtil.treeData((List)detailListMap);
                HashMap detailCodeCount = new HashMap();
                ExcelImportUtil.getCompareCodeMapByTree((List)maps, detailCodeMap, null, detailCodeCount);
            }
            MaterialFuzzyMatchVO materialNumberFuzzyMatchVO = new MaterialFuzzyMatchVO();
            HashMap<String, MaterialPlusVO> fuzzyMatchMap = new HashMap<String, MaterialPlusVO>();
            materialNumberFuzzyMatchVO = this.queryNumberFuzzy(successListMap, materialNumberFuzzyMatchVO, fuzzyMatchMap);
            this.logger.info("\u7269\u8d44\u8bbe\u5907\u6a21\u7cca\u6570\u91cf:" + JSONObject.toJSONString((Object)materialNumberFuzzyMatchVO));
            CommonResponse materialFuzzyMatchVOCommonResponse1 = this.materialApi.fuzzyMatchNumber(materialNumberFuzzyMatchVO);
            Map materialPlusMapVO = null;
            if (materialFuzzyMatchVOCommonResponse1.isSuccess()) {
                MaterialFuzzyMatchVO data = (MaterialFuzzyMatchVO)materialFuzzyMatchVOCommonResponse1.getData();
                materialPlusMapVO = data.getFuzzyMatchMap();
                successListMap = this.setFuzzyMatch(successListMap, materialPlusMapVO);
            } else {
                this.logger.info("\u7269\u8d44\u8bbe\u5907\u6a21\u67e5\u8be2:" + materialFuzzyMatchVOCommonResponse1.isSuccess());
            }
            if (CollectionUtils.isNotEmpty((Collection)detailList)) {
                LinkedHashMap importCompareCodeEntityMap = new LinkedHashMap();
                HashMap importCodeCount = new HashMap();
                ExcelImportUtil.getCompareCodeVOMapAndFlatData(successListMap, importCompareCodeEntityMap, null, new ArrayList(detailCodeMap.values()), importCodeCount);
                for (BudgetProjectDetailChangeProVO cdEntity : detailList) {
                    String changeCompareCode = (String)detailCodeMap.get(cdEntity.getId().toString());
                    Map importCompareCodeEntity = (Map)importCompareCodeEntityMap.get(changeCompareCode);
                    if (importCompareCodeEntity != null) {
                        CommonResponse res;
                        boolean leafFlag = Boolean.parseBoolean(String.valueOf(importCompareCodeEntity.get("leafFlag")));
                        if (leafFlag != cdEntity.getLeafFlag() && !(res = this.billTypeApi.checkQuote("BT202210000001", cdEntity.getId())).isSuccess()) {
                            cdEntity.setWarnType("\u6e05\u5355\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u6216\u8005\u8c03\u6574\u7ea7\u6b21");
                            failedErrors.add(cdEntity);
                        }
                        importCompareCodeEntity.put("budgetDetailId", cdEntity.getId());
                        importCompareCodeEntity.put("budgetId", budgetId);
                        continue;
                    }
                    CommonResponse res = this.billTypeApi.checkQuote("BT202210000001", cdEntity.getId());
                    if (res.isSuccess()) continue;
                    cdEntity.setWarnType("\u6e05\u5355\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u6216\u8005\u8c03\u6574\u7ea7\u6b21!");
                    failedErrors.add(cdEntity);
                }
                successListMap = ExcelImportUtil.treeData(new ArrayList(importCompareCodeEntityMap.values()));
                resp.put("detailCodeMap", detailCodeMap);
                resp.put("importCompareCodeEntityMap", importCompareCodeEntityMap);
            }
            resp.put("successList", successListMap);
            resp.put("errorList", (Object)errorList);
            resp.put("failedErrors", failedErrors);
            resp.put("successNum", (Object)(result.size() - errorList.size()));
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    public static int getLevel(String content) {
        Matcher matcher = LEVEL_PATTERN.matcher(content);
        int count = 1;
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    public MaterialFuzzyMatchVO checkCategoryName(List<Map<String, Object>> successListMap, MaterialFuzzyMatchVO materialFuzzyMatchVO, HashMap<String, Boolean> materialHashMap, HashMap<String, Boolean> equipmentCategoryMap) {
        if (CollectionUtils.isNotEmpty(successListMap)) {
            for (Map<String, Object> stringObjectMap : successListMap) {
                String entryType;
                if (stringObjectMap.get("children") != null) {
                    List list = (List)stringObjectMap.get("children");
                    this.checkCategoryName(list, materialFuzzyMatchVO, materialHashMap, equipmentCategoryMap);
                    continue;
                }
                Integer costType = stringObjectMap.get("costType") != null ? (Integer)stringObjectMap.get("costType") : null;
                String categoryName = (String)stringObjectMap.get("categoryName");
                String string = entryType = stringObjectMap.get("entryType") != null ? (String)stringObjectMap.get("entryType") : null;
                if (costType != null && costType == 2 && entryType != null && entryType.equals("1")) {
                    materialHashMap.put(categoryName, false);
                    continue;
                }
                if (costType == null || costType != 4 || entryType == null || !entryType.equals("1")) continue;
                equipmentCategoryMap.put(categoryName, false);
            }
            materialFuzzyMatchVO.setMaterialCategoryMap(materialHashMap);
            materialFuzzyMatchVO.setEquipmentCategoryMap(equipmentCategoryMap);
        }
        return materialFuzzyMatchVO;
    }

    public MaterialFuzzyMatchVO queryNumberFuzzy(List<Map<String, Object>> successListMap, MaterialFuzzyMatchVO materialNumberFuzzyMatchVO, HashMap<String, MaterialPlusVO> fuzzyMatchMap) {
        if (CollectionUtils.isNotEmpty(successListMap)) {
            for (Map<String, Object> stringObjectMap : successListMap) {
                String unit;
                String name;
                String spec;
                MaterialPlusVO materialPlusVO;
                String entryType;
                if (stringObjectMap.get("children") != null) {
                    List list = (List)stringObjectMap.get("children");
                    this.queryNumberFuzzy(list, materialNumberFuzzyMatchVO, fuzzyMatchMap);
                    continue;
                }
                Integer costType = stringObjectMap.get("costType") != null ? (Integer)stringObjectMap.get("costType") : null;
                String categoryName = (String)stringObjectMap.get("categoryName");
                String string = entryType = stringObjectMap.get("entryType") != null ? (String)stringObjectMap.get("entryType") : null;
                if (costType != null && costType == 2 && entryType != null && entryType.equals("1")) {
                    materialNumberFuzzyMatchVO.setType(Integer.valueOf(1));
                    materialPlusVO = new MaterialPlusVO();
                    materialPlusVO.setType(Integer.valueOf(1));
                    materialPlusVO.setCategoryName(categoryName);
                    spec = (String)stringObjectMap.get("spec");
                    materialPlusVO.setSpec(spec);
                    name = (String)stringObjectMap.get("name");
                    materialPlusVO.setName(name);
                    unit = (String)stringObjectMap.get("unit");
                    materialPlusVO.setCategoryName(categoryName);
                    materialPlusVO.setUnitName(unit);
                    fuzzyMatchMap.put(stringObjectMap.get("key").toString(), materialPlusVO);
                    continue;
                }
                if (costType == null || costType != 4 || entryType == null || !entryType.equals("1")) continue;
                materialPlusVO = new MaterialPlusVO();
                materialPlusVO.setType(Integer.valueOf(2));
                materialPlusVO.setCategoryName(categoryName);
                spec = (String)stringObjectMap.get("spec");
                materialPlusVO.setSpec(spec);
                name = (String)stringObjectMap.get("name");
                materialPlusVO.setName(name);
                materialPlusVO.setCategoryName(categoryName);
                unit = (String)stringObjectMap.get("unit");
                materialPlusVO.setUnitName(unit);
                fuzzyMatchMap.put(stringObjectMap.get("key").toString(), materialPlusVO);
            }
            materialNumberFuzzyMatchVO.setFuzzyMatchMap(fuzzyMatchMap);
        }
        return materialNumberFuzzyMatchVO;
    }

    public List<Map<String, Object>> setFuzzyMatch(List<Map<String, Object>> successListMap, Map<String, MaterialPlusVO> materialPlusMapVO) {
        if (CollectionUtils.isNotEmpty(successListMap)) {
            for (Map<String, Object> stringObjectMap : successListMap) {
                MaterialPlusVO materialPlusVO;
                if (stringObjectMap.get("children") != null) {
                    List list = (List)stringObjectMap.get("children");
                    this.setFuzzyMatch(list, materialPlusMapVO);
                    continue;
                }
                Integer costType = stringObjectMap.get("costType") != null ? (Integer)stringObjectMap.get("costType") : null;
                String key = (String)stringObjectMap.get("key");
                if (materialPlusMapVO == null || (materialPlusVO = materialPlusMapVO.get(key)) == null) continue;
                Integer matchStatus = materialPlusVO.getMatchStatus();
                Integer type = materialPlusVO.getType();
                if (matchStatus != null && matchStatus == 1) {
                    stringObjectMap.put("categoryId", materialPlusVO.getCategoryId());
                    stringObjectMap.put("categoryName", materialPlusVO.getCategoryName());
                    stringObjectMap.put("materialId", materialPlusVO.getId());
                    stringObjectMap.put("materialName", materialPlusVO.getName());
                    stringObjectMap.put("spec", materialPlusVO.getSpec());
                    stringObjectMap.put("unit", materialPlusVO.getUnitName());
                    stringObjectMap.put("materialCode", materialPlusVO.getCode());
                }
                Integer matchNumber = materialPlusVO.getMatchNumber();
                String matchStatusDescription = materialPlusVO.getMatchStatusDescription();
                stringObjectMap.put("matchStatus", matchStatus);
                stringObjectMap.put("matchNumber", matchNumber);
                stringObjectMap.put("matchStatusDescription", matchStatusDescription);
            }
        }
        return successListMap;
    }

    private static String handleBlankString(String str, boolean flag) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        if (flag) {
            return str.trim();
        }
        return str.replaceAll("\\s*", "");
    }
}

