/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.BudgetProjectProEntity;
import com.ejianc.business.budget.mapper.BudgetProjectDetailProMapper;
import com.ejianc.business.budget.mapper.BudgetProjectProMapper;
import com.ejianc.business.budget.service.IBudgetProjectDetailProService;
import com.ejianc.business.budget.service.IBudgetProjectProService;
import com.ejianc.business.budget.vo.BudgetProjectDetailProVO;
import com.ejianc.business.budget.vo.BudgetProjectDetailReferenProVO;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityVO;
import com.ejianc.business.budget.vo.BudgetProjectProVO;
import com.ejianc.business.budget.vo.comparator.BudgetDetailProComparatoeVo;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="budgetProjectProService")
public class BudgetProjectProServiceImpl
extends BaseServiceImpl<BudgetProjectProMapper, BudgetProjectProEntity>
implements IBudgetProjectProService {
    @Autowired
    private BudgetProjectProMapper budgetProjectProMapper;
    @Autowired
    private IBudgetProjectDetailProService budgetProjectDetailProService;
    @Autowired
    private BudgetProjectDetailProMapper budgetProjectDetailProMapper;
    @Autowired
    private IBudgetProjectProService budgetProService;

    @Override
    public BudgetProjectProVO queryDetail(Long id) {
        BudgetProjectProEntity entity = (BudgetProjectProEntity)((Object)this.budgetProjectProMapper.selectById(id));
        if (entity != null) {
            BudgetProjectProVO vo = (BudgetProjectProVO)BeanMapper.map((Object)((Object)entity), BudgetProjectProVO.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("budget_id", new Parameter("eq", (Object)vo.getId()));
            List detailProEntityList = this.budgetProjectDetailProService.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty((Collection)detailProEntityList)) {
                List resultMapList = BeanMapper.mapList((Iterable)detailProEntityList, BudgetProjectDetailProVO.class);
                for (BudgetProjectDetailProVO cdEntity : resultMapList) {
                    cdEntity.setTid(cdEntity.getId().toString());
                    cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                    cdEntity.setRowState("edit");
                }
                Collections.sort(resultMapList, new BudgetDetailProComparatoeVo());
                vo.setDetailList(TreeNodeBUtil.buildTree((List)resultMapList));
            }
            return vo;
        }
        return null;
    }

    @Override
    public List<BudgetProjectDetailReferenProVO> queryDetailList(Page<BudgetProjectDetailReferenProVO> page, QueryWrapper wrapper, Long projectId, String costType) {
        return this.budgetProjectProMapper.queryDetailList(page, wrapper, projectId, costType);
    }

    @Override
    public List<BudgetProjectDetailReferenProVO> queryOtherDetailList(Page<BudgetProjectDetailReferenProVO> page, QueryWrapper wrapper, Long projectId, String costType) {
        return this.budgetProjectProMapper.queryOtherDetailList(page, wrapper, projectId, costType);
    }

    @Override
    public BudgetProjectProQuantityAndMnyVO fetchQuantityAndMny(BudgetProjectProParamControlVO paramControlVO) {
        if (paramControlVO.getProjectId() == null) {
            return null;
        }
        BudgetProjectProQuantityAndMnyVO quantityAndMnyVO = new BudgetProjectProQuantityAndMnyVO();
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(BudgetProjectProEntity::getProjectId, (Object)paramControlVO.getProjectId());
        lambdaQuery.in(BudgetProjectProEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        BudgetProjectProEntity entity = (BudgetProjectProEntity)((Object)super.getOne((Wrapper)lambdaQuery));
        if (entity == null) {
            return null;
        }
        quantityAndMnyVO.setBudgetTaxMny(entity.getBudgetTaxMny());
        quantityAndMnyVO.setBudgetMny(entity.getBudgetMny());
        quantityAndMnyVO.setIndirectionTaxMny(entity.getIndirectionTaxMny());
        quantityAndMnyVO.setIndirectionMny(entity.getIndirectionMny());
        quantityAndMnyVO.setLaborTaxMny(entity.getLaborTaxMny());
        quantityAndMnyVO.setLaborMny(entity.getLaborMny());
        quantityAndMnyVO.setMaterialTaxMny(entity.getMaterialTaxMny());
        quantityAndMnyVO.setMaterialMny(entity.getMaterialMny());
        quantityAndMnyVO.setMajorTaxMny(entity.getMajorTaxMny());
        quantityAndMnyVO.setMajorMny(entity.getMajorMny());
        quantityAndMnyVO.setMechanicalTaxMny(entity.getMechanicalTaxMny());
        quantityAndMnyVO.setMechanicalMny(entity.getMechanicalMny());
        quantityAndMnyVO.setSporadicMaterialMny(entity.getSporadicMaterialMny());
        Map<Long, BudgetProjectDetailProVO> detailProMap = (paramControlVO.getCostType() == 2 || paramControlVO.getCostType() == 4) && CollectionUtils.isNotEmpty((Collection)paramControlVO.getIds()) ? this.budgetProjectDetailProMapper.fetchDetailProMapByQuantityAndMny(entity.getId(), paramControlVO.getCostType(), paramControlVO.getIds()) : this.budgetProjectDetailProMapper.fetchDetailProMap(entity.getId(), paramControlVO.getCostType());
        quantityAndMnyVO.setDetailProMap(detailProMap);
        return quantityAndMnyVO;
    }

    @Override
    public List<BudgetProjectDetailProVO> querySubDetailList(Page<BudgetProjectDetailProVO> page, QueryWrapper wrapper, Long projectId, String costType) {
        return this.budgetProjectProMapper.querySubDetailList(page, wrapper, projectId, costType);
    }

    @Override
    public void pushCostSetting(Long budgetId) {
    }

    @Override
    public List<BudgetProjectDetailProVO> queryOnlySuject(Long projectId, Integer costType, Set<Long> subjectIds) {
        return this.budgetProjectProMapper.queryOnlySuject(projectId, costType, subjectIds);
    }

    @Override
    public Map<Long, BigDecimal> getBudgetProjectProQuantityByProjectId(Long projectId) {
        List<BudgetProjectProQuantityVO> list;
        Map<Long, BigDecimal> map = new HashMap<Long, BigDecimal>();
        if (projectId != null && CollectionUtils.isNotEmpty(list = this.budgetProjectDetailProMapper.getBudgetProjectProQuantityByProjectId(projectId))) {
            map = list.stream().collect(Collectors.toMap(BudgetProjectProQuantityVO::getMaterialId, BudgetProjectProQuantityVO::getNum, (key1, key2) -> key2));
        }
        return map;
    }

    @Override
    public List<BudgetProjectDetailProVO> getBudgetProjectDetailProDataAndSum(Long projectId) {
        return this.budgetProjectProMapper.getBudgetProjectDetailProDataAndSum(projectId);
    }

    @Override
    public BudgetProjectProQuantityAndMnyVO fetchBudgetMny(List<Long> orgIds) {
        BudgetProjectProQuantityAndMnyVO quantityAndMnyVO = new BudgetProjectProQuantityAndMnyVO();
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.in(BudgetProjectProEntity::getOrgId, orgIds);
        lambdaQuery.in(BudgetProjectProEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List list = this.list((Wrapper)lambdaQuery);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (BudgetProjectProEntity entity : list) {
                quantityAndMnyVO.setBudgetTaxMny(ComputeUtil.safeAdd((BigDecimal)entity.getBudgetTaxMny(), (BigDecimal)quantityAndMnyVO.getBudgetTaxMny()));
                quantityAndMnyVO.setIndirectionTaxMny(ComputeUtil.safeAdd((BigDecimal)entity.getIndirectionTaxMny(), (BigDecimal)quantityAndMnyVO.getIndirectionTaxMny()));
                quantityAndMnyVO.setLaborTaxMny(ComputeUtil.safeAdd((BigDecimal)entity.getLaborTaxMny(), (BigDecimal)quantityAndMnyVO.getLaborTaxMny()));
                quantityAndMnyVO.setMaterialTaxMny(ComputeUtil.safeAdd((BigDecimal)entity.getMaterialTaxMny(), (BigDecimal)quantityAndMnyVO.getMaterialTaxMny()));
                quantityAndMnyVO.setMajorTaxMny(ComputeUtil.safeAdd((BigDecimal)entity.getMajorTaxMny(), (BigDecimal)quantityAndMnyVO.getMajorTaxMny()));
                quantityAndMnyVO.setMechanicalTaxMny(ComputeUtil.safeAdd((BigDecimal)entity.getMechanicalTaxMny(), (BigDecimal)quantityAndMnyVO.getMechanicalTaxMny()));
                quantityAndMnyVO.setSporadicMaterialMny(ComputeUtil.safeAdd((BigDecimal)entity.getSporadicMaterialMny(), (BigDecimal)quantityAndMnyVO.getSporadicMaterialMny()));
            }
        }
        return quantityAndMnyVO;
    }

    @Override
    public Map<String, BigDecimal> getProOutMny(Long projectId, Long id, String billTypeCode) {
        return this.budgetProjectProMapper.getProOutMny(projectId, id, billTypeCode);
    }
}

