/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.invest.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.invest.bean.WorkListEntity;
import com.ejianc.business.invest.service.IWorkListService;
import com.ejianc.business.invest.vo.WorkListVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"workList"})
public class WorkListController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IWorkListService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WorkListVO> saveOrUpdate(@RequestBody WorkListVO saveOrUpdateVO) {
        WorkListEntity entity = (WorkListEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, WorkListEntity.class));
        QueryParam param = new QueryParam();
        param.getParams().put("billCode", new Parameter("eq", (Object)entity.getBillCode()));
        List fileCaseEntities = this.service.queryList(param);
        if (entity.getId() == null || entity.getId() == 0L ? fileCaseEntities != null && fileCaseEntities.size() > 0 : fileCaseEntities != null && fileCaseEntities.size() > 1) {
            throw new BusinessException("\u5b58\u5728\u91cd\u590d\u7684\u7f16\u53f7\uff01");
        }
        this.service.saveOrUpdate((Object)entity, false);
        if (entity.getLastTypeId() != null) {
            WorkListEntity pEntity = (WorkListEntity)((Object)this.service.selectById(entity.getLastTypeId()));
            String innerCode = pEntity.getInnerCode();
            entity.setInnerCode(innerCode + "-" + entity.getId().toString());
        } else {
            entity.setInnerCode(entity.getId().toString());
        }
        this.service.saveOrUpdate((Object)entity);
        WorkListVO vo = (WorkListVO)BeanMapper.map((Object)((Object)entity), WorkListVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WorkListVO> queryDetail(Long id) {
        WorkListEntity entity = (WorkListEntity)((Object)this.service.selectById(id));
        WorkListVO vo = (WorkListVO)BeanMapper.map((Object)((Object)entity), WorkListVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WorkListVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (WorkListVO workListVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WorkListVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List page = this.service.queryList(param, false);
        List workListVOS = BeanMapper.mapList((Iterable)page, WorkListVO.class);
        List parentWorkType = workListVOS.stream().filter(s -> s.getLastTypeId() == null).collect(Collectors.toList());
        for (WorkListVO fileTypeVO : parentWorkType) {
            fileTypeVO.setChildren(this.getWorkTypeTree(fileTypeVO.getId(), workListVOS));
        }
        Page pageData = new Page((long)param.getPageIndex(), (long)param.getPageSize(), (long)parentWorkType.size());
        pageData.setRecords(parentWorkType);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("WorkList-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refWorkListData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<WorkListVO>> refWorkListData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        List page = this.service.queryList(param, false);
        List workListVOS = BeanMapper.mapList((Iterable)page, WorkListVO.class);
        List parentWorkType = workListVOS.stream().filter(s -> s.getLastTypeId() == null).collect(Collectors.toList());
        for (WorkListVO fileTypeVO : parentWorkType) {
            fileTypeVO.setChildren(this.getWorkTypeTree(fileTypeVO.getId(), workListVOS));
        }
        Page pageData = new Page((long)param.getPageIndex(), (long)param.getPageSize(), (long)parentWorkType.size());
        pageData.setRecords(parentWorkType);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private List<WorkListVO> getWorkTypeTree(Long parentNodeId, List<WorkListVO> records) {
        ArrayList<WorkListVO> resultList = new ArrayList<WorkListVO>();
        List childrenList = records.stream().filter(s -> parentNodeId.equals(s.getLastTypeId())).collect(Collectors.toList());
        if (ListUtil.isNotEmpty(childrenList)) {
            for (WorkListVO child : childrenList) {
                child.setChildren(this.getWorkTypeTree(child.getId(), records));
                resultList.add(child);
            }
        }
        if (ListUtil.isNotEmpty(resultList)) {
            return resultList;
        }
        return null;
    }
}

