/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlcost.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlcost.finance.bean.CollectEntity;
import com.ejianc.business.jlcost.finance.mapper.CollectMapper;
import com.ejianc.business.jlcost.finance.service.ICollectService;
import com.ejianc.business.jlcost.finance.vo.CollectVO;
import com.ejianc.business.jlcost.payout.bean.ContractEntity;
import com.ejianc.business.jlcost.payout.bean.SettleEntity;
import com.ejianc.business.jlcost.payout.service.IContractService;
import com.ejianc.business.jlcost.payout.service.ISettleService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="collectService")
public class CollectServiceImpl
extends BaseServiceImpl<CollectMapper, CollectEntity>
implements ICollectService {
    @Autowired
    private IContractService contractService;
    @Autowired
    private ISettleService settleService;

    @Override
    public CollectVO querySumMny(Long contractId, Long projectId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(CollectEntity::getContractId, (Object)contractId);
        queryWrapper.eq(CollectEntity::getProjectId, (Object)projectId);
        queryWrapper.in(CollectEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = this.list((Wrapper)queryWrapper);
        CollectVO collectVO = new CollectVO();
        for (CollectEntity entity : list) {
            collectVO.setSumInvoiceMny(ComputeUtil.safeAdd((BigDecimal)collectVO.getInvoiceMny(), (BigDecimal)entity.getInvoiceMny()));
            collectVO.setSumInvoiceTaxMny(ComputeUtil.safeAdd((BigDecimal)collectVO.getInvoiceTaxMny(), (BigDecimal)entity.getInvoiceTaxMny()));
        }
        return collectVO;
    }

    @Override
    public CollectVO contToCollect(Long contractId) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        CollectVO collectVO = (CollectVO)BeanMapper.map((Object)((Object)contractEntity), CollectVO.class);
        collectVO.setId(null);
        collectVO.setBillCode(null);
        collectVO.setCreateTime(null);
        collectVO.setCreateUserCode(null);
        collectVO.setUpdateTime(null);
        collectVO.setUpdateUserCode(null);
        collectVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        collectVO.setSignDate(new Date());
        collectVO.setContractType(String.valueOf(contractEntity.getContractType()));
        collectVO.setContractId(contractId);
        collectVO.setContractCode(contractEntity.getBillCode());
        if (null != contractEntity.getProjectId() && "1".equals(contractEntity.getProjectType())) {
            CollectVO result = this.querySumMny(contractId, contractEntity.getProjectId());
            collectVO.setSumInvoiceMny(result.getSumInvoiceMny());
            collectVO.setSumInvoiceTaxMny(result.getSumInvoiceTaxMny());
            collectVO.setSumInvoiceAllMny(result.getSumInvoiceMny());
            collectVO.setSumInvoiceAllTaxMny(result.getSumInvoiceTaxMny());
        }
        return collectVO;
    }

    @Override
    public JSONObject queryRecordByContId(Long contractId) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("contractMny", (Object)contractEntity.getContractMny());
        jsonObject.put("contractTaxMny", (Object)contractEntity.getContractTaxMny());
        jsonObject.put("performanceStatus", (Object)contractEntity.getPerformanceStatus());
        jsonObject.put("changeStatus", (Object)contractEntity.getChangeStatus());
        jsonObject.put("billState", (Object)contractEntity.getBillState());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SettleEntity::getContractId, (Object)contractId);
        queryWrapper.in(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        queryWrapper.orderByDesc(SettleEntity::getSettleDate);
        queryWrapper.last("limit 1");
        SettleEntity settleEntity = (SettleEntity)((Object)this.settleService.getOne((Wrapper)queryWrapper, false));
        if (null != settleEntity) {
            jsonObject.put("sumSettleAllMny", (Object)settleEntity.getSumSettleAllMny());
            jsonObject.put("sumSettleAllTaxMny", (Object)settleEntity.getSumSettleAllTaxMny());
        }
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(CollectEntity::getContractId, (Object)contractId);
        query.in(CollectEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        query.orderByDesc(CollectEntity::getSignDate);
        List list = this.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List collectVOS = BeanMapper.mapList((Iterable)list, CollectVO.class);
            collectVOS.sort(Comparator.comparing(CollectVO::getSignDate));
            CollectVO collectVO = (CollectVO)collectVOS.get(0);
            jsonObject.put("sumInvoiceAllMny", (Object)collectVO.getSumInvoiceAllMny());
            jsonObject.put("sumInvoiceAllTaxMny", (Object)collectVO.getSumInvoiceAllTaxMny());
            jsonObject.put("settledNoColtMny", (Object)ComputeUtil.safeSub((BigDecimal)jsonObject.getBigDecimal("sumSettleAllTaxMny"), (BigDecimal)collectVO.getSumInvoiceAllTaxMny()));
        }
        return jsonObject;
    }
}

