/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlcost.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.jlcost.finance.bean.PaymentEntity;
import com.ejianc.business.jlcost.finance.mapper.PaymentMapper;
import com.ejianc.business.jlcost.finance.service.IPaymentService;
import com.ejianc.business.jlcost.finance.vo.PaymentRecordVO;
import com.ejianc.business.jlcost.finance.vo.PaymentVO;
import com.ejianc.business.jlcost.payout.bean.ContractEntity;
import com.ejianc.business.jlcost.payout.service.IContractService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="paymentService")
public class PaymentServiceImpl
extends BaseServiceImpl<PaymentMapper, PaymentEntity>
implements IPaymentService {
    @Autowired
    private IContractService contractService;

    @Override
    public PaymentVO addPaymentByConId(Long id) {
        PaymentVO paymentVO = new PaymentVO();
        ContractEntity entity = (ContractEntity)((Object)this.contractService.selectById(id));
        paymentVO.setContractId(entity.getId());
        paymentVO.setContractCode(entity.getBillCode());
        paymentVO.setContractName(entity.getContractName());
        paymentVO.setContractType(entity.getContractType());
        paymentVO.setContractTaxMny(entity.getContractTaxMny());
        return paymentVO;
    }

    @Override
    public PaymentRecordVO queryChangeRecord(Long id) {
        PaymentRecordVO paymentRecordVO = new PaymentRecordVO();
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PaymentEntity::getContractId, (Object)id);
        lambda.in(PaymentEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.orderByDesc(PaymentEntity::getPaymentDate);
        List entities = super.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            paymentRecordVO.setPaymentList(BeanMapper.mapList((Iterable)entities, PaymentVO.class));
            BigDecimal totalPaymentTaxMny = entities.stream().filter(item -> null != item.getPaymentTaxMny()).map(PaymentEntity::getPaymentTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            paymentRecordVO.setTotalInvoiceTaxMny(totalPaymentTaxMny);
        }
        return paymentRecordVO;
    }
}

