package com.ejianc.business.jlcost.cost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlcost.finance.vo.FinanceReportVO;
import com.ejianc.business.jlcost.payout.service.IContractService;
import com.ejianc.business.jlcost.payout.vo.SjCostReportVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 成本管理-成本相关报表
 *
 * @author generator
 */
@Controller
@RequestMapping("costReport")
public class CostReportController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IContractService contractService;

    /**
     * @param param
     * @Description queryList 实际成本台账查询
     * @Return
     */
    @RequestMapping(value = "/queryCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryCost(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billTypeName");
        fuzzyFields.add("costType");

        Page<SjCostReportVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        List<SjCostReportVO> RecordVOList = new ArrayList<>();
        if (param.getParams().containsKey("projectId")) {
            QueryWrapper wrapper = changeToQueryWrapper(param);
            RecordVOList = contractService.querySjCostList(page, wrapper);
        }
        com.alibaba.fastjson.JSONObject res = new com.alibaba.fastjson.JSONObject();
        res.put("records", RecordVOList);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！", res);
    }

    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelCost", method = RequestMethod.POST)
    @ResponseBody
    public void excelCost(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billTypeName");
        fuzzyFields.add("costType");

        Page<SjCostReportVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        List<SjCostReportVO> list = new ArrayList<>();
        if (param.getParams().containsKey("projectId")) {
            QueryWrapper wrapper = changeToQueryWrapper(param);
            list = contractService.querySjCostList(page, wrapper);
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("costReport-export.xlsx", beans, response);
    }


    /**
     * @param param
     * @Description queryList 项目虚拟资金账户统计
     * @Return
     */
    @RequestMapping(value = "/queryFinance", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryFinancec(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billTypeName");

        Page<FinanceReportVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        List<FinanceReportVO> RecordVOList = new ArrayList<>();
        if (param.getParams().containsKey("projectId")) {
            QueryWrapper wrapper = changeToQueryWrapper(param);
            RecordVOList = contractService.queryFinanceList(page, wrapper);
        }
        com.alibaba.fastjson.JSONObject res = new com.alibaba.fastjson.JSONObject();
        res.put("records", RecordVOList);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！", res);
    }

    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelFinance", method = RequestMethod.POST)
    @ResponseBody
    public void excelFinancec(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billTypeName");

        Page<FinanceReportVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        List<FinanceReportVO> list = new ArrayList<>();
        if (param.getParams().containsKey("projectId")) {
            QueryWrapper wrapper = changeToQueryWrapper(param);
            list = contractService.queryFinanceList(page, wrapper);
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("financeReport-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/getCostMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> getCostMny(Long projectId) {
        /** 模糊搜索配置字段示例 */
        FinanceReportVO sumVO = contractService.queryFinanceSum(projectId);
        if (sumVO == null){
            CommonResponse.success(BigDecimal.ZERO);
        }
        if (sumVO.getReceiveMny() == null) sumVO.setReceiveMny(BigDecimal.ZERO);
        if (sumVO.getPaymentMny() == null) sumVO.setPaymentMny(BigDecimal.ZERO);
        return CommonResponse.success(sumVO.getReceiveMny().subtract(sumVO.getPaymentMny()));
    }
}
