package com.ejianc.business.jlcost.payout.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlcost.cost.vo.ProjectRecordVO;
import com.ejianc.business.jlcost.cost.vo.TargetMaterialDetailVO;
import com.ejianc.business.jlcost.finance.vo.FinanceReportVO;
import com.ejianc.business.jlcost.payout.vo.ContractVO;
import com.ejianc.business.jlcost.payout.vo.SjCostReportVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.jlcost.payout.bean.ContractEntity;

import java.math.BigDecimal;
import java.util.List;

/**
 * 支出合同-合同主表
 *
 * @author generator
 */
public interface IContractService extends IBaseService<ContractEntity> {
    /**
     * 保存或修改信息
     *
     * @param contractVo
     * @return
     */
    CommonResponse<ContractVO> saveOrUpdate(ContractVO contractVo);

    /**
     * 根据主键ID查询详情
     *
     * @param id
     * @return
     */
    ContractVO queryDetail(Long id);

    List<ContractVO> queryContractList(Page page, QueryWrapper wrapper,Long projectId, Long orgId);

    List<SjCostReportVO> querySjCostList(Page page, QueryWrapper wrapper);

    List<FinanceReportVO> queryFinanceList(Page page, QueryWrapper wrapper);

    BigDecimal queryFinanceSum(Long projectId);

    List<SjCostReportVO> querySjDetailMny(Long projectId);

    List<SjCostReportVO> queryMaterialMny(Long projectId);

    List<SjCostReportVO> querySjCostMny(Long projectId);

    List<TargetMaterialDetailVO> queryMaterialSum(Long projectId, Long wbsId);

    List<TargetMaterialDetailVO> queryMaterialList(Page page, QueryWrapper wrapper,Long projectId, Long wbsId,Long materialId);

    BigDecimal queryWorkTime(Long projectId, Long wbsId);

    List<TargetMaterialDetailVO> queryWorkTimeList(Page page, QueryWrapper wrapper,Long projectId, Long wbsId);

    List<ProjectRecordVO> queryProjectList();

}
