package com.ejianc.business.jlcost.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ejianc.business.jlcost.finance.vo.LoadApplyVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlcost.finance.mapper.LoadApplyMapper;
import com.ejianc.business.jlcost.finance.bean.LoadApplyEntity;
import com.ejianc.business.jlcost.finance.service.ILoadApplyService;

import java.math.BigDecimal;

/**
 * 资金管理-借款申请
 * 
 * @author generator
 * 
 */
@Service("loadApplyService")
public class LoadApplyServiceImpl extends BaseServiceImpl<LoadApplyMapper, LoadApplyEntity> implements ILoadApplyService{

    @Autowired
    private  LoadApplyMapper mapper;
    @Override
    public void updateBackedMny(Long applyId, BigDecimal mny) {
        LoadApplyEntity entity = mapper.selectById(applyId);
        entity.setBackedMny(mny);
        /**
         * 1、【单据状态】为非生效态时，【借款状态】=申请中。
         *
         * 2、【单据状态】为生效态，【申请金额】>【已报销金额】+【已退还金额】时，【借款状态】=使用中。
         *
         * 3、【单据状态】为生效态，【申请金额】=【已报销金额】+【已退还金额】，【借款状态】=已结束。
         * **/
        //申请
        BigDecimal applyMny = entity.getApplyMny();
        //已报销
        BigDecimal cumulativeMny = entity.getCumulativeMny();
        //已退还
        BigDecimal backedMny = entity.getBackedMny();

        //合计
        BigDecimal sum = cumulativeMny.add(backedMny);

        int result = applyMny.compareTo(sum);
        if (result > 0) {
            entity.setStatus(2); //申请大于合计   使用中
        } else if (result < 0) {
            entity.setStatus(3); //申请小于合计 已结束

        } else {
            entity.setStatus(3); //申请等于合计 已结束
        }
        baseMapper.updateById(entity);
    }

    @Override
    public void updateCumulativeMny(Long applyId, BigDecimal mny) {
        LoadApplyEntity entity = mapper.selectById(applyId);
        entity.setCumulativeMny(mny);
        /**
         * 1、【单据状态】为非生效态时，【借款状态】=申请中。
         *
         * 2、【单据状态】为生效态，【申请金额】>【已报销金额】+【已退还金额】时，【借款状态】=使用中。
         *
         * 3、【单据状态】为生效态，【申请金额】=【已报销金额】+【已退还金额】，【借款状态】=已结束。
         * **/
        //申请
        BigDecimal applyMny = entity.getApplyMny();
        //已报销
        BigDecimal cumulativeMny = entity.getCumulativeMny();
        //已退还
        BigDecimal backedMny = entity.getBackedMny();

        //合计
        BigDecimal sum = cumulativeMny.add(backedMny);

        int result = applyMny.compareTo(sum);
        if (result > 0) {
            entity.setStatus(2); //申请大于合计   使用中
        } else if (result < 0) {
            entity.setStatus(3); //申请小于合计 已结束

        } else {
            entity.setStatus(3); //申请等于合计 已结束
        }
        baseMapper.updateById(entity);
    }
}
