package com.ejianc.business.jlcost.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlcost.finance.bean.InvoiceEntity;
import com.ejianc.business.jlcost.finance.service.IInvoiceService;
import com.ejianc.business.jlcost.finance.vo.ReceiveVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlcost.finance.mapper.ReceiveMapper;
import com.ejianc.business.jlcost.finance.bean.ReceiveEntity;
import com.ejianc.business.jlcost.finance.service.IReceiveService;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 资金管理-收款单
 * 
 * @author generator
 * 
 */
@Service("receiveService")
public class ReceiveServiceImpl extends BaseServiceImpl<ReceiveMapper, ReceiveEntity> implements IReceiveService{
    @Autowired
    private IInvoiceService invoiceService;
    @Override
    public JSONObject queryRecordByContId(Long contractId) {
        JSONObject jsonObject = new JSONObject();
        LambdaQueryWrapper<ReceiveEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ReceiveEntity::getContractId, contractId);
        queryWrapper.in(ReceiveEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.orderByDesc(ReceiveEntity::getReceiveTime);
        List<ReceiveEntity> list = list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            List<ReceiveVO> receiveVOS = BeanMapper.mapList(list, ReceiveVO.class);
            BigDecimal sumReceiveTaxMny = BigDecimal.ZERO;
            for (ReceiveEntity entity : list) {
                sumReceiveTaxMny = ComputeUtil.safeAdd(sumReceiveTaxMny, entity.getReceiveMny());
            }
            jsonObject.put("sumReceiveTaxMny", sumReceiveTaxMny);
            jsonObject.put("detailList", receiveVOS);
        }
        //开票金额
        LambdaQueryWrapper<InvoiceEntity> queryWrapper2 = new LambdaQueryWrapper<>();
        queryWrapper2.eq(InvoiceEntity::getContractId, contractId);
        queryWrapper2.in(InvoiceEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper2.orderByDesc(InvoiceEntity::getInvoiceDate);
        List<InvoiceEntity> list2 = invoiceService.list(queryWrapper2);
        if (CollectionUtils.isNotEmpty(list2)) {
            BigDecimal sumInvoiceTaxMny = BigDecimal.ZERO;
            for (InvoiceEntity entity : list2) {
                sumInvoiceTaxMny = ComputeUtil.safeAdd(sumInvoiceTaxMny, entity.getInvoiceTaxMny());
            }
            jsonObject.put("sumInvoiceTaxMny", sumInvoiceTaxMny);
        }
        return jsonObject;
    }

    @Override
    public Map<Long, JSONObject> queryRecordByContIdList(List<Long> ids) {
        Map<Long, JSONObject> collectMap = new HashMap<>();
        LambdaQueryWrapper<ReceiveEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(ReceiveEntity::getContractId, ids);
        queryWrapper.in(ReceiveEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.orderByDesc(ReceiveEntity::getReceiveTime);
        List<ReceiveEntity> list = list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            Map<Long, List<ReceiveEntity>> receiveDataMap = list.stream().collect(Collectors.groupingBy(ReceiveEntity::getContractId));

            for (Long contractId : receiveDataMap.keySet()) {
                JSONObject jsonObject = new JSONObject();
                List<ReceiveEntity> receiveEntityList = receiveDataMap.get(contractId);
                jsonObject.put("sumReceiveTaxMny", receiveEntityList.stream().filter(e -> null != e.getReceiveMny()).map(ReceiveEntity::getReceiveMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                jsonObject.put("receiveDetailList", receiveEntityList);
                collectMap.put(contractId, jsonObject);
            }
        }
        return collectMap;
    }
}
