package com.ejianc.business.jlcost.payout.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 合同类型
 */
public enum PayoutTypeEnum {
    外协加工(1, "外协加工"),
    成品采购(2, "成品采购"),
    整体外包(3, "整体外包"),
    场地或设备租赁(4, "场地或设备租赁"),
    外部检测(5, "外部检测"),
    外部设计(6, "外部设计"),
    外部产品认证(7, "外部产品认证"),
    劳务分包(8, "劳务分包"),
    设备或材料采购(9, "设备或材料采购"),
    设备租赁(10, "设备租赁");

    private final Integer code;
    private final String description;
    private static Map<Integer, PayoutTypeEnum> enumMap = new HashMap();

    PayoutTypeEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static PayoutTypeEnum getEnumByCode(Integer code) {
        return (PayoutTypeEnum) enumMap.get(code);
    }

    static {
        enumMap = (Map) EnumSet.allOf(PayoutTypeEnum.class).stream().collect(Collectors.toMap(PayoutTypeEnum::getCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
