package com.ejianc.business.jlincome.performance.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.foundation.share.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 绩效管理-销售预报-子表
 *
 * @author generator
 */
public class ForecastDetailVO extends BaseVO implements ITreeNodeB {
    private static final long serialVersionUID = 1L;
    private Long detailOrgId; // 区域主键
    private String detailOrgName; // 区域名称
    private String detailOrgCode; // 区域编码
    private Long pid; // 销售预报主表id
    private Long customerId; // 客户单位id
    private String customerName; // 客户单位名称
    private Long detailPersonId; // 负责人id
    private String detailPersonName; // 负责人
    private BigDecimal saleDetailMny; // 预计销售
    private BigDecimal invoiceDetailMny; // 预计开票
    private BigDecimal incomeDetailMny; // 预计回款
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date successDate; // 完成时间
    private Long parentId; // 父级id
    private Integer leafFlag; // 是否末级
    private String memo; // 备注

    //树形转换需要字段
    private Long tid; // 前端生成树形主键
    private String tpid; // 前端生成树形父主键
    private String indexCode;//序号
    private List<ITreeNodeB> children;


    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    @ReferSerialTransfer(referCode = "support-customer")
    public Long getCustomerId() {
        return customerId;
    }

    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public Date getSuccessDate() {
        return successDate;
    }

    public void setSuccessDate(Date successDate) {
        this.successDate = successDate;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Integer getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Integer leafFlag) {
        this.leafFlag = leafFlag;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }


    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return getParentId();
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }

    public Long getTid() {
        return tid;
    }

    public void setTid(Long tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public String getIndexCode() {
        return indexCode;
    }

    public void setIndexCode(String indexCode) {
        this.indexCode = indexCode;
    }

    public BigDecimal getSaleDetailMny() {
        return saleDetailMny;
    }

    public void setSaleDetailMny(BigDecimal saleDetailMny) {
        this.saleDetailMny = saleDetailMny;
    }

    public BigDecimal getInvoiceDetailMny() {
        return invoiceDetailMny;
    }

    public void setInvoiceDetailMny(BigDecimal invoiceDetailMny) {
        this.invoiceDetailMny = invoiceDetailMny;
    }

    public BigDecimal getIncomeDetailMny() {
        return incomeDetailMny;
    }

    public void setIncomeDetailMny(BigDecimal incomeDetailMny) {
        this.incomeDetailMny = incomeDetailMny;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getDetailPersonId() {
        return detailPersonId;
    }

    @ReferDeserialTransfer
    public void setDetailPersonId(Long detailPersonId) {
        this.detailPersonId = detailPersonId;
    }

    public String getDetailPersonName() {
        return detailPersonName;
    }

    public void setDetailPersonName(String detailPersonName) {
        this.detailPersonName = detailPersonName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getDetailOrgId() {
        return detailOrgId;
    }

    @ReferDeserialTransfer
    public void setDetailOrgId(Long detailOrgId) {
        this.detailOrgId = detailOrgId;
    }

    public String getDetailOrgName() {
        return detailOrgName;
    }

    public void setDetailOrgName(String detailOrgName) {
        this.detailOrgName = detailOrgName;
    }

    public String getDetailOrgCode() {
        return detailOrgCode;
    }

    public void setDetailOrgCode(String detailOrgCode) {
        this.detailOrgCode = detailOrgCode;
    }
}
