package com.ejianc.business.jlincome.bid.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 投标-投标立项
 * 
 * @author generator
 * 
 */
public class BidInitiationVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // billcode
    private Long projectId; // 工程主键
    private String projectName; // 工程名称
    private String customName; // 客户名称
    private Long orgId; // 组织/区域主键
    private String orgName; // 组织/区域名称
    private String orgCode; // 组织/区域编码
    private Long projectTypeId; // 项目类型
    private String projectTypeName; // 项目类型名称
    private String productType; // 产品类型
    private String productTypeName; // 产品类型名称
    private String productName; // 产品名称
    private String specificationAndModel; // 规格型号
    private Integer num; // 数量
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date bidFilePlanReceiveDate; // 招标文件接收日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planDeliverDate; // 预计交货日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date entryEndDate; // 报名截至日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planBidOpenDate; // 预计开标日期
    private BigDecimal productTypeId; // 投标报价
    private Long saleLeaderId; // 销售负责人
    private String saleLeaderName; // 销售负责人名称
    private String saleLeaderPhone; // 销售负责人联系电话
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称
    private String memo; // 备注
    private Integer billState; // 单据状态（审批必须字段）
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode="bid-business")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getCustomName() {
        return customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getProjectTypeId() {
        return projectTypeId;
    }

    public void setProjectTypeId(Long projectTypeId) {
        this.projectTypeId = projectTypeId;
    }
    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }
    public String getProductType() {
        return productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }
    public String getProductTypeName() {
        return productTypeName;
    }

    public void setProductTypeName(String productTypeName) {
        this.productTypeName = productTypeName;
    }
    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }
    public String getSpecificationAndModel() {
        return specificationAndModel;
    }

    public void setSpecificationAndModel(String specificationAndModel) {
        this.specificationAndModel = specificationAndModel;
    }
    public Integer getNum() {
        return num;
    }

    public void setNum(Integer num) {
        this.num = num;
    }
    public Date getBidFilePlanReceiveDate() {
        return bidFilePlanReceiveDate;
    }

    public void setBidFilePlanReceiveDate(Date bidFilePlanReceiveDate) {
        this.bidFilePlanReceiveDate = bidFilePlanReceiveDate;
    }
    public Date getPlanDeliverDate() {
        return planDeliverDate;
    }

    public void setPlanDeliverDate(Date planDeliverDate) {
        this.planDeliverDate = planDeliverDate;
    }
    public Date getEntryEndDate() {
        return entryEndDate;
    }

    public void setEntryEndDate(Date entryEndDate) {
        this.entryEndDate = entryEndDate;
    }
    public Date getPlanBidOpenDate() {
        return planBidOpenDate;
    }

    public void setPlanBidOpenDate(Date planBidOpenDate) {
        this.planBidOpenDate = planBidOpenDate;
    }
    public BigDecimal getProductTypeId() {
        return productTypeId;
    }

    public void setProductTypeId(BigDecimal productTypeId) {
        this.productTypeId = productTypeId;
    }

    public Long getSaleLeaderId() {
        return saleLeaderId;
    }

    public void setSaleLeaderId(Long saleLeaderId) {
        this.saleLeaderId = saleLeaderId;
    }
    public String getSaleLeaderName() {
        return saleLeaderName;
    }

    public void setSaleLeaderName(String saleLeaderName) {
        this.saleLeaderName = saleLeaderName;
    }
    public String getSaleLeaderPhone() {
        return saleLeaderPhone;
    }

    public void setSaleLeaderPhone(String saleLeaderPhone) {
        this.saleLeaderPhone = saleLeaderPhone;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
}
