package com.ejianc.business.jlincome.income.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.jlincome.income.vo.SettleDetailVO;
import com.ejianc.business.jlincome.income.vo.SettleDeductionVO;
import com.ejianc.business.jlincome.income.vo.SettleOtherVO;

/**
 * 收入管理-对甲结算
 * 
 * @author generator
 * 
 */
public class SettleVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private Long contractId; // 合同id
    private String contractName; // 合同名称
    private String contractCode; // 合同编码
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private Long orgId; // 单据组织id
    private String orgName; // 单据组织名称
    private String orgCode; // 单据组织编码
    private Long parentOrgId; // 所属组织编码/区域id
    private String parentOrgName; // 所属组织编码/区域名称
    private String parentOrgCode; // 所属组织编码/区域编码
    private String customerName; // 客户名称
    private Integer settleType; // 结算类型：1、过程结算；2、完工结算
    private Date settleDate; // 结算日期
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称
    private BigDecimal contractTaxMny; // 合同含税金额
    private BigDecimal contractMny; // 合同无税金额
    private BigDecimal contractTax; // 合同税额
    private BigDecimal taxRate; // 合同税率
    private BigDecimal taxMny; // 本期结算金额
    private BigDecimal mny; // 本期结算金额(无税)
    private BigDecimal tax; // 本期结算税额
    private BigDecimal contractDetailTaxMny; // 合同清单金额
    private BigDecimal contractDetailMny; // 合同清单金额(无税)
    private BigDecimal contractDetailTax; // 合同清单税额
    private BigDecimal firstDeductionTaxMny; // 扣款金额
    private BigDecimal firstDeductionMny; // 扣款金额(无税)
    private BigDecimal firstDeductionTax; // 扣款税额
    private BigDecimal detailOtherTaxMny; // 其他结算金额
    private BigDecimal detailOtherMny; // 其他结算金额(无税)
    private BigDecimal detailOtherTax; // 其他结算税额
    private BigDecimal totalTaxMny; // 累计结算金额
    private BigDecimal totalMny; // 累计结算金额(无税)
    private BigDecimal lastTaxMny; // 不含本期累计结算金额
    private BigDecimal lastMny; // 不含本期累计结算金额(无税)
    private BigDecimal totalTicketTaxMny; // 累计开票金额
    private BigDecimal totalTicketMny; // 累计开票金额(无税)
    private BigDecimal totalAccountTaxMny; // 累计收款金额
    private BigDecimal totalAccountMny; // 累计收款金额(无税)
    private String memo; // 备注
    
    private List<SettleDetailVO> settleDetailList = new ArrayList<>(); // 收入管理-对甲结算-合同明细
    private List<SettleDeductionVO> settleDeductionList = new ArrayList<>(); // 收入管理-对甲结算-甲方扣款
    private List<SettleOtherVO> settleOtherList = new ArrayList<>(); // 收入管理-对甲结算-其他费用

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public Integer getSettleType() {
        return settleType;
    }

    public void setSettleType(Integer settleType) {
        this.settleType = settleType;
    }
    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    public BigDecimal getContractDetailTaxMny() {
        return contractDetailTaxMny;
    }

    public void setContractDetailTaxMny(BigDecimal contractDetailTaxMny) {
        this.contractDetailTaxMny = contractDetailTaxMny;
    }
    public BigDecimal getContractDetailMny() {
        return contractDetailMny;
    }

    public void setContractDetailMny(BigDecimal contractDetailMny) {
        this.contractDetailMny = contractDetailMny;
    }
    public BigDecimal getContractDetailTax() {
        return contractDetailTax;
    }

    public void setContractDetailTax(BigDecimal contractDetailTax) {
        this.contractDetailTax = contractDetailTax;
    }
    public BigDecimal getFirstDeductionTaxMny() {
        return firstDeductionTaxMny;
    }

    public void setFirstDeductionTaxMny(BigDecimal firstDeductionTaxMny) {
        this.firstDeductionTaxMny = firstDeductionTaxMny;
    }
    public BigDecimal getFirstDeductionMny() {
        return firstDeductionMny;
    }

    public void setFirstDeductionMny(BigDecimal firstDeductionMny) {
        this.firstDeductionMny = firstDeductionMny;
    }
    public BigDecimal getFirstDeductionTax() {
        return firstDeductionTax;
    }

    public void setFirstDeductionTax(BigDecimal firstDeductionTax) {
        this.firstDeductionTax = firstDeductionTax;
    }
    public BigDecimal getDetailOtherTaxMny() {
        return detailOtherTaxMny;
    }

    public void setDetailOtherTaxMny(BigDecimal detailOtherTaxMny) {
        this.detailOtherTaxMny = detailOtherTaxMny;
    }
    public BigDecimal getDetailOtherMny() {
        return detailOtherMny;
    }

    public void setDetailOtherMny(BigDecimal detailOtherMny) {
        this.detailOtherMny = detailOtherMny;
    }
    public BigDecimal getDetailOtherTax() {
        return detailOtherTax;
    }

    public void setDetailOtherTax(BigDecimal detailOtherTax) {
        this.detailOtherTax = detailOtherTax;
    }
    public BigDecimal getTotalTaxMny() {
        return totalTaxMny;
    }

    public void setTotalTaxMny(BigDecimal totalTaxMny) {
        this.totalTaxMny = totalTaxMny;
    }
    public BigDecimal getTotalMny() {
        return totalMny;
    }

    public void setTotalMny(BigDecimal totalMny) {
        this.totalMny = totalMny;
    }
    public BigDecimal getLastTaxMny() {
        return lastTaxMny;
    }

    public void setLastTaxMny(BigDecimal lastTaxMny) {
        this.lastTaxMny = lastTaxMny;
    }
    public BigDecimal getLastMny() {
        return lastMny;
    }

    public void setLastMny(BigDecimal lastMny) {
        this.lastMny = lastMny;
    }
    public BigDecimal getTotalTicketTaxMny() {
        return totalTicketTaxMny;
    }

    public void setTotalTicketTaxMny(BigDecimal totalTicketTaxMny) {
        this.totalTicketTaxMny = totalTicketTaxMny;
    }
    public BigDecimal getTotalTicketMny() {
        return totalTicketMny;
    }

    public void setTotalTicketMny(BigDecimal totalTicketMny) {
        this.totalTicketMny = totalTicketMny;
    }
    public BigDecimal getTotalAccountTaxMny() {
        return totalAccountTaxMny;
    }

    public void setTotalAccountTaxMny(BigDecimal totalAccountTaxMny) {
        this.totalAccountTaxMny = totalAccountTaxMny;
    }
    public BigDecimal getTotalAccountMny() {
        return totalAccountMny;
    }

    public void setTotalAccountMny(BigDecimal totalAccountMny) {
        this.totalAccountMny = totalAccountMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
     public List<SettleDetailVO> getSettleDetailList() {
        return settleDetailList;
     }

     public void setSettleDetailList(List<SettleDetailVO> settleDetailList) {
        this.settleDetailList = settleDetailList;
     }
     public List<SettleDeductionVO> getSettleDeductionList() {
        return settleDeductionList;
     }

     public void setSettleDeductionList(List<SettleDeductionVO> settleDeductionList) {
        this.settleDeductionList = settleDeductionList;
     }
     public List<SettleOtherVO> getSettleOtherList() {
        return settleOtherList;
     }

     public void setSettleOtherList(List<SettleOtherVO> settleOtherList) {
        this.settleOtherList = settleOtherList;
     }
}
