package com.ejianc.business.jlincome.income.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 收入管理-合同登记-合同明细
 * 
 * @author generator
 * 
 */
public class ImportContractRegisterDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long contractRegisterId; // 主表id（合同登记)
    private String detailProductName; // 产品名称
    private String detailSpec; // 规格型号
    private String detailUnit; // 单位
    private BigDecimal detailNum; // 数量
    private BigDecimal detailTaxPrice; // 单价
    private BigDecimal detailRate; // 税率
    private BigDecimal detailTaxMny; // 金额
    private BigDecimal detailPrice; // 单价（无税）
    private BigDecimal detailMny; // 金额（无税）
    private BigDecimal detailTax; // 税额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date detailPlanDeliverDate; // 预计交货日期
    private Long sourceId; // 来源id（合同评审子表id）
    private Long sourceBillId; // 来源主单据id（合同评审主表id）
    private String sourceBillCode; // 来源主单据编码（合同评审主表code）
    private Integer sourceType; // 来源类型 0-手动新增 1-合同评审 2-导入
    private String detailMemo; // 备注

    /**
     * 导入失败原因
     */
    private String errorMessage;
    

    public Long getContractRegisterId() {
        return contractRegisterId;
    }

    public void setContractRegisterId(Long contractRegisterId) {
        this.contractRegisterId = contractRegisterId;
    }
    public String getDetailProductName() {
        return detailProductName;
    }

    public void setDetailProductName(String detailProductName) {
        this.detailProductName = detailProductName;
    }
    public String getDetailSpec() {
        return detailSpec;
    }

    public void setDetailSpec(String detailSpec) {
        this.detailSpec = detailSpec;
    }
    public String getDetailUnit() {
        return detailUnit;
    }

    public void setDetailUnit(String detailUnit) {
        this.detailUnit = detailUnit;
    }
    public BigDecimal getDetailNum() {
        return detailNum;
    }

    public void setDetailNum(BigDecimal detailNum) {
        this.detailNum = detailNum;
    }
    public BigDecimal getDetailTaxPrice() {
        return detailTaxPrice;
    }

    public void setDetailTaxPrice(BigDecimal detailTaxPrice) {
        this.detailTaxPrice = detailTaxPrice;
    }
    public BigDecimal getDetailRate() {
        return detailRate;
    }

    public void setDetailRate(BigDecimal detailRate) {
        this.detailRate = detailRate;
    }
    public BigDecimal getDetailTaxMny() {
        return detailTaxMny;
    }

    public void setDetailTaxMny(BigDecimal detailTaxMny) {
        this.detailTaxMny = detailTaxMny;
    }
    public BigDecimal getDetailPrice() {
        return detailPrice;
    }

    public void setDetailPrice(BigDecimal detailPrice) {
        this.detailPrice = detailPrice;
    }
    public BigDecimal getDetailMny() {
        return detailMny;
    }

    public void setDetailMny(BigDecimal detailMny) {
        this.detailMny = detailMny;
    }
    public BigDecimal getDetailTax() {
        return detailTax;
    }

    public void setDetailTax(BigDecimal detailTax) {
        this.detailTax = detailTax;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public Long getSourceBillId() {
        return sourceBillId;
    }

    public void setSourceBillId(Long sourceBillId) {
        this.sourceBillId = sourceBillId;
    }
    public String getSourceBillCode() {
        return sourceBillCode;
    }

    public void setSourceBillCode(String sourceBillCode) {
        this.sourceBillCode = sourceBillCode;
    }
    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    public String getDetailMemo() {
        return detailMemo;
    }

    public void setDetailMemo(String detailMemo) {
        this.detailMemo = detailMemo;
    }

    public Date getDetailPlanDeliverDate() {
        return detailPlanDeliverDate;
    }

    public void setDetailPlanDeliverDate(Date detailPlanDeliverDate) {
        this.detailPlanDeliverDate = detailPlanDeliverDate;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}
