package com.ejianc.business.jlincome.income.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 收入管理-合同评审
 * 
 * @author generator
 * 
 */
public class ReviewVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private Long orgId; // 单据组织id
    private String orgName; // 单据组织名称
    private String orgCode; // 单据组织编码
    private Long parentOrgId; // 所属组织编码/区域id
    private String parentOrgName; // 所属组织编码/区域名称
    private String parentOrgCode; // 所属组织编码/区域编码
    private Integer reviewType; // 评审类型：1、100万以下；2、100以上
    private String reviewTypeStr; // 评审类型：1、100万以下；2、100以上
    private String reviewTitle; // 评审标题
    private Long undertakeUnitId; // 承接单位
    private String undertakeUnitName; // 承接单位名称
    private String customerName; // 客户名称
    private String productType; // 产品类型
    private String productTypeName; // 产品类型名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date reviewDate; // 评审日期
    private Long saleLeaderId; // 销售负责人
    private String saleLeaderName; // 销售负责人名称
    private String saleLeaderPhone; // 销售负责人联系电话
    private BigDecimal contractTaxMny; // 合同含税金额
    private BigDecimal contractMny; // 合同无税金额
    private BigDecimal contractTax; // 合同税额
    private BigDecimal taxRate; // 合同税率
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date deliveryDate; // 交货日期
    private String productName; // 产品名称
    private String spec; // 规格型号
    private String num; // 数量
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称
    private String reviewPersonDepart; // 评审人(部门)
    private String reviewResult; // 评审结果
    private String memo; // 备注
    private String  billStateName;
    private List<ReviewDepartVO> departList = new ArrayList<>(); // 收入管理-合同评审-评审部门
    private List<ReviewRecordVO> recordList = new ArrayList<>(); // 收入管理-合同评审-评审记录
    private List<ReviewDetailVO> detailList = new ArrayList<>(); // 收入管理-合同评审-评审产品清单明细
    private BigDecimal contractRegisterTaxMny; // 合同登记含税金额
    private BigDecimal contractRegisterMny; // 合同登记无税金额

    public BigDecimal getContractRegisterTaxMny() {
        return contractRegisterTaxMny;
    }

    public void setContractRegisterTaxMny(BigDecimal contractRegisterTaxMny) {
        this.contractRegisterTaxMny = contractRegisterTaxMny;
    }

    public BigDecimal getContractRegisterMny() {
        return contractRegisterMny;
    }

    public void setContractRegisterMny(BigDecimal contractRegisterMny) {
        this.contractRegisterMny = contractRegisterMny;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getReviewTypeStr() {
        return reviewTypeStr;
    }

    public void setReviewTypeStr(String reviewTypeStr) {
        this.reviewTypeStr = reviewTypeStr;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="project-archive")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Integer getReviewType() {
        return reviewType;
    }

    public void setReviewType(Integer reviewType) {
        this.reviewType = reviewType;
    }
    public String getReviewTitle() {
        return reviewTitle;
    }

    public void setReviewTitle(String reviewTitle) {
        this.reviewTitle = reviewTitle;
    }
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getUndertakeUnitId() {
        return undertakeUnitId;
    }
    @ReferDeserialTransfer
    public void setUndertakeUnitId(Long undertakeUnitId) {
        this.undertakeUnitId = undertakeUnitId;
    }
    public String getUndertakeUnitName() {
        return undertakeUnitName;
    }

    public void setUndertakeUnitName(String undertakeUnitName) {
        this.undertakeUnitName = undertakeUnitName;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public String getProductType() {
        return productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }
    public String getProductTypeName() {
        return productTypeName;
    }

    public void setProductTypeName(String productTypeName) {
        this.productTypeName = productTypeName;
    }
    public Date getReviewDate() {
        return reviewDate;
    }

    public void setReviewDate(Date reviewDate) {
        this.reviewDate = reviewDate;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getSaleLeaderId() {
        return saleLeaderId;
    }
    @ReferDeserialTransfer
    public void setSaleLeaderId(Long saleLeaderId) {
        this.saleLeaderId = saleLeaderId;
    }
    public String getSaleLeaderName() {
        return saleLeaderName;
    }

    public void setSaleLeaderName(String saleLeaderName) {
        this.saleLeaderName = saleLeaderName;
    }
    public String getSaleLeaderPhone() {
        return saleLeaderPhone;
    }

    public void setSaleLeaderPhone(String saleLeaderPhone) {
        this.saleLeaderPhone = saleLeaderPhone;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public Date getDeliveryDate() {
        return deliveryDate;
    }

    public void setDeliveryDate(Date deliveryDate) {
        this.deliveryDate = deliveryDate;
    }
    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getNum() {
        return num;
    }

    public void setNum(String num) {
        this.num = num;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getReviewPersonDepart() {
        return reviewPersonDepart;
    }

    public void setReviewPersonDepart(String reviewPersonDepart) {
        this.reviewPersonDepart = reviewPersonDepart;
    }
    public String getReviewResult() {
        return reviewResult;
    }

    public void setReviewResult(String reviewResult) {
        this.reviewResult = reviewResult;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
     public List<ReviewDepartVO> getDepartList() {
        return departList;
     }

     public void setDepartList(List<ReviewDepartVO> departList) {
        this.departList = departList;
     }
     public List<ReviewRecordVO> getRecordList() {
        return recordList;
     }

     public void setRecordList(List<ReviewRecordVO> recordList) {
        this.recordList = recordList;
     }
     public List<ReviewDetailVO> getDetailList() {
        return detailList;
     }

     public void setDetailList(List<ReviewDetailVO> detailList) {
        this.detailList = detailList;
     }
}
