package com.ejianc.business.jlincome.income.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 收入管理-甲方扣款
 * 
 * @author generator
 * 
 */
public class DeductionVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long contractId; // 合同ID
    private String contractCode; // 合同code
    private String contractName; // 合同名称
    private Long projectId; // 项目ID
    private String projectCode; // 项目code
    private String projectName; // 项目名称
    private Long orgId; // 组织ID
    private String orgCode; // 组织code
    private String orgName; // 组织名称
    private Long parentOrgId; // 项目部上级组织ID(区域名称)
    private String parentOrgCode; // 项目部上级组织code
    private String parentOrgName; // 项目部上级组织名称
    private Long customerId; // 客户ID
    private String customerCode; // 客户code
    private String customerName; // 客户名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date deductionDate; // 扣款日期
    private BigDecimal deductionTaxMny; // 扣款金额
    private BigDecimal totalDeductionMny; // 累计扣款金额(无税)
    private BigDecimal includeTotalDeductionMny; // 含本次累计扣款金额(无税)
    private BigDecimal totalDeductionTax; // 累计扣款金额(含税)
    private BigDecimal includeTotalDeductionTax; // 含本次累计扣款金额(含税)
    private BigDecimal taxRate; // 税率
    private BigDecimal deductionTax; // 税额
    private BigDecimal deductionMny; // 扣款金额(无税)
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称
    private String memo; // 扣款原因
    private Integer billState; // 单据状态（审批必须字段）
    private String  billStateName; // 单据状态字段翻译
    private Integer hasRecord; // 是否被引用(1：是，0：否）


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "income-contract-register")
    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerCode() {
        return customerCode;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public Date getDeductionDate() {
        return deductionDate;
    }

    public void setDeductionDate(Date deductionDate) {
        this.deductionDate = deductionDate;
    }
    public BigDecimal getDeductionTaxMny() {
        return deductionTaxMny;
    }

    public void setDeductionTaxMny(BigDecimal deductionTaxMny) {
        this.deductionTaxMny = deductionTaxMny;
    }
    public BigDecimal getTotalDeductionMny() {
        return totalDeductionMny;
    }

    public void setTotalDeductionMny(BigDecimal totalDeductionMny) {
        this.totalDeductionMny = totalDeductionMny;
    }
    public BigDecimal getIncludeTotalDeductionMny() {
        return includeTotalDeductionMny;
    }

    public void setIncludeTotalDeductionMny(BigDecimal includeTotalDeductionMny) {
        this.includeTotalDeductionMny = includeTotalDeductionMny;
    }
    public BigDecimal getTotalDeductionTax() {
        return totalDeductionTax;
    }

    public void setTotalDeductionTax(BigDecimal totalDeductionTax) {
        this.totalDeductionTax = totalDeductionTax;
    }
    public BigDecimal getIncludeTotalDeductionTax() {
        return includeTotalDeductionTax;
    }

    public void setIncludeTotalDeductionTax(BigDecimal includeTotalDeductionTax) {
        this.includeTotalDeductionTax = includeTotalDeductionTax;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getDeductionTax() {
        return deductionTax;
    }

    public void setDeductionTax(BigDecimal deductionTax) {
        this.deductionTax = deductionTax;
    }
    public BigDecimal getDeductionMny() {
        return deductionMny;
    }

    public void setDeductionMny(BigDecimal deductionMny) {
        this.deductionMny = deductionMny;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Integer getHasRecord() {
        return hasRecord;
    }

    public void setHasRecord(Integer hasRecord) {
        this.hasRecord = hasRecord;
    }
}
