package com.ejianc.business.jlincome.income.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 收入管理-合同登记-变更-合同明细
 * 
 * @author generator
 * 
 */
public class ContractRegisterChangeDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long contractRegisterId; // 主表id（合同登记)
    private String detailProductName; // 产品名称
    private String detailSpec; // 规格型号
    private String detailUnit; // 单位
    private BigDecimal detailNum; // 数量
    private BigDecimal detailTaxPrice; // 单价
    private BigDecimal detailRate; // 税率
    private BigDecimal detailTaxMny; // 金额
    private BigDecimal detailPrice; // 单价（无税）
    private BigDecimal detailMny; // 金额（无税）
    private BigDecimal detailTax; // 税额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date detailPlanDeliverDate; // 预计交货日期
    private Long sourceId; // 来源id（合同评审子表id）
    private Long sourceBillId; // 来源主单据id（合同评审主表id）
    private String sourceBillCode; // 来源主单据编码（合同评审主表code）
    private Integer sourceType; // 来源类型 0-手动新增 1-合同评审 2-导入
    private String detailMemo; // 备注
    private BigDecimal beforeChangeNum; // 变更前数量
    private BigDecimal beforeChangePrice; // 变更前单价
    private BigDecimal beforeChangeRate; // 变更前税率
    private Long contractDetailId; // 原合同子表主键
    private Long contractId; // 原合同主键
    private String changeType; // 变更类型未变更(0),变更量(1),变更价(2),增补项(3),变更量价(4),终止项(5),其他(6);
    

    public Long getContractRegisterId() {
        return contractRegisterId;
    }

    public void setContractRegisterId(Long contractRegisterId) {
        this.contractRegisterId = contractRegisterId;
    }
    public String getDetailProductName() {
        return detailProductName;
    }

    public void setDetailProductName(String detailProductName) {
        this.detailProductName = detailProductName;
    }
    public String getDetailSpec() {
        return detailSpec;
    }

    public void setDetailSpec(String detailSpec) {
        this.detailSpec = detailSpec;
    }
    public String getDetailUnit() {
        return detailUnit;
    }

    public void setDetailUnit(String detailUnit) {
        this.detailUnit = detailUnit;
    }
    public BigDecimal getDetailNum() {
        return detailNum;
    }

    public void setDetailNum(BigDecimal detailNum) {
        this.detailNum = detailNum;
    }
    public BigDecimal getDetailTaxPrice() {
        return detailTaxPrice;
    }

    public void setDetailTaxPrice(BigDecimal detailTaxPrice) {
        this.detailTaxPrice = detailTaxPrice;
    }
    public BigDecimal getDetailRate() {
        return detailRate;
    }

    public void setDetailRate(BigDecimal detailRate) {
        this.detailRate = detailRate;
    }
    public BigDecimal getDetailTaxMny() {
        return detailTaxMny;
    }

    public void setDetailTaxMny(BigDecimal detailTaxMny) {
        this.detailTaxMny = detailTaxMny;
    }
    public BigDecimal getDetailPrice() {
        return detailPrice;
    }

    public void setDetailPrice(BigDecimal detailPrice) {
        this.detailPrice = detailPrice;
    }
    public BigDecimal getDetailMny() {
        return detailMny;
    }

    public void setDetailMny(BigDecimal detailMny) {
        this.detailMny = detailMny;
    }
    public BigDecimal getDetailTax() {
        return detailTax;
    }

    public void setDetailTax(BigDecimal detailTax) {
        this.detailTax = detailTax;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public Long getSourceBillId() {
        return sourceBillId;
    }

    public void setSourceBillId(Long sourceBillId) {
        this.sourceBillId = sourceBillId;
    }
    public String getSourceBillCode() {
        return sourceBillCode;
    }

    public void setSourceBillCode(String sourceBillCode) {
        this.sourceBillCode = sourceBillCode;
    }
    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    public String getDetailMemo() {
        return detailMemo;
    }

    public void setDetailMemo(String detailMemo) {
        this.detailMemo = detailMemo;
    }
    public BigDecimal getBeforeChangeNum() {
        return beforeChangeNum;
    }

    public void setBeforeChangeNum(BigDecimal beforeChangeNum) {
        this.beforeChangeNum = beforeChangeNum;
    }
    public BigDecimal getBeforeChangePrice() {
        return beforeChangePrice;
    }

    public void setBeforeChangePrice(BigDecimal beforeChangePrice) {
        this.beforeChangePrice = beforeChangePrice;
    }
    public BigDecimal getBeforeChangeRate() {
        return beforeChangeRate;
    }

    public void setBeforeChangeRate(BigDecimal beforeChangeRate) {
        this.beforeChangeRate = beforeChangeRate;
    }
    public Long getContractDetailId() {
        return contractDetailId;
    }

    public void setContractDetailId(Long contractDetailId) {
        this.contractDetailId = contractDetailId;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Date getDetailPlanDeliverDate() {
        return detailPlanDeliverDate;
    }

    public void setDetailPlanDeliverDate(Date detailPlanDeliverDate) {
        this.detailPlanDeliverDate = detailPlanDeliverDate;
    }

    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }
}
