package com.ejianc.business.jlincome.income.vo;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 收入管理-合同登记
 * 
 * @author generator
 * 
 */
public class ContractRegisterReportVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 合同编码
    private Integer billState; // 单据状态
    private String contractName; // 合同名称
    private Long projectId; // 项目Id
    private String projectCode; // 项目code
    private String projectName; // 项目名称
    private Long orgId; // 项目部Id
    private String orgName; // 项目部名称
    private String orgCode; // 项目部编码
    private Long parentOrgId; // 项目部上级组织Id（区域名称）
    private String parentOrgName; // 项目部上级组织名称
    private String parentOrgCode; // 项目部上级组织编码
    private Long reviewId; // 合同评审Id
    private String reviewName; // 合同评审名称
    private String reviewCode; // 合同评审编码
    private Long undertakeUnitId; // 承接单位
    private String undertakeUnitName; // 承接单位名称
    private Long customerId; // 客户id
    private String customerName; // 客户名称
    private String customerCode; // 客户编码
    private String customLinkName; // 客户联系人
    private String customLinkPhone; // 客户联系人电话
    private Long projectTypeId; // 项目类型
    private String projectTypeName; // 项目类型名称
    private String productType; // 产品类型
    private String productTypeName; // 产品类型名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date receiveDate; // 合同接收日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 合同签订日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date deliveryDate; // 交货日期
    private BigDecimal contractTaxMny; // 合同金额
    private BigDecimal contractMny; // 合同金额（无税）
    private BigDecimal contractTax; // 合同税额
    private BigDecimal taxRate; // 合同税率
    private BigDecimal warrantyTaxMny; // 质保金
    private BigDecimal warrantyMny; // 质保金（无税）
    private String specNum; // 产品规格数量
    private Long saleLeaderId; // 销售负责人
    private String saleLeaderName; // 销售负责人名称
    private String saleLeaderPhone; // 销售负责人联系电话
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称
    private String performanceStatus; // 合同履状态：1、未签订；2、履约中；3、已封账；
    private String payCondition; // 付款条件
    private String memo; // 备注
    private BigDecimal baseMny; // 初始版本金额
    private BigDecimal baseTaxMny; // 初始版本(含税)金额
    private BigDecimal beforeChangeMny; // 变更前金额
    private BigDecimal beforeChangeTaxMny; // 变更前金额（含税）
    private BigDecimal changingMny; // 变更中金额
    private BigDecimal changingTaxMny; // 变更中金额（含税）
    private String changeCode; // 变更单号
    private Integer changeVersion; // 变更版本
    private Long changeId; // 变更主键
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeDate; // 变更日期
    private String changeContractName; // 变更合同名称
    private String changeMemo; // 变更原因
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date effectDate; // 生效时间

    private String performanceStatusName; // 合同履状态：1、未签订；2、履约中；3、已封账；
    private String changeStatusName; // 变更状态(1-未变更 2-变更中 3-已变更)

    private String billStateName; // 单据状态名称

    private List<ContractRegisterDetailVO> detailList = new ArrayList<>(); // 收入管理-合同登记-合同明细
    private List<ContractRegisterClauseVO> clauseList = new ArrayList<>(); // 收入管理-合同登记-合同条款


    //下游业务字段
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date firstOrderDate; // 首次订单日期
    private String productOutState = "未发货"; // 发货状态
    private BigDecimal sumInvoiceTaxMny = BigDecimal.ZERO; // 总开票金额
    private BigDecimal sumReceiveTaxMny = BigDecimal.ZERO; // 总收款金额
    private BigDecimal sumSettleTaxMny = BigDecimal.ZERO; // 总结算金额
    private String checkState = "未验收"; // 验收状态
    private Long userReportId; // 用户报告主键id

    private Integer deliveryNoticeNum = 0; // 发货通知单数量

    private List<JSONObject> salesList = new ArrayList<>(); // 销售订单明细
    private List<JSONObject> productOutVOList = new ArrayList<>(); // 发货明细
    private List<JSONObject> invoiceDetailList = new ArrayList<>(); // 开票明细
    private List<JSONObject> receiveDetailList = new ArrayList<>(); // 收款明细
    private List<JSONObject> settleList = new ArrayList<>(); // 结算明细
    private List<JSONObject> checkList = new ArrayList<>(); // 验收明细
    private List<JSONObject> deliveryNoticeList = new ArrayList<>(); // 发货通知单





    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    @ReferSerialTransfer(referCode = "ref-review")
    public Long getReviewId() {
        return reviewId;
    }

    @ReferDeserialTransfer
    public void setReviewId(Long reviewId) {
        this.reviewId = reviewId;
    }
    public String getReviewName() {
        return reviewName;
    }

    public void setReviewName(String reviewName) {
        this.reviewName = reviewName;
    }
    public String getReviewCode() {
        return reviewCode;
    }

    public void setReviewCode(String reviewCode) {
        this.reviewCode = reviewCode;
    }
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getUndertakeUnitId() {
        return undertakeUnitId;
    }
    @ReferDeserialTransfer
    public void setUndertakeUnitId(Long undertakeUnitId) {
        this.undertakeUnitId = undertakeUnitId;
    }
    public String getUndertakeUnitName() {
        return undertakeUnitName;
    }

    public void setUndertakeUnitName(String undertakeUnitName) {
        this.undertakeUnitName = undertakeUnitName;
    }
    @ReferSerialTransfer(referCode = "support-customer")
    public Long getCustomerId() {
        return customerId;
    }
    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public String getCustomerCode() {
        return customerCode;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }
    public String getCustomLinkName() {
        return customLinkName;
    }

    public void setCustomLinkName(String customLinkName) {
        this.customLinkName = customLinkName;
    }
    public String getCustomLinkPhone() {
        return customLinkPhone;
    }

    public void setCustomLinkPhone(String customLinkPhone) {
        this.customLinkPhone = customLinkPhone;
    }
    public Long getProjectTypeId() {
        return projectTypeId;
    }
    @ReferDeserialTransfer
    public void setProjectTypeId(Long projectTypeId) {
        this.projectTypeId = projectTypeId;
    }
    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }
    public String getProductType() {
        return productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }
    public String getProductTypeName() {
        return productTypeName;
    }

    public void setProductTypeName(String productTypeName) {
        this.productTypeName = productTypeName;
    }
    public Date getReceiveDate() {
        return receiveDate;
    }

    public void setReceiveDate(Date receiveDate) {
        this.receiveDate = receiveDate;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public Date getDeliveryDate() {
        return deliveryDate;
    }

    public void setDeliveryDate(Date deliveryDate) {
        this.deliveryDate = deliveryDate;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public String getSpecNum() {
        return specNum;
    }

    public void setSpecNum(String specNum) {
        this.specNum = specNum;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getSaleLeaderId() {
        return saleLeaderId;
    }
    @ReferDeserialTransfer
    public void setSaleLeaderId(Long saleLeaderId) {
        this.saleLeaderId = saleLeaderId;
    }
    public String getSaleLeaderName() {
        return saleLeaderName;
    }

    public void setSaleLeaderName(String saleLeaderName) {
        this.saleLeaderName = saleLeaderName;
    }
    public String getSaleLeaderPhone() {
        return saleLeaderPhone;
    }

    public void setSaleLeaderPhone(String saleLeaderPhone) {
        this.saleLeaderPhone = saleLeaderPhone;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }
    public String getPayCondition() {
        return payCondition;
    }

    public void setPayCondition(String payCondition) {
        this.payCondition = payCondition;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public BigDecimal getBaseMny() {
        return baseMny;
    }

    public void setBaseMny(BigDecimal baseMny) {
        this.baseMny = baseMny;
    }
    public BigDecimal getBaseTaxMny() {
        return baseTaxMny;
    }

    public void setBaseTaxMny(BigDecimal baseTaxMny) {
        this.baseTaxMny = baseTaxMny;
    }
    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }
    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }
    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }
    public BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    public void setChangingTaxMny(BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }
    public String getChangeContractName() {
        return changeContractName;
    }

    public void setChangeContractName(String changeContractName) {
        this.changeContractName = changeContractName;
    }
    public String getChangeMemo() {
        return changeMemo;
    }

    public void setChangeMemo(String changeMemo) {
        this.changeMemo = changeMemo;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public List<ContractRegisterDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ContractRegisterDetailVO> detailList) {
        this.detailList = detailList;
    }

    public List<ContractRegisterClauseVO> getClauseList() {
        return clauseList;
    }

    public void setClauseList(List<ContractRegisterClauseVO> clauseList) {
        this.clauseList = clauseList;
    }


    public BigDecimal getWarrantyTaxMny() {
        return warrantyTaxMny;
    }

    public void setWarrantyTaxMny(BigDecimal warrantyTaxMny) {
        this.warrantyTaxMny = warrantyTaxMny;
    }

    public BigDecimal getWarrantyMny() {
        return warrantyMny;
    }

    public void setWarrantyMny(BigDecimal warrantyMny) {
        this.warrantyMny = warrantyMny;
    }

    public Date getEffectDate() {
        return effectDate;
    }

    public void setEffectDate(Date effectDate) {
        this.effectDate = effectDate;
    }

    public String getPerformanceStatusName() {
        return performanceStatusName;
    }

    public void setPerformanceStatusName(String performanceStatusName) {
        this.performanceStatusName = performanceStatusName;
    }

    public String getChangeStatusName() {
        return changeStatusName;
    }

    public void setChangeStatusName(String changeStatusName) {
        this.changeStatusName = changeStatusName;
    }

    public Date getFirstOrderDate() {
        return firstOrderDate;
    }

    public void setFirstOrderDate(Date firstOrderDate) {
        this.firstOrderDate = firstOrderDate;
    }

    public String getProductOutState() {
        return productOutState;
    }

    public void setProductOutState(String productOutState) {
        this.productOutState = productOutState;
    }

    public BigDecimal getSumInvoiceTaxMny() {
        return sumInvoiceTaxMny;
    }

    public void setSumInvoiceTaxMny(BigDecimal sumInvoiceTaxMny) {
        this.sumInvoiceTaxMny = sumInvoiceTaxMny;
    }

    public BigDecimal getSumReceiveTaxMny() {
        return sumReceiveTaxMny;
    }

    public void setSumReceiveTaxMny(BigDecimal sumReceiveTaxMny) {
        this.sumReceiveTaxMny = sumReceiveTaxMny;
    }

    public BigDecimal getSumSettleTaxMny() {
        return sumSettleTaxMny;
    }

    public void setSumSettleTaxMny(BigDecimal sumSettleTaxMny) {
        this.sumSettleTaxMny = sumSettleTaxMny;
    }

    public String getCheckState() {
        return checkState;
    }

    public void setCheckState(String checkState) {
        this.checkState = checkState;
    }

    public List<JSONObject> getSalesList() {
        return salesList;
    }

    public void setSalesList(List<JSONObject> salesList) {
        this.salesList = salesList;
    }

    public List<JSONObject> getProductOutVOList() {
        return productOutVOList;
    }

    public void setProductOutVOList(List<JSONObject> productOutVOList) {
        this.productOutVOList = productOutVOList;
    }

    public List<JSONObject> getInvoiceDetailList() {
        return invoiceDetailList;
    }

    public void setInvoiceDetailList(List<JSONObject> invoiceDetailList) {
        this.invoiceDetailList = invoiceDetailList;
    }

    public List<JSONObject> getReceiveDetailList() {
        return receiveDetailList;
    }

    public void setReceiveDetailList(List<JSONObject> receiveDetailList) {
        this.receiveDetailList = receiveDetailList;
    }

    public List<JSONObject> getSettleList() {
        return settleList;
    }

    public void setSettleList(List<JSONObject> settleList) {
        this.settleList = settleList;
    }

    public List<JSONObject> getCheckList() {
        return checkList;
    }

    public void setCheckList(List<JSONObject> checkList) {
        this.checkList = checkList;
    }

    public Long getUserReportId() {
        return userReportId;
    }

    public void setUserReportId(Long userReportId) {
        this.userReportId = userReportId;
    }

    public Integer getDeliveryNoticeNum() {
        return deliveryNoticeNum;
    }

    public void setDeliveryNoticeNum(Integer deliveryNoticeNum) {
        this.deliveryNoticeNum = deliveryNoticeNum;
    }

    public List<JSONObject> getDeliveryNoticeList() {
        return deliveryNoticeList;
    }

    public void setDeliveryNoticeList(List<JSONObject> deliveryNoticeList) {
        this.deliveryNoticeList = deliveryNoticeList;
    }
}
