package com.ejianc.business.jlincome.bid.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.jlincome.performance.vo.ForecastRecordVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 投标-工程调研报告
 * 
 * @author generator
 * 
 */
public class EngineeringReportVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态
    private String billCode; // 单据编码
    private String customName; // 客户名称
    private Long orgId; // 组织/区域主键
    private String orgName; // 组织名称/区域名称
    private String orgCode; // 组织编码/区域编码
    private Long projectTypeId; // 项目类型
    private String projectTypeName; // 项目类型名称
    private String productType; // 产品类型
    private String productTypeName; // 产品类型名称
    private String ownerCompany; // 业主单位
    private String designCompany; // 设计单位
    //private Integer isAssist; // 是否需要协助（1 需要，0 不需要）
    private Boolean isAssist; // 是否需要协助（1 需要，0 不需要）
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date expectedDate; // 期望出图时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date estimatedDate; // 预计交货时间
    private BigDecimal estimatedContractMny; // 预计合同金额
    private Long saleLeaderId; // 销售负责人
    private String saleLeaderName; // 销售负责人名称
    private String saleLeaderPhone; // 销售负责人联系电话
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long deptId; // 经办部门
    private String deptName; // 经办部门名称
    private String memo; // 备注
    private Boolean isRepeat; // 是否重复询价
    private Long engineeringId; // 工程主键
    private String engineeringName; // 工程名称
    private String engineeringCode; // 工程编码
    private String changeCode; // 变更版本
    private Integer changeVersion; // 变更版本
    private Long changeId; // 变更主键
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    private Date changeDate; // 变更日期
    private String changeMemo; // 变更原因
    private Date effectDate; // 生效时间
    private Long installLeaderId; // 安装负责人
    private String installLeaderName; // 安装负责人名称
    private String engineeringProgress; // 工程进度

    private List<EngineeringPersonVO> engineeringPersonList = new ArrayList<>(); // 投标-工程调研报告-项目主要负责人
    private List<EngineeringResearchVO> engineeringResearchList = new ArrayList<>(); // 投标-工程调研报告-调研报告内容
    private List<EngineeringReportRecordVO> recordList = new ArrayList<>(); // 变更记录表

    public String getEngineeringProgress() {
        return engineeringProgress;
    }

    public void setEngineeringProgress(String engineeringProgress) {
        this.engineeringProgress = engineeringProgress;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getInstallLeaderId() {
        return installLeaderId;
    }

    @ReferDeserialTransfer
    public void setInstallLeaderId(Long installLeaderId) {
        this.installLeaderId = installLeaderId;
    }

    public String getInstallLeaderName() {
        return installLeaderName;
    }

    public void setInstallLeaderName(String installLeaderName) {
        this.installLeaderName = installLeaderName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getCustomName() {
        return customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Long getProjectTypeId() {
        return projectTypeId;
    }

    public void setProjectTypeId(Long projectTypeId) {
        this.projectTypeId = projectTypeId;
    }
    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }

    public String getProductType() {
        return productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }
    public String getProductTypeName() {
        return productTypeName;
    }

    public void setProductTypeName(String productTypeName) {
        this.productTypeName = productTypeName;
    }
    public String getOwnerCompany() {
        return ownerCompany;
    }

    public void setOwnerCompany(String ownerCompany) {
        this.ownerCompany = ownerCompany;
    }
    public String getDesignCompany() {
        return designCompany;
    }

    public void setDesignCompany(String designCompany) {
        this.designCompany = designCompany;
    }
 /*   public Integer getIsAssist() {
        return isAssist;
    }

    public void setIsAssist(Integer isAssist) {
        this.isAssist = isAssist;
    }*/

    public Boolean getIsAssist() {
        return isAssist;
    }

    public void setIsAssist(Boolean assist) {
        isAssist = assist;
    }

    public Date getExpectedDate() {
        return expectedDate;
    }

    public void setExpectedDate(Date expectedDate) {
        this.expectedDate = expectedDate;
    }
    public Date getEstimatedDate() {
        return estimatedDate;
    }

    public void setEstimatedDate(Date estimatedDate) {
        this.estimatedDate = estimatedDate;
    }
    public BigDecimal getEstimatedContractMny() {
        return estimatedContractMny;
    }

    public void setEstimatedContractMny(BigDecimal estimatedContractMny) {
        this.estimatedContractMny = estimatedContractMny;
    }
    public Long getSaleLeaderId() {
        return saleLeaderId;
    }

    public void setSaleLeaderId(Long saleLeaderId) {
        this.saleLeaderId = saleLeaderId;
    }
    public String getSaleLeaderName() {
        return saleLeaderName;
    }

    public void setSaleLeaderName(String saleLeaderName) {
        this.saleLeaderName = saleLeaderName;
    }
    public String getSaleLeaderPhone() {
        return saleLeaderPhone;
    }

    public void setSaleLeaderPhone(String saleLeaderPhone) {
        this.saleLeaderPhone = saleLeaderPhone;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDeptId() {
        return deptId;
    }
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    @ReferSerialTransfer(referCode="bid-business")
    public Long getEngineeringId() {
        return engineeringId;
    }
    @ReferDeserialTransfer
    public void setEngineeringId(Long engineeringId) {
        this.engineeringId = engineeringId;
    }
    public String getEngineeringName() {
        return engineeringName;
    }

    public void setEngineeringName(String engineeringName) {
        this.engineeringName = engineeringName;
    }
    public String getEngineeringCode() {
        return engineeringCode;
    }

    public void setEngineeringCode(String engineeringCode) {
        this.engineeringCode = engineeringCode;
    }
    
     public List<EngineeringPersonVO> getEngineeringPersonList() {
        return engineeringPersonList;
     }

     public void setEngineeringPersonList(List<EngineeringPersonVO> engineeringPersonList) {
        this.engineeringPersonList = engineeringPersonList;
     }
     public List<EngineeringResearchVO> getEngineeringResearchList() {
        return engineeringResearchList;
     }

     public void setEngineeringResearchList(List<EngineeringResearchVO> engineeringResearchList) {
        this.engineeringResearchList = engineeringResearchList;
     }

    public Boolean getIsRepeat() {
        return isRepeat;
    }

    public void setIsRepeat(Boolean isRepeat) {
        this.isRepeat = isRepeat;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public String getChangeMemo() {
        return changeMemo;
    }

    public void setChangeMemo(String changeMemo) {
        this.changeMemo = changeMemo;
    }

    public Date getEffectDate() {
        return effectDate;
    }

    public void setEffectDate(Date effectDate) {
        this.effectDate = effectDate;
    }

    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }

    public List<EngineeringReportRecordVO> getRecordList() {
        return recordList;
    }

    public void setRecordList(List<EngineeringReportRecordVO> recordList) {
        this.recordList = recordList;
    }
}
