package com.ejianc.business.jlincome.bid.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.jlincome.bid.vo.ResultRegisterDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 投标管理-投标结果登记-主表
 * 
 * @author generator
 * 
 */
public class ResultRegisterVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Integer billState; // 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long orgId; // 组织/区域主键
    private String orgName; // 组织名称/区域名称
    private String orgCode; // 组织编码/区域编码
    private String projectName; // 工程名称
    private String customName; // 客户名称

    private Long projectTypeId; // 项目类型
    private String projectTypeName; // 项目类型名称
    private String productType; // 产品类型
    private String productTypeName; // 产品类型名称

    private Long saleLeaderId; // 销售负责人
    private String saleLeaderName; // 销售负责人名称
    private String saleLeaderPhone; // 销售负责人联系电话
    private String productName; // 产品名称
    private String spec; // 规格型号
    private String num; // 数量
    private BigDecimal bidWinMny; // 中标金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date bidFileReceiveDate; // 招标文件接收日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date bidDate; // 投标日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date bidOpenDate; // 开标日期
    private Long bidUnitId; // 投标单位
    private String bidUnitName; // 投标单位名称
    private String bidUnitCode; // 投标单位编码
    private Boolean bidWinFlag; // 是否中标（0：否 1：是）
    private BigDecimal bidDifMny; // 投标差价
    private Boolean relateInstallFlag; // 是否涉及安装（0：否 1：是）
    private Long installLeaderId; // 安装负责人
    private String installLeaderName; // 安装负责人名称
    private String memo; // 备注
    private BigDecimal bidAvgMny; // 投标平均价（子表投标金额+主表投标金额）/（子表竞标单位行数+1）
    private String bidWinUnitName; // 中标单位名称
    private Integer competeBidUnitNum; // 竞标单位数量
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date projectApprovalDate; // 立项日期
    private String customLinkName; // 客户联系人
    private String customLinkPhone; // 客户联系人电话
    private String contractingUnit; // 总包单位
    private String designUnit; // 设计单位
    private Long nationalId; // 项目国家
    private String nationalName; // 项目国家
    private String area; // 项目地区
    private String areaName; // 项目地区
    private String address; // 详细地址
    private String projectHeight; // 项目高度
    private String projectSpan; // 项目跨度
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planProductDate; // 预计生产日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planDeliverDate; // 预计交货日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planBidWinDate; // 中标日期
    private String projectStatus; // 项目阶段：已中标 未中标
    private String projectSituation; // 工程概况
    private Long sourceId; // 来源id
    private String sourceCode; // 来源编码
    private Integer sourceType; // 来源类型（0：手动新增 1：商机登记）

    private String billStateName; // 单据状态名称
    private String bidWinFlagName; // 是否中标（0：否 1：是）
    private String relateInstallFlagName; // 是否涉及安装（0：否 1：是）
    
    private List<ResultRegisterDetailVO> detailList = new ArrayList<>(); // 投标管理-投标结果登记-子表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getCustomName() {
        return customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }
    public Long getProjectTypeId() {
        return projectTypeId;
    }

    @ReferDeserialTransfer
    public void setProjectTypeId(Long projectTypeId) {
        this.projectTypeId = projectTypeId;
    }
    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }
    public String getProductType() {
        return productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }
    public String getProductTypeName() {
        return productTypeName;
    }

    public void setProductTypeName(String productTypeName) {
        this.productTypeName = productTypeName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getSaleLeaderId() {
        return saleLeaderId;
    }
    @ReferDeserialTransfer
    public void setSaleLeaderId(Long saleLeaderId) {
        this.saleLeaderId = saleLeaderId;
    }
    public String getSaleLeaderName() {
        return saleLeaderName;
    }

    public void setSaleLeaderName(String saleLeaderName) {
        this.saleLeaderName = saleLeaderName;
    }
    public String getSaleLeaderPhone() {
        return saleLeaderPhone;
    }

    public void setSaleLeaderPhone(String saleLeaderPhone) {
        this.saleLeaderPhone = saleLeaderPhone;
    }
    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getNum() {
        return num;
    }

    public void setNum(String num) {
        this.num = num;
    }
    public BigDecimal getBidWinMny() {
        return bidWinMny;
    }

    public void setBidWinMny(BigDecimal bidWinMny) {
        this.bidWinMny = bidWinMny;
    }
    public Date getBidFileReceiveDate() {
        return bidFileReceiveDate;
    }

    public void setBidFileReceiveDate(Date bidFileReceiveDate) {
        this.bidFileReceiveDate = bidFileReceiveDate;
    }

    public Date getBidDate() {
        return bidDate;
    }

    public void setBidDate(Date bidDate) {
        this.bidDate = bidDate;
    }

    public Date getBidOpenDate() {
        return bidOpenDate;
    }

    public void setBidOpenDate(Date bidOpenDate) {
        this.bidOpenDate = bidOpenDate;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getBidUnitId() {
        return bidUnitId;
    }

    @ReferDeserialTransfer
    public void setBidUnitId(Long bidUnitId) {
        this.bidUnitId = bidUnitId;
    }
    public String getBidUnitName() {
        return bidUnitName;
    }

    public void setBidUnitName(String bidUnitName) {
        this.bidUnitName = bidUnitName;
    }
    public String getBidUnitCode() {
        return bidUnitCode;
    }

    public void setBidUnitCode(String bidUnitCode) {
        this.bidUnitCode = bidUnitCode;
    }
    public BigDecimal getBidDifMny() {
        return bidDifMny;
    }

    public void setBidDifMny(BigDecimal bidDifMny) {
        this.bidDifMny = bidDifMny;
    }

    public Boolean getBidWinFlag() {
        return bidWinFlag;
    }

    public void setBidWinFlag(Boolean bidWinFlag) {
        this.bidWinFlag = bidWinFlag;
    }

    public Boolean getRelateInstallFlag() {
        return relateInstallFlag;
    }

    public void setRelateInstallFlag(Boolean relateInstallFlag) {
        this.relateInstallFlag = relateInstallFlag;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getInstallLeaderId() {
        return installLeaderId;
    }

    @ReferDeserialTransfer
    public void setInstallLeaderId(Long installLeaderId) {
        this.installLeaderId = installLeaderId;
    }
    public String getInstallLeaderName() {
        return installLeaderName;
    }

    public void setInstallLeaderName(String installLeaderName) {
        this.installLeaderName = installLeaderName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public BigDecimal getBidAvgMny() {
        return bidAvgMny;
    }

    public void setBidAvgMny(BigDecimal bidAvgMny) {
        this.bidAvgMny = bidAvgMny;
    }
    public String getBidWinUnitName() {
        return bidWinUnitName;
    }

    public void setBidWinUnitName(String bidWinUnitName) {
        this.bidWinUnitName = bidWinUnitName;
    }
    public Integer getCompeteBidUnitNum() {
        return competeBidUnitNum;
    }

    public void setCompeteBidUnitNum(Integer competeBidUnitNum) {
        this.competeBidUnitNum = competeBidUnitNum;
    }

    public Date getProjectApprovalDate() {
        return projectApprovalDate;
    }

    public void setProjectApprovalDate(Date projectApprovalDate) {
        this.projectApprovalDate = projectApprovalDate;
    }

    public String getCustomLinkName() {
        return customLinkName;
    }

    public void setCustomLinkName(String customLinkName) {
        this.customLinkName = customLinkName;
    }
    public String getCustomLinkPhone() {
        return customLinkPhone;
    }

    public void setCustomLinkPhone(String customLinkPhone) {
        this.customLinkPhone = customLinkPhone;
    }
    public String getContractingUnit() {
        return contractingUnit;
    }

    public void setContractingUnit(String contractingUnit) {
        this.contractingUnit = contractingUnit;
    }
    public String getDesignUnit() {
        return designUnit;
    }

    public void setDesignUnit(String designUnit) {
        this.designUnit = designUnit;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getNationalId() {
        return nationalId;
    }

    @ReferDeserialTransfer
    public void setNationalId(Long nationalId) {
        this.nationalId = nationalId;
    }
    public String getNationalName() {
        return nationalName;
    }

    public void setNationalName(String nationalName) {
        this.nationalName = nationalName;
    }
    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }
    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public String getProjectHeight() {
        return projectHeight;
    }

    public void setProjectHeight(String projectHeight) {
        this.projectHeight = projectHeight;
    }
    public String getProjectSpan() {
        return projectSpan;
    }

    public void setProjectSpan(String projectSpan) {
        this.projectSpan = projectSpan;
    }
    public Date getPlanProductDate() {
        return planProductDate;
    }

    public void setPlanProductDate(Date planProductDate) {
        this.planProductDate = planProductDate;
    }
    public Date getPlanDeliverDate() {
        return planDeliverDate;
    }

    public void setPlanDeliverDate(Date planDeliverDate) {
        this.planDeliverDate = planDeliverDate;
    }
    public Date getPlanBidWinDate() {
        return planBidWinDate;
    }

    public void setPlanBidWinDate(Date planBidWinDate) {
        this.planBidWinDate = planBidWinDate;
    }
    public String getProjectStatus() {
        return projectStatus;
    }

    public void setProjectStatus(String projectStatus) {
        this.projectStatus = projectStatus;
    }
    public String getProjectSituation() {
        return projectSituation;
    }

    public void setProjectSituation(String projectSituation) {
        this.projectSituation = projectSituation;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public String getSourceCode() {
        return sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }
    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public List<ResultRegisterDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ResultRegisterDetailVO> detailList) {
        this.detailList = detailList;
    }

    public String getBidWinFlagName() {
        return bidWinFlagName;
    }

    public void setBidWinFlagName(String bidWinFlagName) {
        this.bidWinFlagName = bidWinFlagName;
    }

    public String getRelateInstallFlagName() {
        return relateInstallFlagName;
    }

    public void setRelateInstallFlagName(String relateInstallFlagName) {
        this.relateInstallFlagName = relateInstallFlagName;
    }
}
