package com.ejianc.business.jlincome.report.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.jlincome.report.vo.CooperationDetailVO;
import com.ejianc.business.jlincome.report.vo.CooperationPlanVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 企院（校）合作工作
 *
 * @author generator
 */
public class CooperationVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Integer billState; // 单据状态
    private String billCode; // 单据编码
    private Long orgId; // 区域id
    private String orgName; // 区域名称
    private String orgCode; // 区域编码
    private Long reportId; // 填报人id
    private String reportName; // 填报人名称
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private String reportMonth; // 填报月份
    private String memo; // 备注

    private List<CooperationDetailVO> cooperationDetailList = new ArrayList<>(); // 企院（校）合作工作开展详情
    private List<CooperationPlanVO> cooperationPlanList = new ArrayList<>(); // 企院（校）合作工作开展计划

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    @ReferSerialTransfer(referCode = "idm-user")
    public Long getReportId() {
        return reportId;
    }

    @ReferDeserialTransfer
    public void setReportId(Long reportId) {
        this.reportId = reportId;
    }

    public String getReportName() {
        return reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public String getReportMonth() {
        return reportMonth;
    }

    public void setReportMonth(String reportMonth) {
        this.reportMonth = reportMonth;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public List<CooperationDetailVO> getCooperationDetailList() {
        return cooperationDetailList;
    }

    public void setCooperationDetailList(List<CooperationDetailVO> cooperationDetailList) {
        this.cooperationDetailList = cooperationDetailList;
    }

    public List<CooperationPlanVO> getCooperationPlanList() {
        return cooperationPlanList;
    }

    public void setCooperationPlanList(List<CooperationPlanVO> cooperationPlanList) {
        this.cooperationPlanList = cooperationPlanList;
    }
}
