package com.ejianc.business.jlincome.report.vo;

import com.ejianc.foundation.share.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 已合作重点客户单位市场分析
 * 
 * @author generator
 * 
 */
public class MarketAnalysisReportVO extends BaseVO   implements ITreeNodeB {
    private static final long serialVersionUID = 1L;
    
    private Long orgId; // 区域
    private String orgName; // 区域名称
    private String orgCode; // 区域编码
    private Long employeeId; // 填报人
    private String employeeName; // 填报人名称
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date month; // 填报月份
    private Long detailEmployeeId; // 销售负责人
    private String detailEmployeeName; // 销售负责人名称
    private Long customerId; // 重点客户单位id
    private String customerName; // 重点客户单位名称
    private String customerCode; // 重点客户单位编码
    private BigDecimal lastGccpMny; // 去年工程产品销售额
    private BigDecimal lastSjcpMny; // 去年索具产品销售额
    private BigDecimal gccpSumMny; // 本年工程产品累计完成金额
    private BigDecimal sjcpSumMny; // 本年索具产品累计完成金额
    private BigDecimal ybMny; // 本年本月预报金额
    private BigDecimal yjGccpMny; // 本年预计工程产品销售额
    private BigDecimal yjSjcpMny; // 本年预计索具产品销售额
    private BigDecimal marketScale; // 当前市场占有率

    private List<ITreeNodeB> children;
    private Long parentId; // 父级Id
    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    public Long getDetailEmployeeId() {
        return detailEmployeeId;
    }

    public void setDetailEmployeeId(Long detailEmployeeId) {
        this.detailEmployeeId = detailEmployeeId;
    }

    public String getDetailEmployeeName() {
        return detailEmployeeName;
    }

    public void setDetailEmployeeName(String detailEmployeeName) {
        this.detailEmployeeName = detailEmployeeName;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getCustomerCode() {
        return customerCode;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }

    public BigDecimal getLastGccpMny() {
        return lastGccpMny;
    }

    public void setLastGccpMny(BigDecimal lastGccpMny) {
        this.lastGccpMny = lastGccpMny;
    }

    public BigDecimal getLastSjcpMny() {
        return lastSjcpMny;
    }

    public void setLastSjcpMny(BigDecimal lastSjcpMny) {
        this.lastSjcpMny = lastSjcpMny;
    }

    public BigDecimal getGccpSumMny() {
        return gccpSumMny;
    }

    public void setGccpSumMny(BigDecimal gccpSumMny) {
        this.gccpSumMny = gccpSumMny;
    }

    public BigDecimal getSjcpSumMny() {
        return sjcpSumMny;
    }

    public void setSjcpSumMny(BigDecimal sjcpSumMny) {
        this.sjcpSumMny = sjcpSumMny;
    }

    public BigDecimal getYbMny() {
        return ybMny;
    }

    public void setYbMny(BigDecimal ybMny) {
        this.ybMny = ybMny;
    }

    public BigDecimal getYjGccpMny() {
        return yjGccpMny;
    }

    public void setYjGccpMny(BigDecimal yjGccpMny) {
        this.yjGccpMny = yjGccpMny;
    }

    public BigDecimal getYjSjcpMny() {
        return yjSjcpMny;
    }

    public void setYjSjcpMny(BigDecimal yjSjcpMny) {
        this.yjSjcpMny = yjSjcpMny;
    }

    public BigDecimal getMarketScale() {
        return marketScale;
    }

    public void setMarketScale(BigDecimal marketScale) {
        this.marketScale = marketScale;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getMonth() {
        return month;
    }

    public void setMonth(Date month) {
        this.month = month;
    }
}
