package com.ejianc.business.jlincome.report.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.jlincome.report.vo.MarketAnalysisDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 已合作重点客户单位市场分析
 * 
 * @author generator
 * 
 */
public class MarketAnalysisVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long orgId; // 区域
    private String orgName; // 区域名称
    private String orgCode; // 区域编码
    private Long employeeId; // 填报人
    private String employeeName; // 填报人名称
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date month; // 填报月份
    private String memo; // 备注
    private Integer billState; // 单据状态（审批必须字段）
    
    private List<MarketAnalysisDetailVO> marketAnalysisDetailList = new ArrayList<>(); // 已合作重点客户单位市场分析明细

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getMonth() {
        return month;
    }

    public void setMonth(Date month) {
        this.month = month;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
     public List<MarketAnalysisDetailVO> getMarketAnalysisDetailList() {
        return marketAnalysisDetailList;
     }

     public void setMarketAnalysisDetailList(List<MarketAnalysisDetailVO> marketAnalysisDetailList) {
        this.marketAnalysisDetailList = marketAnalysisDetailList;
     }
}
