package com.ejianc.business.jlincome.report.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.jlincome.report.vo.ReceivableManageDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 应收款分类管理
 * 
 * @author generator
 * 
 */
public class ReceivableManageVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long orgId; // 区域
    private String orgName; // 区域名称
    private String orgCode; // 区域编码
    private Long employeeId; // 填报人
    private String employeeName; // 填报人名称
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date receivableDate; // 填报日期
    private BigDecimal debtMny; // 欠款
    private BigDecimal receivableMny; // 应收
    private BigDecimal intransitMny; // 在途
    private String memo; // 备注
    private Integer billState; // 单据状态（审批必须字段）
    
    private List<ReceivableManageDetailVO> receivableManageDetailList = new ArrayList<>(); // 应收款分类管理明细

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getReceivableDate() {
        return receivableDate;
    }

    public void setReceivableDate(Date receivableDate) {
        this.receivableDate = receivableDate;
    }
    public BigDecimal getDebtMny() {
        return debtMny;
    }

    public void setDebtMny(BigDecimal debtMny) {
        this.debtMny = debtMny;
    }
    public BigDecimal getReceivableMny() {
        return receivableMny;
    }

    public void setReceivableMny(BigDecimal receivableMny) {
        this.receivableMny = receivableMny;
    }
    public BigDecimal getIntransitMny() {
        return intransitMny;
    }

    public void setIntransitMny(BigDecimal intransitMny) {
        this.intransitMny = intransitMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
     public List<ReceivableManageDetailVO> getReceivableManageDetailList() {
        return receivableManageDetailList;
     }

     public void setReceivableManageDetailList(List<ReceivableManageDetailVO> receivableManageDetailList) {
        this.receivableManageDetailList = receivableManageDetailList;
     }
}
