package com.ejianc.business.jlincome.report.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 战略合作/年度协议计划
 *
 * @author generator
 */
public class StrategyPlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long pid; // 主表id
    private String unitName; // 单位名称
    private String duty; // 职务
    private String projectName; // 合作项目名称
    private BigDecimal lastFinish; // 上一年累计完成
    private BigDecimal yearFinish; // 本年累计完成
    private BigDecimal monthForecast; // 本月预报
    private BigDecimal yearForecast; // 本年预报
    private Long employeeId; // 业务负责人id
    private String employeeName; // 业务负责人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signingDate; // 签订日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 截止日期
    private Long ways; // 合作方式
    private Long waysName; // 合作方式


    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getDuty() {
        return duty;
    }

    public void setDuty(String duty) {
        this.duty = duty;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public BigDecimal getLastFinish() {
        return lastFinish;
    }

    public void setLastFinish(BigDecimal lastFinish) {
        this.lastFinish = lastFinish;
    }

    public BigDecimal getYearFinish() {
        return yearFinish;
    }

    public void setYearFinish(BigDecimal yearFinish) {
        this.yearFinish = yearFinish;
    }

    public BigDecimal getMonthForecast() {
        return monthForecast;
    }

    public void setMonthForecast(BigDecimal monthForecast) {
        this.monthForecast = monthForecast;
    }

    public BigDecimal getYearForecast() {
        return yearForecast;
    }

    public void setYearForecast(BigDecimal yearForecast) {
        this.yearForecast = yearForecast;
    }

    @ReferSerialTransfer(referCode = "idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Date getSigningDate() {
        return signingDate;
    }

    public void setSigningDate(Date signingDate) {
        this.signingDate = signingDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @ReferSerialTransfer(referCode = "strategy-ways")

    public Long getWays() {
        return ways;
    }

    @ReferDeserialTransfer
    public void setWays(Long ways) {
        this.ways = ways;
    }

    public Long getWaysName() {
        return waysName;
    }

    public void setWaysName(Long waysName) {
        this.waysName = waysName;
    }
}
