package com.ejianc.business.jlincome.report.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.jlincome.report.vo.StrategyDetailVO;
import com.ejianc.business.jlincome.report.vo.StrategyPlanVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 战略合作/年度协议
 *
 * @author generator
 */
public class StrategyVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Integer billState; // 单据状态
    private String billStateName;
    private String billCode; // 单据编码
    private Long reportId; // 填报人id
    private String reportName; // 填报人名称
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private String reportMonth; // 填报月份
    private String memo; // 备注

    private List<StrategyDetailVO> strategyDetailList = new ArrayList<>(); // 战略合作/年度协议详情
    private List<StrategyPlanVO> strategyPlanList = new ArrayList<>(); // 战略合作/年度协议计划

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode = "idm-user")
    public Long getReportId() {
        return reportId;
    }

    @ReferDeserialTransfer
    public void setReportId(Long reportId) {
        this.reportId = reportId;
    }

    public String getReportName() {
        return reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public String getReportMonth() {
        return reportMonth;
    }

    public void setReportMonth(String reportMonth) {
        this.reportMonth = reportMonth;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public List<StrategyDetailVO> getStrategyDetailList() {
        return strategyDetailList;
    }

    public void setStrategyDetailList(List<StrategyDetailVO> strategyDetailList) {
        this.strategyDetailList = strategyDetailList;
    }

    public List<StrategyPlanVO> getStrategyPlanList() {
        return strategyPlanList;
    }

    public void setStrategyPlanList(List<StrategyPlanVO> strategyPlanList) {
        this.strategyPlanList = strategyPlanList;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
}
