package com.ejianc.business.jlincome.report.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 应收款分类管理明细
 * 
 * @author generator
 * 
 */
public class ReceivableManageDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long manageId; // 主表主键ID
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private Long customerId; // 客户id
    private String customerName; // 客户名称
    private String customerCode; // 客户编码
    private Long detailEmployeeId; // 负责人
    private String detailEmployeeName; // 负责人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date returnDate; // 回款日期
    private BigDecimal debtMny; // 欠款
    private BigDecimal receivableMny; // 应收
    private BigDecimal intransitMny; // 在途
    private String detailMemo; // 欠款存在问题
    private Long orgId; // 区域
    private String orgName; // 区域名称
    private String orgCode; // 区域编码
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date receivableDate; // 填报日期

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Date getReceivableDate() {
        return receivableDate;
    }

    public void setReceivableDate(Date receivableDate) {
        this.receivableDate = receivableDate;
    }

    public Long getManageId() {
        return manageId;
    }

    public void setManageId(Long manageId) {
        this.manageId = manageId;
    }
    @ReferSerialTransfer(referCode = "project-archive")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    @ReferSerialTransfer(referCode="support-customer")
    public Long getCustomerId() {
        return customerId;
    }
    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public String getCustomerCode() {
        return customerCode;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getDetailEmployeeId() {
        return detailEmployeeId;
    }
    @ReferDeserialTransfer
    public void setDetailEmployeeId(Long detailEmployeeId) {
        this.detailEmployeeId = detailEmployeeId;
    }
    public String getDetailEmployeeName() {
        return detailEmployeeName;
    }

    public void setDetailEmployeeName(String detailEmployeeName) {
        this.detailEmployeeName = detailEmployeeName;
    }
    public Date getReturnDate() {
        return returnDate;
    }

    public void setReturnDate(Date returnDate) {
        this.returnDate = returnDate;
    }
    public BigDecimal getDebtMny() {
        return debtMny;
    }

    public void setDebtMny(BigDecimal debtMny) {
        this.debtMny = debtMny;
    }
    public BigDecimal getReceivableMny() {
        return receivableMny;
    }

    public void setReceivableMny(BigDecimal receivableMny) {
        this.receivableMny = receivableMny;
    }
    public BigDecimal getIntransitMny() {
        return intransitMny;
    }

    public void setIntransitMny(BigDecimal intransitMny) {
        this.intransitMny = intransitMny;
    }
    public String getDetailMemo() {
        return detailMemo;
    }

    public void setDetailMemo(String detailMemo) {
        this.detailMemo = detailMemo;
    }
    
}
