package com.ejianc.business.jlincome.report.vo;

import com.ejianc.foundation.share.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 应收款分类管理
 * 
 * @author generator
 * 
 */
public class ReceivableManageReportVO extends BaseVO  implements ITreeNodeB {
    private static final long serialVersionUID = 1L;
    
    private Long orgId; // 区域
    private String orgName; // 区域名称
    private String orgCode; // 区域编码
    private Long employeeId; // 填报人
    private String employeeName; // 填报人名称
    private String receivableDate; // 填报月份
    private BigDecimal debtMny; // 欠款
    private BigDecimal receivableMny; // 应收
    private BigDecimal intransitMny; // 在途

    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private Long customerId; // 客户id
    private String customerName; // 客户名称
    private String customerCode; // 客户编码
    private Long detailEmployeeId; // 负责人
    private String detailEmployeeName; // 负责人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date returnDate; // 回款日期
    private String detailMemo; // 欠款存在问题

    private List<ITreeNodeB> children;
    private Long parentId; // 父级Id
    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getCustomerCode() {
        return customerCode;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }

    public Long getDetailEmployeeId() {
        return detailEmployeeId;
    }

    public void setDetailEmployeeId(Long detailEmployeeId) {
        this.detailEmployeeId = detailEmployeeId;
    }

    public String getDetailEmployeeName() {
        return detailEmployeeName;
    }

    public void setDetailEmployeeName(String detailEmployeeName) {
        this.detailEmployeeName = detailEmployeeName;
    }

    public Date getReturnDate() {
        return returnDate;
    }

    public void setReturnDate(Date returnDate) {
        this.returnDate = returnDate;
    }

    public String getDetailMemo() {
        return detailMemo;
    }

    public void setDetailMemo(String detailMemo) {
        this.detailMemo = detailMemo;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getReceivableDate() {
        return receivableDate;
    }

    public void setReceivableDate(String receivableDate) {
        this.receivableDate = receivableDate;
    }

    public BigDecimal getDebtMny() {
        return debtMny;
    }

    public void setDebtMny(BigDecimal debtMny) {
        this.debtMny = debtMny;
    }
    public BigDecimal getReceivableMny() {
        return receivableMny;
    }

    public void setReceivableMny(BigDecimal receivableMny) {
        this.receivableMny = receivableMny;
    }
    public BigDecimal getIntransitMny() {
        return intransitMny;
    }

    public void setIntransitMny(BigDecimal intransitMny) {
        this.intransitMny = intransitMny;
    }
}
